/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolproInput;

public class BasisXmlToMolproIntInput
extends BasisXmlToMolproInput {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        Iterator iterator = descriptionList.iterator();
        while (iterator.hasNext()) {
            Element description = (Element)iterator.next();
            output.append("! " + elementName.toUpperCase() + "       " + description.getValue() + "\n");
            iterator.remove();
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        int i;
        StringBuffer molproOutput = new StringBuffer();
        super.readCmlMatrix(molproOutput, matrices, element, shell);
        String molpro = new String(molproOutput);
        String[] getline = molpro.split("\n");
        Vector<String> matrixValues = new Vector<String>();
        Vector<String> positions = new Vector<String>();
        String tmp = getline[0].split(",")[1];
        if (!element.equalsIgnoreCase(tmp.trim())) {
            throw new FormatException(" element mismatch " + element + " != " + tmp + " ");
        }
        int numContractions = getline.length - 1;
        int numExponents = getline[0].split(",").length - 2;
        for (i = 0; i < getline.length; ++i) {
            String[] tokenize = getline[i].split(",");
            if (i != 0) {
                positions.add(tokenize[1]);
            }
            for (int j = 2; j < tokenize.length; ++j) {
                matrixValues.add(tokenize[j]);
            }
        }
        output.append(element.toUpperCase() + "  " + shell + "  " + this.mTitle);
        output.append(" :    " + numExponents + "    " + numContractions);
        for (i = 0; i < positions.size(); ++i) {
            output.append("   " + (String)positions.get(i));
        }
        output.append("\n");
        for (i = 0; i < matrixValues.size(); ++i) {
            if (i % 5 == 0) {
                output.append("\n");
            }
            output.append(this.formattedValue((String)matrixValues.get(i)));
        }
        output.append("\n");
    }
}

