require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_HP300_CPU_H_)) {
    eval 'sub _HP300_CPU_H_ () {1;}' unless defined(&_HP300_CPU_H_);
    require 'm68k/cpu.ph';
    if(defined(&_KERNEL)) {
	require 'machine/intr.ph';
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> &sr &  &PSL_S) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> &pc));
	}' unless defined(&CLKF_PC);
	if(0) {
	    eval 'sub CLKF_INTR {
	        my($framep) = @_;
    		eval q(((($framep)-> &sr &  &PSL_M) == 0));
	    }' unless defined(&CLKF_INTR);
	} else {
	    eval 'sub CLKF_INTR {
	        my($framep) = @_;
    		eval q((0));
	    }' unless defined(&CLKF_INTR);
	}
	eval 'sub need_resched {
	    my($ci) = @_;
    	    eval q({  &want_resched = 1;  &aston(); });
	}' unless defined(&need_resched);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q( &want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston());
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    my($p) = @_;
    	    eval q( &aston());
	}' unless defined(&signotify);
	eval 'sub aston () {
	    eval q(( &astpending = 1));
	}' unless defined(&aston);
    }
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_CPUSPEED () {2;}' unless defined(&CPU_CPUSPEED);
    eval 'sub CPU_MACHINEID () {3;}' unless defined(&CPU_MACHINEID);
    eval 'sub CPU_MMUID () {4;}' unless defined(&CPU_MMUID);
    eval 'sub CPU_MAXID () {5;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "cpuspeed",  &CTLTYPE_INT }, { "machineid",  &CTLTYPE_INT }, { "mmuid",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
    }
    eval 'sub ROMBASE () {(0x);}' unless defined(&ROMBASE);
    eval 'sub INTIOBASE () {(0x400000);}' unless defined(&INTIOBASE);
    eval 'sub INTIOTOP () {(0x600000);}' unless defined(&INTIOTOP);
    eval 'sub MAXADDR () {(0xfffff000);}' unless defined(&MAXADDR);
    eval 'sub ISIIOVA {
        my($va) = @_;
	    eval q(( >=  &intiobase  && ($va) <  &intiolimit));
    }' unless defined(&ISIIOVA);
    eval 'sub IIOV {
        my($pa) = @_;
	    eval q((- &INTIOBASE+ &intiobase));
    }' unless defined(&IIOV);
    eval 'sub IIOP {
        my($va) = @_;
	    eval q((- &intiobase+ &INTIOBASE));
    }' unless defined(&IIOP);
    eval 'sub IIOPOFF {
        my($pa) = @_;
	    eval q((($pa)- &INTIOBASE));
    }' unless defined(&IIOPOFF);
    eval 'sub IIOMAPSIZE () { &atop( &INTIOTOP- &INTIOBASE);}' unless defined(&IIOMAPSIZE);
    eval 'sub MMUBASE () { &IIOPOFF(0x5f4000);}' unless defined(&MMUBASE);
    eval 'sub MMUSSTP () {0x;}' unless defined(&MMUSSTP);
    eval 'sub MMUUSTP () {0x4;}' unless defined(&MMUUSTP);
    eval 'sub MMUTBINVAL () {0x8;}' unless defined(&MMUTBINVAL);
    eval 'sub MMUSTAT () {0xc;}' unless defined(&MMUSTAT);
    eval 'sub MMUCMD () { &MMUSTAT;}' unless defined(&MMUCMD);
    eval 'sub MMU_UMEN () {0x1;}' unless defined(&MMU_UMEN);
    eval 'sub MMU_SMEN () {0x2;}' unless defined(&MMU_SMEN);
    eval 'sub MMU_CEN () {0x4;}' unless defined(&MMU_CEN);
    eval 'sub MMU_BERR () {0x8;}' unless defined(&MMU_BERR);
    eval 'sub MMU_IEN () {0x20;}' unless defined(&MMU_IEN);
    eval 'sub MMU_FPE () {0x40;}' unless defined(&MMU_FPE);
    eval 'sub MMU_WPF () {0x2000;}' unless defined(&MMU_WPF);
    eval 'sub MMU_PF () {0x4000;}' unless defined(&MMU_PF);
    eval 'sub MMU_PTF () {0x8000;}' unless defined(&MMU_PTF);
    eval 'sub MMU_FAULT () {( &MMU_PTF| &MMU_PF| &MMU_WPF| &MMU_BERR);}' unless defined(&MMU_FAULT);
    eval 'sub MMU_ENAB () {( &MMU_UMEN| &MMU_SMEN| &MMU_IEN| &MMU_FPE);}' unless defined(&MMU_ENAB);
}
1;
