require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_ACPI_ACPIVAR_H_)) {
    eval 'sub _DEV_ACPI_ACPIVAR_H_ () {1;}' unless defined(&_DEV_ACPI_ACPIVAR_H_);
    eval 'sub ACPI_TRAMPOLINE () {( &NBPG*4);}' unless defined(&ACPI_TRAMPOLINE);
    unless(defined(&_ACPI_WAKECODE)) {
	require 'sys/timeout.ph';
	require 'sys/rwlock.ph';
	require 'machine/biosvar.ph';
	if(defined(&ACPI_DEBUG)) {
	    eval 'sub dprintf () {( &x...)  &do {  &if ( &acpi_debug)  &printf( &x); }  &while (0);}' unless defined(&dprintf);
	    eval 'sub dnprintf () {( &n, &x...)  &do {  &if ( &acpi_debug > ( &n))  &printf( &x); }  &while (0);}' unless defined(&dnprintf);
	} else {
	    eval 'sub dprintf () {( &x...);}' unless defined(&dprintf);
	    eval 'sub dnprintf () {( &n, &x...);}' unless defined(&dnprintf);
	}
	eval 'sub LAPIC_MAP_SIZE () {256;}' unless defined(&LAPIC_MAP_SIZE);
	eval 'sub ACPIREG_PM1A_STS () {0x;}' unless defined(&ACPIREG_PM1A_STS);
	eval 'sub ACPIREG_PM1A_EN () {0x1;}' unless defined(&ACPIREG_PM1A_EN);
	eval 'sub ACPIREG_PM1A_CNT () {0x2;}' unless defined(&ACPIREG_PM1A_CNT);
	eval 'sub ACPIREG_PM1B_STS () {0x3;}' unless defined(&ACPIREG_PM1B_STS);
	eval 'sub ACPIREG_PM1B_EN () {0x4;}' unless defined(&ACPIREG_PM1B_EN);
	eval 'sub ACPIREG_PM1B_CNT () {0x5;}' unless defined(&ACPIREG_PM1B_CNT);
	eval 'sub ACPIREG_PM2_CNT () {0x6;}' unless defined(&ACPIREG_PM2_CNT);
	eval 'sub ACPIREG_PM_TMR () {0x7;}' unless defined(&ACPIREG_PM_TMR);
	eval 'sub ACPIREG_GPE0_STS () {0x8;}' unless defined(&ACPIREG_GPE0_STS);
	eval 'sub ACPIREG_GPE0_EN () {0x9;}' unless defined(&ACPIREG_GPE0_EN);
	eval 'sub ACPIREG_GPE1_STS () {0xa;}' unless defined(&ACPIREG_GPE1_STS);
	eval 'sub ACPIREG_GPE1_EN () {0xb;}' unless defined(&ACPIREG_GPE1_EN);
	eval 'sub ACPIREG_SMICMD () {0xc;}' unless defined(&ACPIREG_SMICMD);
	eval 'sub ACPIREG_MAXREG () {0xd;}' unless defined(&ACPIREG_MAXREG);
	eval 'sub ACPIREG_PM1_STS () {0xe;}' unless defined(&ACPIREG_PM1_STS);
	eval 'sub ACPIREG_PM1_EN () {0xf;}' unless defined(&ACPIREG_PM1_EN);
	eval 'sub ACPIREG_PM1_CNT () {0x10;}' unless defined(&ACPIREG_PM1_CNT);
	eval 'sub ACPIREG_GPE_STS () {0x11;}' unless defined(&ACPIREG_GPE_STS);
	eval 'sub ACPIREG_GPE_EN () {0x12;}' unless defined(&ACPIREG_GPE_EN);
	eval 'sub ACPI_SST_INDICATOR_OFF () {0;}' unless defined(&ACPI_SST_INDICATOR_OFF);
	eval 'sub ACPI_SST_WORKING () {1;}' unless defined(&ACPI_SST_WORKING);
	eval 'sub ACPI_SST_WAKING () {2;}' unless defined(&ACPI_SST_WAKING);
	eval 'sub ACPI_SST_SLEEPING () {3;}' unless defined(&ACPI_SST_SLEEPING);
	eval 'sub ACPI_SST_SLEEP_CONTEXT () {4;}' unless defined(&ACPI_SST_SLEEP_CONTEXT);
	eval 'sub ACPI_MTX_MAXNAME () {5;}' unless defined(&ACPI_MTX_MAXNAME);
	if(0) {
	}
	eval 'sub GPE_NONE () {0x;}' unless defined(&GPE_NONE);
	eval 'sub GPE_LEVEL () {0x1;}' unless defined(&GPE_LEVEL);
	eval 'sub GPE_EDGE () {0x2;}' unless defined(&GPE_EDGE);
	eval 'sub ACPI_IOC_GETFACS () { &_IOR(ord(\'A\'), 0, \'struct acpi_facs\');}' unless defined(&ACPI_IOC_GETFACS);
	eval 'sub ACPI_IOC_GETTABLE () { &_IOWR(ord(\'A\'), 1, \'struct acpi_table\');}' unless defined(&ACPI_IOC_GETTABLE);
	eval 'sub ACPI_IOC_SETSLEEPSTATE () { &_IOW(ord(\'A\'), 2, \'int\');}' unless defined(&ACPI_IOC_SETSLEEPSTATE);
	eval 'sub ACPI_EV_PWRBTN () {0x1;}' unless defined(&ACPI_EV_PWRBTN);
	eval 'sub ACPI_EV_SLPBTN () {0x2;}' unless defined(&ACPI_EV_SLPBTN);
	eval 'sub ACPI_EVENT_MASK () {0x3;}' unless defined(&ACPI_EVENT_MASK);
	eval 'sub ACPI_EVENT_COMPOSE {
	    my($t,$i) = @_;
    	    eval q(((($i) & 0x7fff) << 16| (($t) &  &ACPI_EVENT_MASK)));
	}' unless defined(&ACPI_EVENT_COMPOSE);
	eval 'sub ACPI_EVENT_TYPE {
	    my($e) = @_;
    	    eval q((($e) &  &ACPI_EVENT_MASK));
	}' unless defined(&ACPI_EVENT_TYPE);
	eval 'sub ACPI_EVENT_INDEX {
	    my($e) = @_;
    	    eval q((($e) >> 16));
	}' unless defined(&ACPI_EVENT_INDEX);
	if(defined( &_KERNEL)) {
	    eval 'sub ACPI_IOREAD () {0;}' unless defined(&ACPI_IOREAD);
	    eval 'sub ACPI_IOWRITE () {1;}' unless defined(&ACPI_IOWRITE);
	}
    }
}
1;
