/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.lang.GetOpt;
import com.darwinsys.sql.Configuration;
import com.darwinsys.sql.ConnectionUtil;
import com.darwinsys.sql.SQLRunner;
import com.darwinsys.util.Verbosity;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Scanner;

public class SQLRunnerCLI {
    private static void doHelp(int i) {
        System.out.println("Usage: SQLRunner [-f configFile] [-c config] [SQLscript[ ...]");
        System.exit(i);
    }

    public static void main(String[] args) {
        char c;
        String config = "default";
        String outputModeName = "t";
        String outputFile = null;
        GetOpt go = new GetOpt("dvf:c:m:o:");
        while ((c = go.getopt(args)) != '\u0000') {
            switch (c) {
                case 'h': {
                    SQLRunnerCLI.doHelp(0);
                    break;
                }
                case 'd': {
                    SQLRunner.setVerbosity(Verbosity.DEBUG);
                    break;
                }
                case 'v': {
                    SQLRunner.setVerbosity(Verbosity.VERBOSE);
                    break;
                }
                case 'f': {
                    ConnectionUtil.setConfigFileName(go.optarg());
                    break;
                }
                case 'c': {
                    config = go.optarg();
                    break;
                }
                case 'm': {
                    outputModeName = go.optarg();
                    break;
                }
                case 'o': {
                    outputFile = go.optarg();
                    break;
                }
                default: {
                    System.err.println("Unknown option character " + c);
                    SQLRunnerCLI.doHelp(1);
                }
            }
        }
        try {
            Configuration conf = ConnectionUtil.getConfiguration(config);
            if (!conf.hasPassword()) {
                System.err.printf("Enter password for connection %s: ", config);
                System.err.flush();
                Scanner sc = new Scanner(System.in);
                String newPass = sc.next();
                conf.setPassword(newPass);
            }
            Connection conn = ConnectionUtil.getConnection(conf);
            SQLRunner prog = new SQLRunner(conn, outputFile, outputModeName);
            if (go.getOptInd() == args.length) {
                SQLRunnerCLI.runScript(prog, new BufferedReader(new InputStreamReader(System.in)), "(standard input)");
            } else {
                int i = go.getOptInd() - 1;
                while (i < args.length) {
                    SQLRunnerCLI.runScript(prog, args[i]);
                    ++i;
                }
            }
            prog.close();
        }
        catch (SQLException ex) {
            throw new DataBaseException(ex.toString());
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
        catch (ClassNotFoundException ex) {
            throw new DataBaseException(ex.toString());
        }
        System.exit(0);
    }

    static void runScript(SQLRunner prog, String scriptFile) throws IOException, SQLException {
        BufferedReader is = new BufferedReader(new FileReader(scriptFile));
        SQLRunnerCLI.runScript(prog, is, scriptFile);
    }

    static void runScript(SQLRunner prog, BufferedReader is, String name) throws IOException {
        String stmt;
        System.out.printf("SQLRunner: starting %s%n", name);
        while ((stmt = SQLRunner.getStatement(is)) != null) {
            stmt = stmt.trim();
            try {
                prog.runStatement(stmt);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        System.out.printf("SQLRunner: %s done.%n", name);
    }
}

