/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.epic.core.util.StatusFactory;

public class MarkerUtilities {
    private static IMarker[] EMPTY_ARRAY;
    private ILog log;
    private String pluginId;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.core.util.MarkerUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_ARRAY = new IMarker[0];
    }

    public MarkerUtilities(ILog log, String pluginId) {
        this.log = log;
        this.pluginId = pluginId;
    }

    public void createMarker(IResource resource, String type, Map attributes) {
        if (!$assertionsDisabled && attributes == null) {
            throw new AssertionError();
        }
        try {
            IMarker marker = resource.createMarker(type);
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            this.log.log(StatusFactory.createError(this.pluginId, "unable to create marker", e));
        }
    }

    public IMarker[] getMarkersForLine(IResource resource, int lineNumber) {
        return this.getMarkersForLine(resource, null, lineNumber);
    }

    public boolean isMarkerPresent(IResource resource, String markerType, String text, int lineNumber) {
        IMarker[] markers = this.getMarkersForLine(resource, markerType, lineNumber);
        if (markers.length == 0) {
            return false;
        }
        int i = 0;
        while (i < markers.length) {
            String markerText = (String)this.getAttribute(markers[i], "message");
            if (markerText != null && markerText.equals(text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IMarker[] getMarkersForLine(IResource resource, String markerType, int lineNumber) {
        IMarker[] markers = this.findMarkers(resource, markerType);
        if (markers.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<IMarker> list = new ArrayList<IMarker>();
        int i = 0;
        while (i < markers.length) {
            Integer markerLineNumber = (Integer)this.getAttribute(markers[i], "lineNumber");
            if (markerLineNumber != null && markerLineNumber == lineNumber) {
                list.add(markers[i]);
            }
            ++i;
        }
        return list.toArray(new IMarker[list.size()]);
    }

    private Object getAttribute(IMarker marker, String key) {
        try {
            return marker.getAttribute(key);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void deleteMarkers(IResource resource, String type) {
        if (!$assertionsDisabled && !this.isNotNullOrEmpty(type)) {
            throw new AssertionError();
        }
        IMarker[] toDelete = this.findMarkers(resource, type);
        if (toDelete.length == 0) {
            return;
        }
        try {
            resource.getWorkspace().deleteMarkers(toDelete);
        }
        catch (CoreException e) {
            this.log.log(StatusFactory.createError(this.pluginId, "unable to delete markers", e));
        }
    }

    public void setLineNumber(Map attributes, int lineNumber) {
        attributes.put("lineNumber", new Integer(lineNumber));
    }

    public void setMessage(Map attributes, String message) {
        attributes.put("message", message);
    }

    public void setSeverity(Map attributes, int severity) {
        this.setSeverity(attributes, new Integer(severity));
    }

    public void setSeverity(Map attributes, Integer severity) {
        if (!($assertionsDisabled || severity >= 0 && severity <= 2)) {
            throw new AssertionError();
        }
        attributes.put("severity", severity);
    }

    public void setStartEnd(Map attributes, int start, int end) {
        if (!($assertionsDisabled || start >= 0 && end >= 0)) {
            throw new AssertionError();
        }
        attributes.put("charStart", new Integer(start));
        if (end == 0) {
            end = start;
        }
        attributes.put("charEnd", new Integer(end));
    }

    private IMarker[] findMarkers(IResource resource, String type) {
        try {
            return resource.findMarkers(type, true, 2);
        }
        catch (CoreException e) {
            this.log.log(StatusFactory.createError(this.pluginId, "unable to find markers", e));
            return EMPTY_ARRAY;
        }
    }

    private boolean isNotNullOrEmpty(String s) {
        return s != null && !"".equals(s);
    }
}

