/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathContainer;

public class OpenIvyFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        IStructuredSelection s;
        Object o;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel instanceof IStructuredSelection && (o = (s = (IStructuredSelection)sel).getFirstElement()) instanceof ClassPathContainer) {
            IPath path = ((ClassPathContainer)o).getClasspathEntry().getPath();
            IJavaProject project = ((ClassPathContainer)o).getJavaProject();
            try {
                IClasspathContainer fContainer = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project);
                if (fContainer instanceof IvyClasspathContainer) {
                    IvyClasspathContainer ivycp = (IvyClasspathContainer)fContainer;
                    IFile file = ivycp.getIvyFile();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (file != null) {
                        try {
                            String editorId = "org.jayasoft.ivyde.editors.IvyEditor";
                            page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
                            IDE.setDefaultEditor((IFile)file, (String)editorId);
                        }
                        catch (PartInitException e) {
                            DialogUtil.openError((Shell)page.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenWithMenu_dialogTitle, (String)e.getMessage(), (PartInitException)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

