/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.template.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.rubypeople.rdt.internal.corext.Assert;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContext;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.MultiVariable;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.VariablePosition;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class TemplateProposal
implements IRubyCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;

    public TemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image) {
        Assert.isNotNull(template);
        Assert.isNotNull(templateContext);
        Assert.isNotNull(iRegion);
        this.fTemplate = template;
        this.fContext = templateContext;
        this.fImage = image;
        this.fRegion = iRegion;
        this.fDisplayString = null;
        this.fRelevance = this.computeRelevance();
    }

    private int computeRelevance() {
        int n = 8;
        try {
            if (this.fContext instanceof DocumentTemplateContext) {
                DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
                IDocument iDocument = documentTemplateContext.getDocument();
                String string = iDocument.get(this.fRegion.getOffset(), this.fRegion.getLength());
                if (this.fTemplate.getName().startsWith(string)) {
                    n += 10;
                }
                if (this.fTemplate.getName().equalsIgnoreCase(string)) {
                    n += 4;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return n * 16 + 1;
    }

    public final void apply(IDocument iDocument) {
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        try {
            TemplateVariable templateVariable;
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int n3 = this.getReplaceOffset();
            int n4 = this.getReplaceEndOffset();
            n4 = Math.max(n4, n2);
            IDocument iDocument = iTextViewer.getDocument();
            String string = templateBuffer.getString();
            iDocument.replace(n3, n4 - n3, string);
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
            MultiVariableGuess multiVariableGuess = this.fContext instanceof RubyScriptContext ? ((RubyScriptContext)this.fContext).getMultiVariableGuess() : null;
            boolean bl = false;
            int n5 = 0;
            while (n5 != templateVariableArray.length) {
                templateVariable = templateVariableArray[n5];
                if (!templateVariable.isUnambiguous()) {
                    VariablePosition variablePosition;
                    LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                    int[] nArray = templateVariable.getOffsets();
                    int n6 = templateVariable.getLength();
                    if (multiVariableGuess != null && templateVariable instanceof MultiVariable) {
                        variablePosition = new VariablePosition(iDocument, nArray[0] + n3, n6, multiVariableGuess, (MultiVariable)templateVariable);
                        multiVariableGuess.addSlave(variablePosition);
                    } else {
                        String[] stringArray = templateVariable.getValues();
                        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[stringArray.length];
                        int n7 = 0;
                        while (n7 < stringArray.length) {
                            this.ensurePositionCategoryInstalled(iDocument, linkedModeModel);
                            Position position = new Position(nArray[0] + n3, n6);
                            iDocument.addPosition(this.getCategory(), position);
                            iCompletionProposalArray[n7] = new PositionBasedCompletionProposal(stringArray[n7], position, n6);
                            ++n7;
                        }
                        variablePosition = iCompletionProposalArray.length > 1 ? new ProposalPosition(iDocument, nArray[0] + n3, n6, iCompletionProposalArray) : new LinkedPosition(iDocument, nArray[0] + n3, n6);
                    }
                    int n8 = 0;
                    while (n8 != nArray.length) {
                        if (n8 == 0) {
                            linkedPositionGroup.addPosition((LinkedPosition)variablePosition);
                        } else {
                            linkedPositionGroup.addPosition(new LinkedPosition(iDocument, nArray[n8] + n3, n6));
                        }
                        ++n8;
                    }
                    linkedModeModel.addGroup(linkedPositionGroup);
                    bl = true;
                }
                ++n5;
            }
            if (bl) {
                linkedModeModel.forceInstall();
                RubyEditor rubyEditor = this.getRubyEditor();
                templateVariable = new EditorLinkedModeUI(linkedModeModel, iTextViewer);
                templateVariable.setExitPosition(iTextViewer, this.getCaretOffset(templateBuffer) + n3, 0, Integer.MAX_VALUE);
                templateVariable.enter();
                this.fSelectedRegion = templateVariable.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + n3, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            RubyPlugin.log(badLocationException);
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badLocationException));
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            RubyPlugin.log(badPositionCategoryException);
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badPositionCategoryException));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private RubyEditor getRubyEditor() {
        IEditorPart iEditorPart = RubyPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof RubyEditor) {
            return (RubyEditor)iEditorPart;
        }
        return null;
    }

    private int getReplaceOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getStart();
        } else {
            n = this.fRegion.getOffset();
        }
        return n;
    }

    private int getReplaceEndOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getEnd();
        } else {
            n = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return n;
    }

    private void ensurePositionCategoryInstalled(final IDocument iDocument, LinkedModeModel linkedModeModel) {
        if (!iDocument.containsPositionCategory(this.getCategory())) {
            iDocument.addPositionCategory(this.getCategory());
            final InclusivePositionUpdater inclusivePositionUpdater = new InclusivePositionUpdater(this.getCategory());
            iDocument.addPositionUpdater((IPositionUpdater)inclusivePositionUpdater);
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel linkedModeModel, int n) {
                    try {
                        iDocument.removePositionCategory(TemplateProposal.this.getCategory());
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                    iDocument.removePositionUpdater((IPositionUpdater)inclusivePositionUpdater);
                }

                public void suspend(LinkedModeModel linkedModeModel) {
                }

                public void resume(LinkedModeModel linkedModeModel, int n) {
                }
            });
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer templateBuffer) {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor")) {
                return templateVariable.getOffsets()[0];
            }
            ++n;
        }
        return templateBuffer.getString().length();
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
            return templateBuffer.getString();
        }
        catch (BadLocationException badLocationException) {
            this.handleException(RubyPlugin.getActiveWorkbenchShell(), new CoreException((IStatus)new Status(4, RubyPlugin.getPluginId(), 0, "", (Throwable)badLocationException)));
            return null;
        }
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            Object[] objectArray = new String[]{this.fTemplate.getName(), this.fTemplate.getDescription()};
            this.fDisplayString = Messages.format(TemplateContentAssistMessages.TemplateProposal_displayString, objectArray);
        }
        return this.fDisplayString;
    }

    public void setDisplayString(String string) {
        this.fDisplayString = string;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)exception.getMessage());
    }

    private void handleException(Shell shell, CoreException coreException) {
        ExceptionHandler.handle(coreException, shell, TemplateContentAssistMessages.TemplateEvaluator_error_title, null);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new TemplateInformationControlCreator();
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        try {
            int n2 = this.getReplaceOffset();
            if (n >= n2) {
                String string = iDocument.get(n2, n - n2);
                return this.fTemplate.getName().toLowerCase().startsWith(string.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        if (this.isSelectionTemplate()) {
            return "";
        }
        return this.fTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplaceOffset();
    }

    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.fTemplate.isAutoInsertable();
    }

    private boolean isSelectionTemplate() {
        DocumentTemplateContext documentTemplateContext;
        return this.fContext instanceof DocumentTemplateContext && (documentTemplateContext = (DocumentTemplateContext)this.fContext).getCompletionLength() > 0;
    }
}

