/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class MarkMergedSynchronizeOperation
extends SVNSynchronizeOperation {
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;

    public MarkMergedSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final IResource[] resources = set.getResources();
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                int i = 0;
                while (i < resources.length) {
                    File tempFile = null;
                    try {
                        tempFile = MarkMergedSynchronizeOperation.this.copyToTempFile(resources[i]);
                    }
                    catch (Exception e) {
                        SVNUIPlugin.log(e.getMessage());
                    }
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                    if (svnResource instanceof LocalResource) {
                        ((LocalResource)svnResource).revert(false);
                    } else {
                        svnResource.revert();
                    }
                    new UpdateOperation(MarkMergedSynchronizeOperation.this.getPart(), resources[i], SVNRevision.HEAD).run(monitor);
                    File file = new File(resources[i].getLocation().toString());
                    try {
                        MarkMergedSynchronizeOperation.this.copy(tempFile, file);
                    }
                    catch (Exception e1) {
                        SVNUIPlugin.log(e1.getMessage());
                    }
                    tempFile.delete();
                    ++i;
                }
            }
        }, false, 2);
    }

    public File copyToTempFile(IResource resource) throws Exception {
        File tempFile = new File(resource.getLocation() + ".tmp");
        if (tempFile.exists()) {
            tempFile = this.getTempFile(resource);
        }
        File sourceFile = new File(resource.getLocation().toString());
        this.copy(sourceFile, tempFile);
        return tempFile;
    }

    private File getTempFile(IResource resource) {
        int count = 1;
        while (new File(resource.getLocation() + "." + count + ".tmp").exists()) {
            ++count;
        }
        File tempFile = new File(resource.getLocation() + "." + count + ".tmp");
        return tempFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(File sourceFile, File destFile) throws Exception {
        FileInputStream in;
        block5: {
            in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceFile);
                out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (out != null) {
                    out.close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (out == null) break block5;
            }
            out.close();
        }
        if (in == null) return;
        in.close();
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNUIPlugin.getPlugin().getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }
}

