/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.IStartup;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.audio.Audio;

public class Startup
implements IStartup {
    public void startup() {
        Trace.trace(Trace.FINEST, "Audio startup");
        PublishAdapter publishListener = new PublishAdapter(){

            public void publishFinished(IServer server, IStatus status) {
                Audio.playSound("org.eclipse.wst.server.sound.publishFinished");
            }
        };
        final IServerListener serverListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17) {
                    int state = server.getServerState();
                    if (state == 2) {
                        Audio.playSound("org.eclipse.wst.server.sound.serverStart");
                    } else if (state == 4) {
                        Audio.playSound("org.eclipse.wst.server.sound.serverStop");
                    }
                }
            }
        };
        IServerLifecycleListener listener = new IServerLifecycleListener((IPublishListener)publishListener){
            private final /* synthetic */ IPublishListener val$publishListener;
            {
                this.val$publishListener = iPublishListener;
            }

            public void serverAdded(IServer server) {
                server.addServerListener(serverListener);
                ((Server)server).addPublishListener(this.val$publishListener);
            }

            public void serverChanged(IServer server) {
            }

            public void serverRemoved(IServer server) {
                server.removeServerListener(serverListener);
                ((Server)server).removePublishListener(this.val$publishListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)listener);
    }
}

