/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.internal.registry.osgi.EclipseBundleListener;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class RegistryStrategyOSGI
extends RegistryStrategy {
    private Object token;
    protected boolean DEBUG;
    protected boolean DEBUG_REGISTRY_EVENTS;
    private ServiceTracker xmlTracker = null;
    private static float DEFAULT_BUNDLECACHE_LOADFACTOR = 0.75f;
    private static int DEFAULT_BUNDLECACHE_SIZE = 200;
    private ReferenceMap bundleMap = new ReferenceMap(1, DEFAULT_BUNDLECACHE_SIZE, DEFAULT_BUNDLECACHE_LOADFACTOR);
    private EclipseBundleListener pluginBundleListener = null;

    public RegistryStrategyOSGI(File[] theStorageDir, boolean[] cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly);
        this.token = key;
    }

    public final String translate(String key, ResourceBundle resources) {
        return ResourceTranslator.getResourceString(null, (String)key, (ResourceBundle)resources);
    }

    private Bundle getBundle(String id) {
        long OSGiId;
        if (id == null) {
            return null;
        }
        try {
            OSGiId = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Bundle bundle = (Bundle)this.bundleMap.get((int)OSGiId);
        if (bundle != null) {
            return bundle;
        }
        bundle = Activator.getContext().getBundle(OSGiId);
        this.bundleMap.put((int)OSGiId, bundle);
        return bundle;
    }

    public Object createExecutableExtension(RegistryContributor contributor, String className, String overridenContributorName) throws CoreException {
        Bundle contributingBundle = overridenContributorName != null && !overridenContributorName.equals("") ? OSGIUtils.getDefault().getBundle(overridenContributorName) : this.getBundle(contributor.getId());
        if (contributingBundle == null) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)"UNKNOWN BUNDLE", (Object)className), new InvalidRegistryObjectException());
        }
        Class classInstance = null;
        try {
            classInstance = contributingBundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e1);
        }
        catch (LinkageError e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e);
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, message, exception));
    }

    public void onStart(IExtensionRegistry registry) {
        super.onStart(registry);
        if (!(registry instanceof ExtensionRegistry)) {
            return;
        }
        ExtensionRegistry theRegistry = (ExtensionRegistry)registry;
        this.pluginBundleListener = new EclipseBundleListener(theRegistry, this.token);
        Activator.getContext().addBundleListener((BundleListener)this.pluginBundleListener);
        if (!theRegistry.filledFromCache()) {
            this.pluginBundleListener.processBundles(Activator.getContext().getBundles());
        }
    }

    public void onStop(IExtensionRegistry registry) {
        if (this.pluginBundleListener != null) {
            Activator.getContext().removeBundleListener((BundleListener)this.pluginBundleListener);
        }
        if (this.xmlTracker != null) {
            this.xmlTracker.close();
            this.xmlTracker = null;
        }
        super.onStop(registry);
    }

    public boolean cacheUse() {
        return !"true".equals(RegistryProperties.getProperty("eclipse.noRegistryCache"));
    }

    public boolean cacheLazyLoading() {
        return !"true".equalsIgnoreCase(RegistryProperties.getProperty("eclipse.noLazyRegistryCacheLoading"));
    }

    public long getContributionsTimestamp() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            return 0L;
        }
        if (!"true".equalsIgnoreCase(context.getProperty("osgi.checkConfiguration"))) {
            return 0L;
        }
        Bundle[] allBundles = context.getBundles();
        long result = 0L;
        int i = 0;
        while (i < allBundles.length) {
            URL pluginManifest = allBundles[i].getEntry("plugin.xml");
            if (pluginManifest == null) {
                pluginManifest = allBundles[i].getEntry("fragment.xml");
            }
            if (pluginManifest != null) {
                try {
                    URLConnection connection = pluginManifest.openConnection();
                    result ^= connection.getLastModified() + allBundles[i].getBundleId();
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            ++i;
        }
        return result;
    }

    public SAXParserFactory getXMLParser() {
        if (this.xmlTracker == null) {
            this.xmlTracker = new ServiceTracker(Activator.getContext(), SAXParserFactory.class.getName(), null);
            this.xmlTracker.open();
        }
        return (SAXParserFactory)this.xmlTracker.getService();
    }
}

