/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.internal.ui.actions.context.StandardActionAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousDisconnectAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.ui.IDebugUIConstants;

public class DisconnectAdapter
extends StandardActionAdapter
implements IAsynchronousDisconnectAdapter {
    public void canDisconnect(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Job job = new Job("canDisconnect"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = DisconnectAdapter.this.getTarget(element);
                if (disconnect != null) {
                    requestMonitor.setResult(disconnect.canDisconnect());
                } else {
                    requestMonitor.setResult(false);
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.createUpdateSchedulingRule());
        job.schedule();
    }

    public void isDisconnected(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Job job = new Job("isDisconnected"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = DisconnectAdapter.this.getTarget(element);
                if (disconnect != null) {
                    requestMonitor.setResult(disconnect.isDisconnected());
                } else {
                    requestMonitor.setResult(false);
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.createUpdateSchedulingRule());
        job.schedule();
    }

    public void disconnect(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Job job = new Job("isDisconnected"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = DisconnectAdapter.this.getTarget(element);
                if (disconnect == null) {
                    requestMonitor.setStatus((IStatus)new Status(4, IDebugUIConstants.PLUGIN_ID, 120, "element must be an instance of or adapt to IDisconnect", null));
                } else {
                    try {
                        disconnect.disconnect();
                    }
                    catch (DebugException e) {
                        requestMonitor.setStatus(e.getStatus());
                    }
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IDisconnect getTarget(Object element) {
        if (element instanceof IDisconnect) {
            return (IDisconnect)element;
        }
        if (element instanceof IAdaptable) {
            return (IDisconnect)((IAdaptable)element).getAdapter(IDisconnect.class);
        }
        return null;
    }
}

