/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.Updater;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Indexer
extends Updater {
    private void indexJarFile(StringBuffer stringBuffer, File file, boolean bl) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (bl) {
            object3 = MessageFormat.format(Messages.getString("Indexer.Indexing"), file);
            System.err.println((String)object3);
        }
        object3 = new JarFile(file);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Enumeration<JarEntry> enumeration = ((JarFile)object3).entries();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = ((ZipEntry)object2).getName();
            if (((String)object).startsWith("META-INF/")) continue;
            int n = ((String)object).lastIndexOf(47);
            if (n != -1) {
                object = ((String)object).substring(0, n);
            }
            linkedHashSet.add(object);
        }
        if (!linkedHashSet.isEmpty()) {
            stringBuffer.append(file);
            stringBuffer.append('\n');
            object2 = linkedHashSet.iterator();
            while (object2.hasNext()) {
                stringBuffer.append(object2.next());
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        if ((object2 = ((JarFile)object3).getManifest()) != null) {
            object = file.getParentFile();
            Attributes attributes = ((Manifest)object2).getMainAttributes();
            String string = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.indexJarFile(stringBuffer, new File((File)object, string2), bl);
                }
            }
        }
        ((ZipFile)object3).close();
    }

    protected void writeCommandLineEntries(Main main, OutputStream outputStream) throws IOException {
        super.writeCommandLineEntries(main, outputStream);
        StringBuffer stringBuffer = new StringBuffer();
        this.indexJarFile(stringBuffer, main.archiveFile, main.verbose);
        if (stringBuffer.length() != 0) {
            stringBuffer.insert(0, "1.0\n\n");
            stringBuffer.insert(0, "JarIndex-Version: ");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            this.writeFile(false, byteArrayInputStream, "META-INF/INDEX.LIST", main.verbose);
        }
    }
}

