/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;

public final class CertificateEntry
extends PrimitiveEntry {
    public static final int TYPE = 5;
    private Certificate certificate;

    public CertificateEntry(Certificate certificate, Date date, Properties properties) {
        super(5, date, properties);
        if (certificate == null) {
            throw new IllegalArgumentException("no certificate");
        }
        this.certificate = certificate;
        this.properties.put("type", certificate.getType());
    }

    private CertificateEntry() {
        super(5);
    }

    public static CertificateEntry decode(DataInputStream dataInputStream) throws IOException {
        CertificateEntry certificateEntry = new CertificateEntry();
        certificateEntry.properties.decode(dataInputStream);
        certificateEntry.makeCreationDate();
        String string = certificateEntry.properties.get("type");
        if (string == null) {
            throw new MalformedKeyringException("no certificate type");
        }
        int n = dataInputStream.readInt();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(string);
            certificateEntry.certificate = certificateFactory.generateCertificate(meteredInputStream);
        }
        catch (CertificateException certificateException) {
            throw new MalformedKeyringException(certificateException.toString());
        }
        if (!meteredInputStream.limitReached()) {
            throw new MalformedKeyringException("extra data at end of payload");
        }
        return certificateEntry;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    protected void encodePayload() throws IOException {
        try {
            this.payload = this.certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException.toString());
        }
    }
}

