/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.PasswordProtectedEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.logging.Logger;

public class PasswordEncryptedEntry
extends MaskableEnvelopeEntry
implements PasswordProtectedEntry,
Registry {
    private static final Logger log = Logger.getLogger(PasswordEncryptedEntry.class$("gnu.javax.crypto.keyring.PasswordEncryptedEntry").getName());
    public static final int TYPE = 1;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PasswordEncryptedEntry(String string, String string2, int n, Properties properties) {
        super(1, properties);
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("cipher nor mode can be empty");
        }
        this.properties.put("cipher", string);
        this.properties.put("mode", string2);
        this.properties.put("keylen", String.valueOf(n));
        this.setMasked(false);
    }

    private PasswordEncryptedEntry() {
        super(1);
        this.setMasked(true);
    }

    public static PasswordEncryptedEntry decode(DataInputStream dataInputStream, char[] cArray) throws IOException {
        PasswordEncryptedEntry passwordEncryptedEntry = PasswordEncryptedEntry.decode(dataInputStream);
        try {
            passwordEncryptedEntry.decrypt(cArray);
        }
        catch (WrongPaddingException wrongPaddingException) {
            throw new MalformedKeyringException("wrong padding in decrypted data");
        }
        return passwordEncryptedEntry;
    }

    public static PasswordEncryptedEntry decode(DataInputStream dataInputStream) throws IOException {
        PasswordEncryptedEntry passwordEncryptedEntry = new PasswordEncryptedEntry();
        passwordEncryptedEntry.defaultDecode(dataInputStream);
        return passwordEncryptedEntry;
    }

    public void decrypt(char[] cArray) throws IllegalArgumentException, WrongPaddingException {
        block3: {
            if (!this.isMasked() || this.payload == null) break block3;
            long l = -System.currentTimeMillis();
            IMode iMode = this.getMode(cArray, 2);
            IPad iPad = PadFactory.getInstance("PKCS7");
            iPad.init(iMode.currentBlockSize());
            byte[] byArray = new byte[this.payload.length];
            int n = 0;
            while (n + iMode.currentBlockSize() <= this.payload.length) {
                iMode.update(this.payload, n, byArray, n);
                n += iMode.currentBlockSize();
            }
            int n2 = iPad.unpad(byArray, 0, byArray.length);
            this.setMasked(false);
            int n3 = byArray.length - n2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n3);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                this.decodeEnvelope(dataInputStream);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("decryption failed");
            }
            log.fine("Decrypted in " + (l += System.currentTimeMillis()) + "ms.");
        }
    }

    public void encrypt(char[] cArray) throws IOException {
        Object object;
        long l = -System.currentTimeMillis();
        long l2 = -System.currentTimeMillis();
        byte[] byArray = new byte[8];
        PRNG.getInstance().nextBytes(byArray);
        l2 += System.currentTimeMillis();
        this.properties.put("salt", Util.toString(byArray));
        IMode iMode = this.getMode(cArray, 1);
        IPad iPad = PadFactory.getInstance("PKCS7");
        iPad.init(iMode.currentBlockSize());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Object object2 = this.entries.iterator();
        while (object2.hasNext()) {
            object = (Entry)object2.next();
            l2 = -System.currentTimeMillis();
            ((Entry)object).encode(dataOutputStream);
            l2 += System.currentTimeMillis();
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = iPad.pad((byte[])object2, 0, ((Object)object2).length);
        this.payload = new byte[((Object)object2).length + ((Object)object).length];
        byte[] byArray2 = new byte[iMode.currentBlockSize()];
        int n = iMode.currentBlockSize() - ((Object)object).length;
        System.arraycopy(object2, ((Object)object2).length - n, byArray2, 0, n);
        System.arraycopy(object, 0, byArray2, n, ((Object)object).length);
        int n2 = 0;
        while (n2 + iMode.currentBlockSize() < ((Object)object2).length) {
            iMode.update((byte[])object2, n2, this.payload, n2);
            n2 += iMode.currentBlockSize();
        }
        iMode.update(byArray2, 0, this.payload, n2);
        this.setMasked(true);
        l += System.currentTimeMillis();
    }

    public void encode(DataOutputStream dataOutputStream, char[] cArray) throws IOException {
        this.encrypt(cArray);
        this.encode(dataOutputStream);
    }

    protected void encodePayload() throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("not encrypted");
        }
    }

    private IMode getMode(char[] cArray, int n) {
        String string;
        IMode iMode;
        String string2 = this.properties.get("salt");
        if (string2 == null) {
            throw new IllegalArgumentException("no salt");
        }
        byte[] byArray = Util.toBytesFromString(string2);
        IBlockCipher iBlockCipher = CipherFactory.getInstance(this.properties.get("cipher"));
        if (iBlockCipher == null) {
            throw new IllegalArgumentException("no such cipher: " + this.properties.get("cipher"));
        }
        int n2 = iBlockCipher.defaultBlockSize();
        if (this.properties.containsKey("block-size")) {
            try {
                n2 = Integer.parseInt(this.properties.get("block-size"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("bad block size: " + numberFormatException.getMessage());
            }
        }
        if ((iMode = ModeFactory.getInstance(string = this.properties.get("mode"), iBlockCipher, n2)) == null) {
            throw new IllegalArgumentException("no such mode: " + string);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.password", cArray);
        hashMap.put("gnu.crypto.pbe.salt", byArray);
        hashMap.put("gnu.crypto.pbe.iteration.count", PasswordProtectedEntry.ITERATION_COUNT);
        IRandom iRandom = PRNGFactory.getInstance("PBKDF2-HMAC-SHA");
        iRandom.init(hashMap);
        int n3 = 0;
        if (!this.properties.containsKey("keylen")) {
            throw new IllegalArgumentException("no key length");
        }
        try {
            n3 = Integer.parseInt(this.properties.get("keylen"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n2];
        try {
            iRandom.nextBytes(byArray2, 0, n3);
            iRandom.nextBytes(byArray3, 0, n2);
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.toString());
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put("gnu.crypto.cipher.key.material", byArray2);
        hashMap2.put("gnu.crypto.mode.state", n);
        hashMap2.put("gnu.crypto.mode.iv", byArray3);
        try {
            iMode.init(hashMap2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException.toString());
        }
        return iMode;
    }
}

