/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGDecoder;
import gnu.javax.imageio.png.PNGEncoder;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGGamma;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class PNGFile {
    private static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] endChunk = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private Vector chunks;
    private PNGHeader header;
    private boolean hasPalette;
    private int width;
    private int height;
    private PNGDecoder decoder;
    private PNGEncoder encoder;
    private BufferedImage sourceImage;

    public PNGFile(InputStream inputStream) throws IOException, PNGException {
        byte[] byArray = new byte[8];
        this.chunks = new Vector();
        this.hasPalette = false;
        if (inputStream.read(byArray) != 8) {
            throw new IOException("Could not read file header.");
        }
        if (!this.validateHeader(byArray)) {
            throw new PNGException("Invalid file header. Not a PNG file.");
        }
        PNGChunk pNGChunk = PNGChunk.readChunk(inputStream, false);
        if (!(pNGChunk instanceof PNGHeader)) {
            throw new PNGException("First chunk not a header chunk.");
        }
        this.header = (PNGHeader)pNGChunk;
        if (!this.header.isValidChunk()) {
            throw new PNGException("First chunk not a valid header.");
        }
        System.out.println(this.header);
        this.decoder = new PNGDecoder(this.header);
        do {
            if ((pNGChunk = PNGChunk.readChunk(inputStream, false)).isValidChunk()) {
                if (pNGChunk instanceof PNGData) {
                    this.decoder.addData((PNGData)pNGChunk);
                    continue;
                }
                if (pNGChunk.getType() == 1229278788) continue;
                this.chunks.add(pNGChunk);
                this.hasPalette |= pNGChunk instanceof PNGPalette;
                continue;
            }
            System.out.println("WARNING: Invalid chunk!");
        } while (pNGChunk.getType() != 1229278788);
        if (this.header.isIndexed() && !this.hasPalette) {
            throw new PNGException("File is indexed color and has no palette.");
        }
        this.width = this.header.getWidth();
        this.height = this.header.getHeight();
    }

    public PNGFile(BufferedImage bufferedImage) throws PNGException {
        this.sourceImage = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.chunks = new Vector();
        this.encoder = new PNGEncoder(bufferedImage);
        this.header = this.encoder.getHeader();
        if (this.header.isIndexed()) {
            this.chunks.add(this.encoder.getPalette());
        }
        this.chunks.addAll(this.encoder.encodeImage());
    }

    public void writePNG(OutputStream outputStream) throws IOException {
        outputStream.write(signature);
        this.header.writeChunk(outputStream);
        for (int i = 0; i < this.chunks.size(); ++i) {
            PNGChunk pNGChunk = (PNGChunk)this.chunks.elementAt(i);
            pNGChunk.writeChunk(outputStream);
        }
        outputStream.write(endChunk);
    }

    private boolean validateHeader(byte[] byArray) {
        if (byArray.length != 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (signature[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public BufferedImage getBufferedImage() {
        ColorModel colorModel;
        if (this.decoder == null) {
            return this.sourceImage;
        }
        WritableRaster writableRaster = this.decoder.getRaster(this.header);
        if (this.header.isIndexed()) {
            PNGPalette pNGPalette = this.getPalette();
            colorModel = pNGPalette.getPalette(this.getColorSpace());
        } else {
            colorModel = this.decoder.getColorModel(this.getColorSpace(), this.header.getColorType(), this.header.getDepth());
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    private PNGPalette getPalette() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (!(this.chunks.elementAt(i) instanceof PNGPalette)) continue;
            return (PNGPalette)this.chunks.elementAt(i);
        }
        return null;
    }

    private ColorSpace getColorSpace() {
        PNGICCProfile pNGICCProfile = null;
        PNGGamma pNGGamma = null;
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (this.chunks.elementAt(i) instanceof PNGICCProfile) {
                pNGICCProfile = (PNGICCProfile)this.chunks.elementAt(i);
                continue;
            }
            if (!(this.chunks.elementAt(i) instanceof PNGGamma)) continue;
            pNGGamma = (PNGGamma)this.chunks.elementAt(i);
        }
        if (pNGICCProfile != null) {
            return pNGICCProfile.getColorSpace();
        }
        return null;
    }
}

