/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class DropTargetContext
implements Serializable {
    static final long serialVersionUID = -634158968993743371L;
    private DropTarget dropTarget;
    private int targetActions;
    private DropTargetContextPeer dtcp;

    DropTargetContext(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public Component getComponent() {
        return this.dropTarget.getComponent();
    }

    public void addNotify(DropTargetContextPeer dropTargetContextPeer) {
        this.dtcp = dropTargetContextPeer;
    }

    public void removeNotify() {
        this.dtcp = null;
    }

    protected void setTargetActions(int n) {
        this.targetActions = n;
    }

    protected int getTargetActions() {
        return this.targetActions;
    }

    public void dropComplete(boolean bl) {
        if (this.dtcp != null) {
            this.dtcp.dropComplete(bl);
        }
    }

    protected void acceptDrag(int n) {
        if (this.dtcp != null) {
            this.dtcp.acceptDrag(n);
        }
    }

    protected void rejectDrag() {
        if (this.dtcp != null) {
            this.dtcp.rejectDrag();
        }
    }

    protected void acceptDrop(int n) {
        if (this.dtcp != null) {
            this.dtcp.acceptDrop(n);
        }
    }

    protected void rejectDrop() {
        if (this.dtcp != null) {
            this.dtcp.rejectDrop();
        }
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        if (this.dtcp != null) {
            this.dtcp.getTransferDataFlavors();
        }
        return null;
    }

    protected List getCurrentDataFlavorsAsList() {
        return Arrays.asList(this.getCurrentDataFlavors());
    }

    protected boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getCurrentDataFlavorsAsList().contains(dataFlavor);
    }

    protected Transferable getTransferable() throws InvalidDnDOperationException {
        if (this.dtcp != null) {
            return this.dtcp.getTransferable();
        }
        return null;
    }

    protected Transferable createTransferableProxy(Transferable transferable, boolean bl) {
        return new TransferableProxy(this, transferable, bl);
    }

    protected class TransferableProxy
    implements Transferable {
        private /* synthetic */ DropTargetContext this$0;
        protected boolean isLocal;
        protected Transferable transferable;

        TransferableProxy(DropTargetContext dropTargetContext, Transferable transferable, boolean bl) {
            this.this$0 = dropTargetContext;
            this.transferable = transferable;
            this.isLocal = bl;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.transferable.isDataFlavorSupported(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.transferable.getTransferData(dataFlavor);
        }
    }
}

