/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import gnu.classpath.ServiceFactory;
import gnu.javax.print.CupsPrintServiceLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;

public abstract class PrintServiceLookup {
    private static final CupsPrintServiceLookup systemProvider = new CupsPrintServiceLookup();
    private static final HashSet printServices = new HashSet();
    private static final HashSet printServiceLookups = new HashSet();

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static boolean registerServiceProvider(PrintServiceLookup printServiceLookup) {
        return printServiceLookups.add(printServiceLookup);
    }

    public static boolean registerService(PrintService printService) {
        if (printService instanceof StreamPrintService) {
            return false;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
            return printServices.add(printService);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static final PrintService[] lookupPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = systemProvider.getPrintServices(docFlavor, attributeSet);
        arrayList.addAll(Arrays.asList(objectArray));
        Iterator iterator = printServiceLookups.iterator();
        while (iterator.hasNext()) {
            object = (PrintServiceLookup)iterator.next();
            objectArray = ((PrintServiceLookup)object).getPrintServices(docFlavor, attributeSet);
            arrayList.addAll(Arrays.asList(objectArray));
        }
        iterator = printServices.iterator();
        while (iterator.hasNext()) {
            object = (PrintService)iterator.next();
            if (!systemProvider.checkPrintService(docFlavor, attributeSet, (PrintService)object)) continue;
            arrayList.add(object);
        }
        return (PrintService[])arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = systemProvider.getMultiDocPrintServices(docFlavorArray, attributeSet);
        arrayList.addAll(Arrays.asList(objectArray));
        Iterator iterator = printServiceLookups.iterator();
        while (iterator.hasNext()) {
            object = (PrintServiceLookup)iterator.next();
            objectArray = ((PrintServiceLookup)object).getMultiDocPrintServices(docFlavorArray, attributeSet);
            arrayList.addAll(Arrays.asList(objectArray));
        }
        iterator = printServices.iterator();
        while (iterator.hasNext()) {
            object = (PrintService)iterator.next();
            if (!systemProvider.checkMultiDocPrintService(docFlavorArray, attributeSet, (PrintService)object)) continue;
            arrayList.add(object);
        }
        return (MultiDocPrintService[])arrayList.toArray(new MultiDocPrintService[arrayList.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        PrintService printService = systemProvider.getDefaultPrintService();
        if (printService != null) {
            return printService;
        }
        Iterator iterator = printServiceLookups.iterator();
        while (iterator.hasNext()) {
            printService = ((PrintServiceLookup)iterator.next()).getDefaultPrintService();
            if (printService == null) continue;
            return printService;
        }
        return null;
    }

    public abstract PrintService getDefaultPrintService();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);

    static {
        Iterator iterator = ServiceFactory.lookupProviders(PrintServiceLookup.class$("javax.print.PrintServiceLookup"));
        while (iterator.hasNext()) {
            printServiceLookups.add(iterator.next());
        }
    }
}

