/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    protected KeyStroke closeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke minimizeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    protected DesktopManager desktopManager;
    protected JDesktopPane desktop;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        Color color = this.desktop.getBackground();
        if (color == null || color instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("desktop"));
        }
    }

    protected void installDesktopManager() {
        this.desktopManager = new DefaultDesktopManager();
        this.desktop.setDesktopManager(this.desktopManager);
    }

    protected void installKeyboardActions() {
        this.registerKeyboardActions();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JDesktopPane) {
            this.desktop = (JDesktopPane)jComponent;
            this.installDefaults();
            this.installDesktopManager();
            this.installKeyboardActions();
        }
    }

    protected void registerKeyboardActions() {
    }

    protected void uninstallDefaults() {
        this.desktop.setBackground(null);
    }

    protected void uninstallDesktopManager() {
        this.desktopManager = null;
        this.desktop.setDesktopManager(null);
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
    }

    protected void unregisterKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected class OpenAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                try {
                    if (jInternalFrame.isIcon()) {
                        jInternalFrame.setIcon(false);
                    } else if (jInternalFrame.isMaximum()) {
                        jInternalFrame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }

        protected OpenAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JInternalFrame[] jInternalFrameArray = this.this$0.desktop.getAllFrames();
            if (jInternalFrameArray.length == 0) {
                return;
            }
            JInternalFrame jInternalFrame = jInternalFrameArray[0];
            if (this.this$0.desktop.getSelectedFrame() != null) {
                jInternalFrame = this.this$0.desktop.getSelectedFrame();
            }
            for (n = 0; n < jInternalFrameArray.length && jInternalFrameArray[n] != jInternalFrame; ++n) {
            }
            if (n == jInternalFrameArray.length) {
                n = 0;
            }
            this.this$0.desktop.setSelectedFrame(jInternalFrameArray[n]);
        }

        public boolean isEnabled() {
            return true;
        }

        protected NavigateAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isIconifiable();
            }
            return false;
        }

        protected MinimizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isMaximizable();
            }
            return false;
        }

        protected MaximizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isClosable();
            }
            return false;
        }

        protected CloseAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }
}

