/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.webdav.WebDavFileSystem;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class WebdavFileObject
extends AbstractFileObject
implements FileObject {
    private final WebDavFileSystem fileSystem;
    private final String urlCharset;
    private WebdavResource resource;
    private boolean redirectionResolved = false;
    private Set allowedMethods = null;
    private static volatile int tmpFileCount = 0;
    private static final Object tmpFileCountSync = new Object();

    protected WebdavFileObject(GenericFileName name, WebDavFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
        this.urlCharset = WebdavFileSystemConfigBuilder.getInstance().getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    protected void doAttach() throws Exception {
        if (this.resource == null) {
            this.setDavResource(null);
        }
    }

    protected void doDetach() throws Exception {
        if (this.resource != null) {
            this.redirectionResolved = false;
            this.allowedMethods = null;
            this.resource.close();
            this.resource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDavResource(WebdavResource resource) throws Exception {
        String pathEncoded;
        this.redirectionResolved = false;
        URLFileName name = (URLFileName)this.getName();
        if (resource == null) {
            pathEncoded = name.getPathQueryEncoded(this.urlCharset);
            HttpURL url = new HttpURL(name.getUserName(), name.getPassword(), name.getHostName(), name.getPort());
            url.setEscapedPath(pathEncoded);
            resource = new WebdavResource(this.fileSystem.getClient()){};
            resource.setHttpURL(url, 1, 1);
        }
        this.resource = resource;
        pathEncoded = name.getPathQueryEncoded(this.urlCharset);
        OptionsMethod optionsMethod = new OptionsMethod(pathEncoded);
        try {
            optionsMethod.setFollowRedirects(true);
            int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
            if (status < 200 || status > 299) {
                if (status == 401 || status == 403) {
                    this.setAllowedMethods(null);
                    this.processParentDavResource();
                    return;
                }
                this.injectType(FileType.IMAGINARY);
                return;
            }
            this.redirectionResolved = true;
            resource.getHttpURL().setEscapedPath(optionsMethod.getURI().getPath());
            this.setAllowedMethods(optionsMethod.getAllowedMethods());
            boolean exists = false;
            Enumeration enumeration = optionsMethod.getAllowedMethods();
            while (enumeration.hasMoreElements()) {
                String method = (String)enumeration.nextElement();
                if (!method.equals("COPY")) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.injectType(FileType.IMAGINARY);
                return;
            }
            try {
                resource.setProperties(4, 1);
            }
            catch (IOException e) {
                throw new FileSystemException(e);
            }
        }
        finally {
            optionsMethod.releaseConnection();
        }
        ResourceTypeProperty resourceType = resource.getResourceType();
        if (resourceType.isCollection()) {
            this.injectType(FileType.FOLDER);
        } else {
            this.injectType(FileType.FILE);
        }
    }

    private void setAllowedMethods(Enumeration allowedMethods) {
        this.allowedMethods = new TreeSet();
        if (allowedMethods == null) {
            return;
        }
        while (allowedMethods.hasMoreElements()) {
            this.allowedMethods.add(allowedMethods.nextElement());
        }
    }

    private boolean hasAllowedMethods(String method) throws IOException {
        if (this.allowedMethods == null) {
            this.getAllowedMethods();
        }
        return this.allowedMethods.contains(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveRedirection() throws IOException, FileSystemException {
        if (this.redirectionResolved) {
            return;
        }
        OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
        try {
            optionsMethod.setFollowRedirects(true);
            int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
            if (status >= 200 && status <= 299) {
                this.setAllowedMethods(optionsMethod.getAllowedMethods());
                this.resource.getHttpURL().setEscapedPath(optionsMethod.getPath());
                this.redirectionResolved = true;
            }
        }
        finally {
            optionsMethod.releaseConnection();
        }
    }

    private void processParentDavResource() throws FileSystemException {
        WebdavFileObject parent = (WebdavFileObject)this.getParent();
        try {
            parent.doListChildrenResolved();
        }
        catch (Exception e) {
            throw new FileSystemException(e);
        }
    }

    protected FileType doGetType() throws Exception {
        throw new IllegalStateException("this should not happen");
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        this.doAttach();
        WebdavResource[] children = new WebdavResource[]{};
        try {
            children = this.resource.listWebdavResources();
        }
        catch (HttpException e) {
            if (e.getReasonCode() == 301 || e.getReasonCode() == 302) {
                this.resolveRedirection();
                children = this.resource.listWebdavResources();
            }
            throw e;
        }
        if (children == null) {
            throw new FileSystemException("vfs.provider.webdav/list-children.error", this.resource.getStatusMessage());
        }
        ArrayList<WebdavFileObject> vfs = new ArrayList<WebdavFileObject>(children.length);
        for (int i = 0; i < children.length; ++i) {
            WebdavResource dav = children[i];
            String davName = dav.getHttpURL().getEscapedName();
            if ("".equals(davName)) continue;
            WebdavFileObject fo = (WebdavFileObject)this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), davName, NameScope.CHILD));
            fo.setDavResource(dav);
            vfs.add(fo);
        }
        return vfs.toArray(new WebdavFileObject[vfs.size()]);
    }

    protected void doCreateFolder() throws Exception {
        this.resource.getHttpURL().setPath(this.getName().getPathDecoded() + '/');
        boolean ok = this.resource.mkcolMethod();
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.resource.getStatusMessage());
        }
        this.reattach();
    }

    protected void doDelete() throws Exception {
        this.resolveRedirection();
        boolean ok = this.resource.deleteMethod();
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/delete-file.error", this.resource.getStatusMessage());
        }
        this.reattach();
    }

    protected void doRename(FileObject newfile) throws Exception {
        boolean ok = this.resource.moveMethod(newfile.getName().getPath());
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/rename-file.error", this.resource.getStatusMessage());
        }
        this.reattach();
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.resource.getMethodData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        int fileCount;
        Object object = tmpFileCountSync;
        synchronized (object) {
            fileCount = ++tmpFileCount;
        }
        FileObject webdavTmp = this.getFileSystem().getFileSystemManager().resolveFile("tmp://webdav_tmp.c" + fileCount);
        return new WebdavOutputStream(webdavTmp);
    }

    protected long doGetContentSize() throws Exception {
        return this.resource.getGetContentLength();
    }

    protected void handleCreate(FileType newType) throws Exception {
        this.reattach();
        super.handleCreate(newType);
    }

    private void reattach() throws FileSystemException {
        try {
            this.doDetach();
            this.doAttach();
        }
        catch (Exception e) {
            throw new FileSystemException(e);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.resource.getGetLastModified();
    }

    protected Map doGetAttributes() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Enumeration e = this.resource.propfindMethod(0);
        while (e.hasMoreElements()) {
            XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)e.nextElement();
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                BaseProperty property = (BaseProperty)properties.nextElement();
                attributes.put(property.getLocalName(), property.getPropertyAsString());
            }
        }
        return attributes;
    }

    protected boolean doIsReadable() throws Exception {
        return this.hasAllowedMethods("GET");
    }

    protected boolean doIsWriteable() throws Exception {
        return this.hasAllowedMethods("DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllowedMethods() throws IOException {
        if (this.allowedMethods != null) {
            return;
        }
        OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
        try {
            optionsMethod.setFollowRedirects(true);
            int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
            if (!(status >= 200 && status <= 299 || status != 401 && status != 403)) {
                this.setAllowedMethods(null);
                return;
            }
            this.setAllowedMethods(optionsMethod.getAllowedMethods());
        }
        finally {
            optionsMethod.releaseConnection();
        }
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new WebdavRandomAccesContent(this, mode);
    }

    public static class WebdavRandomAccesContent
    extends AbstractRandomAccessContent {
        private final WebdavFileObject fileObject;
        protected long filePointer = 0L;
        private DataInputStream dis = null;
        private InputStream mis = null;

        protected WebdavRandomAccesContent(WebdavFileObject fileObject, RandomAccessMode mode) {
            super(mode);
            this.fileObject = fileObject;
        }

        public long getFilePointer() throws IOException {
            return this.filePointer;
        }

        public void seek(long pos) throws IOException {
            if (pos == this.filePointer) {
                return;
            }
            if (pos < 0L) {
                throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(pos)});
            }
            if (this.dis != null) {
                this.close();
            }
            this.filePointer = pos;
        }

        private void createStream() throws IOException {
            if (this.dis != null) {
                return;
            }
            this.fileObject.resource.addRequestHeader("Range", "bytes=" + this.filePointer + "-");
            InputStream data = this.fileObject.resource.getMethodData();
            int status = this.fileObject.resource.getStatusCode();
            if (status != 206) {
                data.close();
                throw new FileSystemException("vfs.provider.http/get-range.error", new Object[]{this.fileObject.getName(), new Long(this.filePointer)});
            }
            this.mis = data;
            this.dis = new DataInputStream(new FilterInputStream(this.mis){

                public int read() throws IOException {
                    int ret = super.read();
                    if (ret > -1) {
                        ++WebdavRandomAccesContent.this.filePointer;
                    }
                    return ret;
                }

                public int read(byte[] b) throws IOException {
                    int ret = super.read(b);
                    if (ret > -1) {
                        WebdavRandomAccesContent.this.filePointer += (long)ret;
                    }
                    return ret;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    int ret = super.read(b, off, len);
                    if (ret > -1) {
                        WebdavRandomAccesContent.this.filePointer += (long)ret;
                    }
                    return ret;
                }
            });
        }

        public void close() throws IOException {
            if (this.dis != null) {
                this.dis.close();
                this.dis = null;
                this.mis = null;
            }
        }

        public long length() throws IOException {
            return this.fileObject.getContent().getSize();
        }

        public byte readByte() throws IOException {
            this.createStream();
            byte data = this.dis.readByte();
            return data;
        }

        public char readChar() throws IOException {
            this.createStream();
            char data = this.dis.readChar();
            return data;
        }

        public double readDouble() throws IOException {
            this.createStream();
            double data = this.dis.readDouble();
            return data;
        }

        public float readFloat() throws IOException {
            this.createStream();
            float data = this.dis.readFloat();
            return data;
        }

        public int readInt() throws IOException {
            this.createStream();
            int data = this.dis.readInt();
            return data;
        }

        public int readUnsignedByte() throws IOException {
            this.createStream();
            int data = this.dis.readUnsignedByte();
            return data;
        }

        public int readUnsignedShort() throws IOException {
            this.createStream();
            int data = this.dis.readUnsignedShort();
            return data;
        }

        public long readLong() throws IOException {
            this.createStream();
            long data = this.dis.readLong();
            return data;
        }

        public short readShort() throws IOException {
            this.createStream();
            short data = this.dis.readShort();
            return data;
        }

        public boolean readBoolean() throws IOException {
            this.createStream();
            boolean data = this.dis.readBoolean();
            return data;
        }

        public int skipBytes(int n) throws IOException {
            this.createStream();
            int data = this.dis.skipBytes(n);
            return data;
        }

        public void readFully(byte[] b) throws IOException {
            this.createStream();
            this.dis.readFully(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.createStream();
            this.dis.readFully(b, off, len);
        }

        public String readUTF() throws IOException {
            this.createStream();
            String data = this.dis.readUTF();
            return data;
        }

        public InputStream getInputStream() throws IOException {
            this.createStream();
            return this.dis;
        }
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        private final FileObject webdavTmp;

        public WebdavOutputStream(FileObject webdavTmp) throws FileSystemException {
            super(webdavTmp.getContent().getOutputStream());
            this.webdavTmp = webdavTmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            WebdavFileObject.this.resource.getHttpURL().setPath(WebdavFileObject.this.getName().getPathDecoded());
            try {
                boolean ok = WebdavFileObject.this.resource.putMethod(this.webdavTmp.getContent().getInputStream());
                if (!ok) {
                    throw new FileSystemException("vfs.provider.webdav/write-file.error", WebdavFileObject.this.resource.getStatusMessage());
                }
            }
            finally {
                this.webdavTmp.close();
                this.webdavTmp.delete();
            }
        }
    }
}

