/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.repository.Repository;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.TransferEvent;
import fr.jayasoft.ivy.repository.TransferListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.event.EventListenerList;

public abstract class AbstractRepository
implements Repository {
    private EventListenerList _listeners = new EventListenerList();
    private String _name;
    private TransferEvent _evt;

    public void addTransferListener(TransferListener listener) {
        this._listeners.add(TransferListener.class, listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this._listeners.remove(TransferListener.class, listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return Arrays.asList(this._listeners.getListeners(TransferListener.class)).contains(listener);
    }

    protected void fireTransferInitiated(Resource res, int requestType) {
        this._evt = new TransferEvent(IvyContext.getContext().getIvy(), (Repository)this, res, 0, requestType);
        this.fireTransferEvent(this._evt);
    }

    protected void fireTransferStarted() {
        this._evt.setEventType(1);
        this.fireTransferEvent(this._evt);
    }

    protected void fireTransferStarted(long totalLength) {
        this._evt.setEventType(1);
        this._evt.setTotalLength(totalLength);
        this._evt.setTotalLengthSet(true);
        this.fireTransferEvent(this._evt);
    }

    protected void fireTransferProgress(long length) {
        this._evt.setEventType(3);
        this._evt.setLength(length);
        if (!this._evt.isTotalLengthSet()) {
            this._evt.setTotalLength(this._evt.getTotalLength() + length);
        }
        this.fireTransferEvent(this._evt);
    }

    protected void fireTransferCompleted() {
        this._evt.setEventType(2);
        if (this._evt.getTotalLength() > 0L && !this._evt.isTotalLengthSet()) {
            this._evt.setTotalLengthSet(true);
        }
        this.fireTransferEvent(this._evt);
        this._evt = null;
    }

    protected void fireTransferCompleted(long totalLength) {
        this._evt.setEventType(2);
        this._evt.setTotalLength(totalLength);
        this._evt.setTotalLengthSet(true);
        this.fireTransferEvent(this._evt);
        this._evt = null;
    }

    protected void fireTransferError() {
        this._evt.setEventType(4);
        this.fireTransferEvent(this._evt);
        this._evt = null;
    }

    protected void fireTransferError(Exception ex) {
        this._evt.setEventType(4);
        this._evt.setException(ex);
        this.fireTransferEvent(this._evt);
        this._evt = null;
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$fr$jayasoft$ivy$repository$TransferListener == null ? AbstractRepository.class$("fr.jayasoft.ivy.repository.TransferListener") : class$fr$jayasoft$ivy$repository$TransferListener)) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    public String getFileSeparator() {
        return "/";
    }

    public String standardize(String source) {
        return source.replace('\\', '/');
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return this.getName();
    }

    public void put(Artifact artifact, File source, String destination, boolean overwrite) throws IOException {
        this.put(source, destination, overwrite);
    }

    protected void put(File source, String destination, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException("put in not supported by " + this.getName());
    }
}

