/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactOrigin;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DefaultModuleRevision;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.event.download.EndArtifactDownloadEvent;
import fr.jayasoft.ivy.event.download.NeedArtifactEvent;
import fr.jayasoft.ivy.event.download.StartArtifactDownloadEvent;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.ResourceHelper;
import fr.jayasoft.ivy.repository.url.URLRepository;
import fr.jayasoft.ivy.repository.url.URLResource;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.MDResolvedResource;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.ResourceMDParser;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.util.ChecksumHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorParser;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class BasicResolver
extends AbstractResolver {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected String _workspaceName;
    private boolean _envDependent = true;
    private List _ivyattempts = new ArrayList();
    private Map _artattempts = new HashMap();
    private Boolean _checkmodified = null;
    private boolean _checkconsistency = true;
    private boolean _allownomd = true;
    private String _checksums = null;
    private URLRepository _extartifactrep = new URLRepository();

    public BasicResolver() {
        this._workspaceName = Ivy.getLocalHostName();
    }

    public String getWorkspaceName() {
        return this._workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this._workspaceName = workspaceName;
    }

    public boolean isEnvDependent() {
        return this._envDependent;
    }

    public void setEnvDependent(boolean envDependent) {
        this._envDependent = envDependent;
    }

    public boolean isCheckmodified() {
        if (this._checkmodified == null) {
            if (this.getIvy() != null) {
                String check = this.getIvy().getVariable("ivy.resolver.default.check.modified");
                return check != null ? Boolean.valueOf(check) : false;
            }
            return false;
        }
        return this._checkmodified;
    }

    public void setCheckmodified(boolean check) {
        this._checkmodified = check;
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        ModuleDescriptor md;
        ModuleDescriptorParser parser;
        DependencyDescriptor systemDd = dd;
        dd = this.fromSystem(dd);
        this.clearIvyAttempts();
        boolean downloaded = false;
        boolean searched = false;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        int index = mrid.getRevision().indexOf("@");
        if (index != -1 && !mrid.getRevision().substring(index + 1).equals(this._workspaceName)) {
            Message.verbose("\t" + this.getName() + ": unhandled revision => " + mrid.getRevision());
            return null;
        }
        boolean isDynamic = this.getIvy().getVersionMatcher().isDynamic(mrid);
        if (isDynamic && !this.acceptLatest()) {
            Message.error("dynamic revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + mrid);
            return null;
        }
        boolean isChangingRevision = this.getChangingMatcher().matches(mrid.getRevision());
        boolean isChangingDependency = isChangingRevision || dd.isChanging();
        ResolvedModuleRevision cachedRmr = null;
        boolean checkedCache = false;
        if (!(isDynamic || this.isCheckmodified() || isChangingDependency)) {
            cachedRmr = this.findModuleInCache(data, mrid);
            checkedCache = true;
            if (cachedRmr != null) {
                if (cachedRmr.getDescriptor().isDefault() && cachedRmr.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + mrid + " (resolved by " + cachedRmr.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                    return this.toSystem(cachedRmr);
                }
            }
        }
        this.checkInterrupted();
        URL cachedIvyURL = null;
        ResolvedResource ivyRef = this.findIvyFileRef(dd, data);
        this.checkInterrupted();
        searched = true;
        ModuleDescriptor systemMd = null;
        if (ivyRef == null) {
            if (!this.isAllownomd()) {
                Message.verbose("\t" + this.getName() + ": no ivy file found for " + mrid);
                this.logIvyNotFound(mrid);
                return null;
            }
            parser = XmlModuleDescriptorParser.getInstance();
            md = DefaultModuleDescriptor.newDefaultInstance(mrid, dd.getAllDependencyArtifactsIncludes());
            ResolvedResource artifactRef = this.findFirstArtifactRef(md, dd, data);
            if (this.getIvy() != null && this.getIvy().isInterrupted()) {
                throw new RuntimeException("interrupted");
            }
            if (artifactRef == null) {
                Message.verbose("\t" + this.getName() + ": no ivy file nor artifact found for " + mrid);
                this.logIvyNotFound(mrid);
                String[] conf = md.getConfigurationsNames();
                for (int i = 0; i < conf.length; ++i) {
                    Artifact[] artifacts = md.getArtifacts(conf[i]);
                    for (int j = 0; j < artifacts.length; ++j) {
                        this.logArtifactNotFound(artifacts[j]);
                    }
                }
                if (!checkedCache) {
                    cachedRmr = this.findModuleInCache(data, mrid);
                }
                if (cachedRmr != null) {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                    return this.toSystem(cachedRmr);
                }
                return null;
            }
            Message.verbose("\t" + this.getName() + ": no ivy file found for " + mrid + ": using default data");
            this.logIvyNotFound(mrid);
            if (isDynamic) {
                md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(mrid, artifactRef.getRevision()));
            }
        } else {
            ResolvedModuleRevision rmr = null;
            if (ivyRef instanceof MDResolvedResource) {
                rmr = ((MDResolvedResource)ivyRef).getResolvedModuleRevision();
            }
            if (rmr == null && (rmr = this.parse(ivyRef, dd, data)) == null) {
                return null;
            }
            if (!rmr.isDownloaded()) {
                return this.toSystem(rmr);
            }
            md = rmr.getDescriptor();
            parser = ModuleDescriptorParserRegistry.getInstance().getParser(ivyRef.getResource());
            cachedIvyURL = rmr.getLocalMDUrl();
            systemMd = this.toSystem(md);
            if (this._checkconsistency) {
                this.checkDescriptorConsistency(mrid, md, ivyRef);
                this.checkDescriptorConsistency(systemDd.getDependencyRevisionId(), systemMd, ivyRef);
            } else if (md instanceof DefaultModuleDescriptor) {
                String revision = this.getRevision(ivyRef, mrid, md);
                ((DefaultModuleDescriptor)md).setModuleRevisionId(ModuleRevisionId.newInstance(mrid, revision));
            } else {
                Message.warn("consistency disabled with instance of non DefaultModuleDescriptor... module info can't be updated, so consistency check will be done");
                this.checkDescriptorConsistency(mrid, md, ivyRef);
                this.checkDescriptorConsistency(systemDd.getDependencyRevisionId(), systemMd, ivyRef);
            }
        }
        if (systemMd == null) {
            systemMd = this.toSystem(md);
        }
        ModuleRevisionId resolvedMrid = mrid;
        if (isDynamic) {
            resolvedMrid = md.getResolvedModuleRevisionId();
            if (resolvedMrid.getRevision() == null || resolvedMrid.getRevision().length() == 0) {
                resolvedMrid = ivyRef.getRevision() == null || ivyRef.getRevision().length() == 0 ? ModuleRevisionId.newInstance(resolvedMrid, "working@" + this.getName()) : ModuleRevisionId.newInstance(resolvedMrid, ivyRef.getRevision());
            }
            Message.verbose("\t\t[" + resolvedMrid.getRevision() + "] " + mrid.getModuleId());
        }
        md.setResolvedModuleRevisionId(resolvedMrid);
        systemMd.setResolvedModuleRevisionId(this.toSystem(resolvedMrid));
        if (!this.getIvy().getVersionMatcher().accept(mrid, md)) {
            Message.info("\t" + this.getName() + ": unacceptable revision => was=" + md.getModuleRevisionId().getRevision() + " required=" + mrid.getRevision());
            return null;
        }
        if (data.getDate() != null) {
            long pubDate = this.getPublicationDate(md, dd, data);
            if (pubDate > data.getDate().getTime()) {
                Message.info("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(pubDate) + " required=" + data.getDate());
                return null;
            }
            if (pubDate == -1L) {
                Message.info("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + mrid);
                return null;
            }
            md.setResolvedPublicationDate(new Date(pubDate));
            systemMd.setResolvedPublicationDate(new Date(pubDate));
        }
        try {
            File ivyFile = data.getIvy().getIvyFileInCache(data.getCache(), systemMd.getResolvedModuleRevisionId());
            if (ivyRef == null) {
                XmlModuleDescriptorWriter.write(systemMd, ivyFile);
            } else {
                if (md instanceof DefaultModuleDescriptor) {
                    DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
                    if (data.getIvy().logNotConvertedExclusionRule() && dmd.isNamespaceUseful()) {
                        Message.warn("the module descriptor " + ivyRef.getResource() + " has information which can't be converted into the system namespace. It will require the availability of the namespace '" + this.getNamespace().getName() + "' to be fully usable.");
                    }
                }
                parser.toIvyFile(cachedIvyURL.openStream(), ivyRef.getResource(), ivyFile, systemMd);
                long repLastModified = ivyRef.getLastModified();
                if (repLastModified > 0L) {
                    ivyFile.setLastModified(repLastModified);
                }
            }
        }
        catch (Exception e) {
            if (ivyRef == null) {
                Message.warn("impossible to create ivy file in cache for module : " + resolvedMrid);
            }
            e.printStackTrace();
            Message.warn("impossible to copy ivy file to cache : " + ivyRef.getResource());
        }
        data.getIvy().saveResolver(data.getCache(), systemMd, this.getName());
        data.getIvy().saveArtResolver(data.getCache(), systemMd, this.getName());
        return new DefaultModuleRevision(this, this, systemMd, searched, downloaded, cachedIvyURL);
    }

    private String getRevision(ResolvedResource ivyRef, ModuleRevisionId askedMrid, ModuleDescriptor md) throws ParseException {
        String revision = ivyRef.getRevision();
        if (revision == null) {
            Message.debug("no revision found in reference for " + askedMrid);
            if (this.getIvy().getVersionMatcher().isDynamic(askedMrid)) {
                if (md.getModuleRevisionId().getRevision() == null) {
                    return "working@" + this.getName();
                }
                Message.debug("using  " + askedMrid);
                revision = md.getModuleRevisionId().getRevision();
            } else {
                Message.debug("using  " + askedMrid);
                revision = askedMrid.getRevision();
            }
        }
        return revision;
    }

    public ResolvedModuleRevision parse(ResolvedResource ivyRef, DependencyDescriptor dd, ResolveData data) throws ParseException {
        ResolvedModuleRevision rmr;
        IvyNode node;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(ivyRef.getResource());
        if (parser == null) {
            Message.warn("no module descriptor parser available for " + ivyRef.getResource());
            return null;
        }
        Message.verbose("\t" + this.getName() + ": found md file for " + mrid);
        Message.verbose("\t\t=> " + ivyRef);
        Message.debug("\tparser = " + parser);
        boolean isChangingRevision = this.getChangingMatcher().matches(mrid.getRevision());
        boolean isChangingDependency = isChangingRevision || dd.isChanging();
        Date cachedPublicationDate = null;
        ModuleRevisionId resolvedMrid = mrid;
        if (this.getIvy().getVersionMatcher().isDynamic(mrid) && (node = this.getSystemNode(data, resolvedMrid = ModuleRevisionId.newInstance(mrid, ivyRef.getRevision()))) != null && node.getModuleRevision() != null) {
            if (node.getDescriptor() != null && node.getDescriptor().isDefault()) {
                Message.verbose("\t" + this.getName() + ": found already resolved revision: " + resolvedMrid + ": but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + resolvedMrid);
                return this.searchedRmr(node.getModuleRevision());
            }
        }
        if ((rmr = this.findModuleInCache(data, resolvedMrid)) != null) {
            if (rmr.getDescriptor().isDefault() && rmr.getResolver() != this) {
                Message.verbose("\t" + this.getName() + ": found revision in cache: " + mrid + " (resolved by " + rmr.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
            } else {
                if (!this.isCheckmodified() && !isChangingDependency) {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                    return this.searchedRmr(rmr);
                }
                long repLastModified = ivyRef.getLastModified();
                long cacheLastModified = rmr.getDescriptor().getLastModified();
                if (!rmr.getDescriptor().isDefault() && repLastModified <= cacheLastModified) {
                    Message.verbose("\t" + this.getName() + ": revision in cache (not updated): " + resolvedMrid);
                    return this.searchedRmr(rmr);
                }
                Message.verbose("\t" + this.getName() + ": revision in cache is not up to date: " + resolvedMrid);
                if (isChangingDependency) {
                    cachedPublicationDate = rmr.getDescriptor().getResolvedPublicationDate();
                }
            }
        }
        URL cachedIvyURL = null;
        File ivyTempFile = null;
        try {
            if (ResourceHelper.equals(ivyRef.getResource(), data.getIvy().getIvyFileInCache(data.getCache(), this.toSystem(resolvedMrid)))) {
                Message.error("invalid configuration for resolver '" + this.getName() + "': pointing ivy files to ivy cache is forbidden !");
                return null;
            }
            ivyTempFile = File.createTempFile("ivy", "xml");
            ivyTempFile.deleteOnExit();
            Message.debug("\t" + this.getName() + ": downloading " + ivyRef.getResource() + " to " + ivyTempFile);
            this.getAndCheck(ivyRef.getResource(), ivyTempFile);
            try {
                cachedIvyURL = ivyTempFile.toURL();
            }
            catch (MalformedURLException ex) {
                Message.warn("malformed url exception for temp file: " + ivyTempFile + ": " + ex.getMessage());
                return null;
            }
        }
        catch (IOException ex) {
            Message.warn("problem while downloading ivy file: " + ivyRef.getResource() + " to " + ivyTempFile + ": " + ex.getMessage());
            return null;
        }
        try {
            ModuleDescriptor md = parser.parseDescriptor(data.getIvy(), cachedIvyURL, ivyRef.getResource(), this.doValidate(data));
            Message.debug("\t" + this.getName() + ": parsed downloaded md file for " + mrid + " parsed=" + md.getModuleRevisionId());
            boolean deleteOldArtifacts = false;
            if (cachedPublicationDate != null && !cachedPublicationDate.equals(md.getResolvedPublicationDate())) {
                Message.verbose(dd + " has changed: deleting old artifacts");
                deleteOldArtifacts = true;
            }
            if (deleteOldArtifacts) {
                String[] confs = rmr.getDescriptor().getConfigurationsNames();
                for (int i = 0; i < confs.length; ++i) {
                    Artifact[] arts = rmr.getDescriptor().getArtifacts(confs[i]);
                    for (int j = 0; j < arts.length; ++j) {
                        Artifact transformedArtifact = this.toSystem(arts[j]);
                        ArtifactOrigin origin = data.getIvy().getSavedArtifactOrigin(data.getCache(), transformedArtifact);
                        File artFile = data.getIvy().getArchiveFileInCache(data.getCache(), transformedArtifact, origin, false);
                        if (artFile.exists()) {
                            Message.debug("deleting " + artFile);
                            artFile.delete();
                        }
                        data.getIvy().removeSavedArtifactOrigin(data.getCache(), transformedArtifact);
                    }
                }
            } else if (isChangingDependency) {
                Message.verbose(dd + " is changing, but has not changed: will trust cached artifacts if any");
            }
            return new DefaultModuleRevision(this, this, md, true, true, cachedIvyURL);
        }
        catch (IOException ex) {
            Message.warn("io problem while parsing ivy file: " + ivyRef.getResource() + ": " + ex.getMessage());
            return null;
        }
    }

    protected ResourceMDParser getRMDParser(final DependencyDescriptor dd, final ResolveData data) {
        return new ResourceMDParser(){

            public MDResolvedResource parse(Resource resource, String rev) {
                try {
                    ResolvedModuleRevision rmr = BasicResolver.this.parse(new ResolvedResource(resource, rev), dd, data);
                    if (rmr == null) {
                        return null;
                    }
                    return new MDResolvedResource(resource, rev, rmr);
                }
                catch (ParseException e) {
                    return null;
                }
            }
        };
    }

    protected ResourceMDParser getDefaultRMDParser(final ModuleId mid) {
        return new ResourceMDParser(){

            public MDResolvedResource parse(Resource resource, String rev) {
                return new MDResolvedResource(resource, rev, new DefaultModuleRevision(BasicResolver.this, BasicResolver.this, DefaultModuleDescriptor.newDefaultInstance(new ModuleRevisionId(mid, rev)), false, false, null));
            }
        };
    }

    private void checkDescriptorConsistency(ModuleRevisionId mrid, ModuleDescriptor md, ResolvedResource ivyRef) throws ParseException {
        boolean ok = true;
        StringBuffer errors = new StringBuffer();
        if (!mrid.getOrganisation().equals(md.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + ivyRef.getResource() + ": expected='" + mrid.getOrganisation() + "' found='" + md.getModuleRevisionId().getOrganisation() + "'");
            errors.append("bad organisation: expected='" + mrid.getOrganisation() + "' found='" + md.getModuleRevisionId().getOrganisation() + "'; ");
            ok = false;
        }
        if (!mrid.getName().equals(md.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + ivyRef.getResource() + ": expected='" + mrid.getName() + " found='" + md.getModuleRevisionId().getName() + "'");
            errors.append("bad module name: expected='" + mrid.getName() + "' found='" + md.getModuleRevisionId().getName() + "'; ");
            ok = false;
        }
        if (ivyRef.getRevision() != null && !ivyRef.getRevision().startsWith("working@")) {
            ModuleRevisionId expectedMrid = ModuleRevisionId.newInstance(mrid, ivyRef.getRevision());
            if (!this.getIvy().getVersionMatcher().accept(expectedMrid, md)) {
                Message.error("\t" + this.getName() + ": bad revision found in " + ivyRef.getResource() + ": expected='" + ivyRef.getRevision() + " found='" + md.getModuleRevisionId().getRevision() + "'");
                errors.append("bad revision: expected='" + ivyRef.getRevision() + "' found='" + md.getModuleRevisionId().getRevision() + "'; ");
                ok = false;
            }
        }
        if (!this.getIvy().getStatusManager().isStatus(md.getStatus())) {
            Message.error("\t" + this.getName() + ": bad status found in " + ivyRef.getResource() + ": '" + md.getStatus() + "'");
            errors.append("bad status: '" + md.getStatus() + "'; ");
            ok = false;
        }
        if (!ok) {
            throw new ParseException("inconsistent module descriptor file found in '" + ivyRef.getResource() + "': " + errors, 0);
        }
    }

    protected void clearIvyAttempts() {
        this._ivyattempts.clear();
        this.clearArtifactAttempts();
    }

    protected ResolvedModuleRevision searchedRmr(final ResolvedModuleRevision rmr) {
        return new ResolvedModuleRevision(){

            public boolean isSearched() {
                return true;
            }

            public boolean isDownloaded() {
                return rmr.isDownloaded();
            }

            public ModuleDescriptor getDescriptor() {
                return rmr.getDescriptor();
            }

            public Date getPublicationDate() {
                return rmr.getPublicationDate();
            }

            public ModuleRevisionId getId() {
                return rmr.getId();
            }

            public DependencyResolver getResolver() {
                return rmr.getResolver();
            }

            public DependencyResolver getArtifactResolver() {
                return rmr.getArtifactResolver();
            }

            public URL getLocalMDUrl() {
                return rmr.getLocalMDUrl();
            }
        };
    }

    protected void logIvyAttempt(String attempt) {
        this._ivyattempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    protected void logArtifactAttempt(Artifact art, String attempt) {
        ArrayList<String> attempts = (ArrayList<String>)this._artattempts.get(art);
        if (attempts == null) {
            attempts = new ArrayList<String>();
            this._artattempts.put(art, attempts);
        }
        attempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    public void reportFailure() {
        Iterator<Object> iter = this._ivyattempts.listIterator();
        while (iter.hasNext()) {
            String m = (String)iter.next();
            Message.warn("\t\t" + this.getName() + ": tried " + m);
        }
        iter = this._artattempts.keySet().iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            List attempts = (List)this._artattempts.get(art);
            if (attempts == null) continue;
            Message.warn("\t\t" + this.getName() + ": tried artifact " + art + ":");
            ListIterator iterator = attempts.listIterator();
            while (iterator.hasNext()) {
                String m = (String)iterator.next();
                Message.warn("\t\t\t" + m);
            }
        }
    }

    public void reportFailure(Artifact art) {
        List attempts = (List)this._artattempts.get(art);
        if (attempts != null) {
            ListIterator iter = attempts.listIterator();
            while (iter.hasNext()) {
                String m = (String)iter.next();
                Message.warn("\t\t" + this.getName() + ": tried " + m);
            }
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache, boolean useOrigin) {
        this.clearArtifactAttempts();
        DownloadReport dr = new DownloadReport();
        for (int i = 0; i < artifacts.length; ++i) {
            ArtifactDownloadReport adr = new ArtifactDownloadReport(artifacts[i]);
            dr.addArtifactReport(adr);
            ivy.fireIvyEvent(new NeedArtifactEvent(ivy, this, artifacts[i]));
            ArtifactOrigin origin = ivy.getSavedArtifactOrigin(cache, artifacts[i]);
            File archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i], origin, useOrigin);
            if (archiveFile.exists()) {
                Message.verbose("\t[NOT REQUIRED] " + artifacts[i]);
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(archiveFile.length());
                adr.setArtifactOrigin(origin);
            } else {
                Artifact artifact = this.fromSystem(artifacts[i]);
                if (!artifact.equals(artifacts[i])) {
                    Message.verbose("\t" + this.getName() + "looking for artifact " + artifact + " (is " + artifacts[i] + " in system namespace)");
                }
                long start = System.currentTimeMillis();
                try {
                    ResolvedResource artifactRef = this.getArtifactRef(artifact, null);
                    if (artifactRef != null) {
                        origin = new ArtifactOrigin(artifactRef.getResource().isLocal(), artifactRef.getResource().getName());
                        if (useOrigin && artifactRef.getResource().isLocal()) {
                            Message.verbose("\t[NOT REQUIRED] " + artifacts[i]);
                            ivy.saveArtifactOrigin(cache, artifacts[i], origin);
                            archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i], origin);
                            adr.setDownloadStatus(DownloadStatus.NO);
                            adr.setSize(archiveFile.length());
                            adr.setArtifactOrigin(origin);
                        } else {
                            archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i], origin, useOrigin);
                            if (ResourceHelper.equals(artifactRef.getResource(), archiveFile)) {
                                Message.error("invalid configuration for resolver '" + this.getName() + "': pointing artifacts to ivy cache is forbidden !");
                                return null;
                            }
                            Message.info("downloading " + artifactRef.getResource() + " ...");
                            ivy.fireIvyEvent(new StartArtifactDownloadEvent(ivy, this, artifacts[i], origin));
                            File tmp = ivy.getArchiveFileInCache(cache, new DefaultArtifact(artifacts[i].getModuleRevisionId(), artifacts[i].getPublicationDate(), artifacts[i].getName(), artifacts[i].getType(), artifacts[i].getExt() + ".part", artifacts[i].getExtraAttributes()), origin, useOrigin);
                            if (artifactRef.getResource().getName().equals(String.valueOf(artifacts[i].getUrl()))) {
                                Message.verbose("\t" + this.getName() + ": downloading " + artifactRef.getResource().getName());
                                Message.debug("\t\tto " + tmp);
                                if (tmp.getParentFile() != null) {
                                    tmp.getParentFile().mkdirs();
                                }
                                this._extartifactrep.get(artifactRef.getResource().getName(), tmp);
                                adr.setSize(tmp.length());
                            } else {
                                adr.setSize(this.getAndCheck(artifactRef.getResource(), tmp));
                            }
                            if (!tmp.renameTo(archiveFile)) {
                                Message.warn("\t[FAILED     ] " + artifacts[i] + " impossible to move temp file to definitive one (" + (System.currentTimeMillis() - start) + "ms)");
                                adr.setDownloadStatus(DownloadStatus.FAILED);
                            } else {
                                ivy.saveArtifactOrigin(cache, artifacts[i], origin);
                                Message.info("\t[SUCCESSFUL ] " + artifacts[i] + " (" + (System.currentTimeMillis() - start) + "ms)");
                                adr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                                adr.setArtifactOrigin(origin);
                            }
                        }
                    } else {
                        this.logArtifactNotFound(artifacts[i]);
                        adr.setDownloadStatus(DownloadStatus.FAILED);
                    }
                }
                catch (Exception ex) {
                    Message.warn("\t[FAILED     ] " + artifacts[i] + " : " + ex.getMessage() + " (" + (System.currentTimeMillis() - start) + "ms)");
                    adr.setDownloadStatus(DownloadStatus.FAILED);
                }
                this.checkInterrupted();
            }
            ivy.fireIvyEvent(new EndArtifactDownloadEvent(ivy, this, artifacts[i], adr, archiveFile));
        }
        return dr;
    }

    protected void clearArtifactAttempts() {
        this._artattempts.clear();
    }

    public boolean exists(Artifact artifact) {
        ResolvedResource artifactRef = this.getArtifactRef(artifact, null);
        if (artifactRef != null) {
            return artifactRef.getResource().exists();
        }
        return false;
    }

    protected long getPublicationDate(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        if (md.getPublicationDate() != null) {
            return md.getPublicationDate().getTime();
        }
        ResolvedResource artifactRef = this.findFirstArtifactRef(md, dd, data);
        if (artifactRef != null) {
            return artifactRef.getLastModified();
        }
        return -1L;
    }

    public String toString() {
        return this.getName();
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        Collection ret = this.findNames(otherTokenValues, token);
        return ret.toArray(new String[ret.size()]);
    }

    public OrganisationEntry[] listOrganisations() {
        Collection names = this.findNames(Collections.EMPTY_MAP, "organisation");
        OrganisationEntry[] ret = new OrganisationEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String org = (String)iter.next();
            ret[i] = new OrganisationEntry(this, org);
            ++i;
        }
        return ret;
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", mod.getOrganisation());
        tokenValues.put("module", mod.getModule());
        Collection names = this.findNames(tokenValues, "revision");
        RevisionEntry[] ret = new RevisionEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new RevisionEntry(mod, name);
            ++i;
        }
        return ret;
    }

    protected abstract Collection findNames(Map var1, String var2);

    protected abstract ResolvedResource findIvyFileRef(DependencyDescriptor var1, ResolveData var2);

    protected ResolvedResource findFirstArtifactRef(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        ResolvedResource ret = null;
        String[] conf = md.getConfigurationsNames();
        for (int i = 0; i < conf.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(conf[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                ret = this.getArtifactRef(artifacts[j], data.getDate());
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected long getAndCheck(Resource resource, File dest) throws IOException {
        long size = this.get(resource, dest);
        String[] checksums = this.getChecksumAlgorithms();
        boolean checked = false;
        for (int i = 0; i < checksums.length && !checked; ++i) {
            checked = this.check(resource, dest, checksums[i]);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(Resource resource, File dest, String algorithm) throws IOException {
        Resource csRes = resource.clone(resource.getName() + "." + algorithm);
        if (csRes.exists()) {
            Message.debug(algorithm + " file found for " + resource + ": checking...");
            File csFile = File.createTempFile("ivytmp", algorithm);
            try {
                this.get(csRes, csFile);
                if (!ChecksumHelper.check(dest, csFile, algorithm)) {
                    dest.delete();
                    throw new IOException("invalid " + algorithm);
                }
                Message.verbose(algorithm + " OK for " + resource);
                boolean bl = true;
                return bl;
            }
            finally {
                csFile.delete();
            }
        }
        return false;
    }

    protected ResolvedResource getArtifactRef(Artifact artifact, Date date) {
        ResolvedResource ret = this.findArtifactRef(artifact, date);
        if (ret == null && artifact.getUrl() != null) {
            URL url = artifact.getUrl();
            Message.verbose("\tusing url for " + artifact + ": " + url);
            ret = new ResolvedResource(new URLResource(url), artifact.getModuleRevisionId().getRevision());
        }
        return ret;
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2) throws IOException;

    protected abstract void logIvyNotFound(ModuleRevisionId var1);

    protected abstract void logArtifactNotFound(Artifact var1);

    public boolean isCheckconsistency() {
        return this._checkconsistency;
    }

    public void setCheckconsistency(boolean checkConsitency) {
        this._checkconsistency = checkConsitency;
    }

    public boolean isAllownomd() {
        return this._allownomd;
    }

    public void setAllownomd(boolean b) {
        this._allownomd = b;
    }

    public String[] getChecksumAlgorithms() {
        String csDef;
        String string = csDef = this._checksums == null ? this.getIvy().getVariable("ivy.checksums") : this._checksums;
        if (csDef == null) {
            return new String[0];
        }
        String[] checksums = csDef.split(",");
        ArrayList<String> algos = new ArrayList<String>();
        for (int i = 0; i < checksums.length; ++i) {
            String cs = checksums[i].trim();
            if ("".equals(cs) || "none".equals(cs)) continue;
            algos.add(cs);
        }
        return algos.toArray(new String[algos.size()]);
    }

    public void setChecksums(String checksums) {
        this._checksums = checksums;
    }
}

