/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CustomClassGenerator
extends GeneratorBase {
    private Set types;
    private Set faults;
    private boolean dontGenerateRPCStructures;
    private boolean dontGenerateWrapperClasses;

    public CustomClassGenerator() {
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerFault(Fault fault) {
        this.faults.add(fault);
    }

    protected void visitFault(Fault fault) throws Exception {
        AbstractType type;
        Iterator members;
        if (this.isRegistered(fault)) {
            return;
        }
        this.registerFault(fault);
        JavaException exception = fault.getJavaException();
        AbstractType aType = (AbstractType)exception.getOwner();
        if (aType.isSOAPType()) {
            ((SOAPType)aType).accept(this);
            members = exception.getMembers();
            while (members.hasNext()) {
                type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
                ((SOAPType)type).accept(this);
            }
        } else {
            ((LiteralType)aType).accept(this);
            members = exception.getMembers();
            type = null;
            while (members.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)members.next();
                if (javaMember.getOwner() instanceof LiteralElementMember) {
                    type = ((LiteralElementMember)javaMember.getOwner()).getType();
                } else if (javaMember.getOwner() instanceof LiteralAttributeMember) {
                    type = ((LiteralAttributeMember)javaMember.getOwner()).getType();
                }
                ((LiteralType)type).accept(this);
            }
        }
        if (fault.getParentFault() != null) {
            fault.getParentFault().accept(this);
        }
        Iterator iter = fault.getSubfaults();
        while (iter != null && iter.hasNext()) {
            ((Fault)iter.next()).accept(this);
        }
    }

    private boolean isRegistered(Fault fault) {
        return this.faults.contains(fault);
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
        this.faults = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
        this.faults = new HashSet();
    }

    public void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    private void generateJavaClass(LiteralArrayWrapperType type) {
        if (type.getJavaType() instanceof JavaException) {
            return;
        }
        this.log("generating JavaClass for: " + type.getName().getLocalPart());
        try {
            String className = this.env.getNames().customJavaTypeClassName(type);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("ValueType");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
            this.writeClassDecl(out, className, javaStructure);
            String structArrayName = ((JavaStructureMember)javaStructure.getMembers().next()).getType().getName();
            String memberName = ((JavaStructureMember)javaStructure.getMembers().next()).getName();
            out.pln("private " + structArrayName + " " + memberName + ";");
            out.pln();
            this.writeArrayWrapperTypeClassConstructors(out, className, type);
            out.pln();
            this.writeFromArrayToArrayMethods(out, type);
            JavaStructureMember member = type.getElementMember().getJavaStructureMember();
            out.pln();
            out.plnI("public " + structArrayName + " " + member.getReadMethod() + "() {");
            out.pln("return " + memberName + ";");
            out.pOln("}");
            out.pln();
            out.plnI("public void " + member.getWriteMethod() + "(" + structArrayName + " " + memberName + ") {");
            out.pln("this." + memberName + " = " + memberName + ";");
            out.pOln("}");
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    protected void preVisitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            String className = this.env.getNames().customJavaTypeClassName(type);
            if (!this.donotOverride || !GeneratorUtil.classExists(this.env, className)) {
                this.generateJavaClass(type);
            } else {
                this.log("Class " + className + " exists. Not overriding.");
            }
        }
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    private void generateJavaClass(LiteralStructuredType type) {
        if (type.getJavaType() instanceof JavaException || this.dontGenerateWrapperClasses && type instanceof LiteralSequenceType && ((LiteralSequenceType)type).isUnwrapped()) {
            return;
        }
        this.log("generating JavaClass for: " + type.getName().getLocalPart());
        try {
            JavaStructureMember member;
            String className = this.env.getNames().customJavaTypeClassName(type);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("ValueType");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
            this.writeClassDecl(out, className, javaStructure);
            Iterator members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (member.isInherited()) continue;
                String typeName = member.getType().getName();
                if (member.isPublic()) {
                    out.pln("public " + typeName + " " + member.getName() + ";");
                    continue;
                }
                out.pln("protected " + typeName + " " + member.getName() + ";");
            }
            out.pln();
            this.writeClassConstructor(out, className, javaStructure);
            members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (member.isInherited()) continue;
                out.pln();
                out.plnI("public " + member.getType().getName() + " " + member.getReadMethod() + "() {");
                out.pln("return " + member.getName() + ";");
                out.pOln("}");
                out.pln();
                out.plnI("public void " + member.getWriteMethod() + "(" + member.getType().getName() + " " + member.getName() + ") {");
                out.pln("this." + member.getName() + " = " + member.getName() + ";");
                out.pOln("}");
            }
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void visitLiteralStructuredType(LiteralStructuredType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        if (this.dontGenerateRPCStructures && type.isRpcWrapper()) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            String className = this.env.getNames().customJavaTypeClassName(type);
            if (!this.donotOverride || !GeneratorUtil.classExists(this.env, className)) {
                this.generateJavaClass(type);
            } else {
                this.log("Class " + className + " exists. Not overriding.");
            }
        }
        if (type.getParentType() != null) {
            type.getParentType().accept(this);
        }
        Iterator iter = type.getSubtypes();
        while (iter != null && iter.hasNext()) {
            ((LiteralStructuredType)iter.next()).accept(this);
        }
    }

    public void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    private void generateJavaClass(SOAPStructureType type) {
        if (type.getJavaType() instanceof JavaException) {
            return;
        }
        this.log("generating JavaClass for: " + type.getName().getLocalPart());
        try {
            JavaStructureMember member;
            String className = this.env.getNames().customJavaTypeClassName(type);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("ValueType");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
            this.writeClassDecl(out, className, javaStructure);
            Iterator members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (member.isInherited() && javaStructure.getSuperclass() != null) continue;
                String typeName = member.getType().getName();
                if (member.isPublic()) {
                    out.pln("public " + typeName + " " + member.getName() + ";");
                    continue;
                }
                out.pln("protected " + typeName + " " + member.getName() + ";");
            }
            out.pln();
            this.writeClassConstructor(out, className, javaStructure);
            members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (member.isInherited() && javaStructure.getSuperclass() != null) continue;
                out.pln();
                out.plnI("public " + member.getType().getName() + " " + member.getReadMethod() + "() {");
                out.pln("return " + member.getName() + ";");
                out.pOln("}");
                out.pln();
                out.plnI("public void " + member.getWriteMethod() + "(" + member.getType().getName() + " " + member.getName() + ") {");
                out.pln("this." + member.getName() + " = " + member.getName() + ";");
                out.pOln("}");
            }
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        if (this.dontGenerateRPCStructures && (type instanceof RPCRequestOrderedStructureType || type instanceof RPCRequestUnorderedStructureType || type instanceof RPCResponseStructureType)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            String className = this.env.getNames().customJavaTypeClassName(type);
            if (!this.donotOverride || !GeneratorUtil.classExists(this.env, className)) {
                this.generateJavaClass(type);
            } else {
                this.log("Class " + className + " exists. Not overriding.");
            }
        }
        if (type.getParentType() != null) {
            type.getParentType().accept(this);
        }
        Iterator iter = type.getSubtypes();
        while (iter != null && iter.hasNext()) {
            ((SOAPStructureType)iter.next()).accept(this);
        }
    }

    private void writeFromArrayToArrayMethods(IndentingWriter p, LiteralArrayWrapperType type) throws IOException {
        boolean elemTypeIsArrayWrapperType = type.getElementMember().getType() instanceof LiteralArrayWrapperType;
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        JavaStructureMember member = (JavaStructureMember)javaStructure.getMembers().next();
        JavaType javaType = member.getType();
        String typeName = type.getJavaArrayType().getName();
        String elementTypeName = javaType.getName();
        String memberName = member.getName();
        p.plnI("public void fromArray(" + typeName + " sourceArray) {");
        if (elemTypeIsArrayWrapperType) {
            int idx = elementTypeName.indexOf("[]");
            String tmp = elementTypeName.substring(0, idx);
            p.pln(memberName + " = new " + tmp + "[sourceArray.length];");
            p.plnI("for (int i=0; i<sourceArray.length; i++) {");
            p.pln(memberName + "[i] = new " + tmp + "(sourceArray[i]);");
            p.pOln("}");
        } else {
            p.pln("this." + memberName + " = sourceArray;");
        }
        p.pOln("}");
        p.pln();
        p.plnI("public " + typeName + " toArray() {");
        if (elemTypeIsArrayWrapperType) {
            String javaTypeName = type.getJavaArrayType().getName();
            int idx = javaTypeName.indexOf("[]") + 1;
            String tmp = javaTypeName.substring(0, idx);
            p.pln(javaTypeName + " tmpArray = new " + tmp + memberName + ".length" + javaTypeName.substring(idx) + ";");
            p.plnI("for (int i=0; i<" + memberName + ".length; i++) {");
            p.pln("tmpArray[i] = " + memberName + "[i].toArray();");
            p.pOln("}");
            p.pln("return tmpArray;");
        } else {
            p.pln("return " + memberName + ";");
        }
        p.pOln("}");
    }

    private void writeClassConstructor(IndentingWriter p, String className, JavaStructureType javaStructure) throws IOException {
        p.pln("public " + Names.stripQualifier(className) + "() {");
        p.pln("}");
        Iterator members = javaStructure.getMembers();
        if (members.hasNext()) {
            JavaStructureMember member;
            p.pln();
            p.p("public " + Names.stripQualifier(className) + "(");
            int i = 0;
            while (members.hasNext()) {
                if (i != 0) {
                    p.p(", ");
                }
                member = (JavaStructureMember)members.next();
                p.p(member.getType().getName() + " " + member.getName());
                ++i;
            }
            p.plnI(") {");
            members = javaStructure.getMembers();
            int i2 = 0;
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                p.pln("this." + member.getName() + " = " + member.getName() + ";");
                ++i2;
            }
            p.pOln("}");
        }
    }

    private void writeClassDecl(IndentingWriter p, String className, JavaStructureType javaStruct) throws IOException {
        JavaStructureType superclass = javaStruct.getSuperclass();
        String classDeclStr = "public class " + Names.stripQualifier(className);
        if (superclass != null) {
            classDeclStr = classDeclStr + " extends " + superclass.getName();
        }
        if (this.generateSerializableIf) {
            classDeclStr = classDeclStr + " implements java.io.Serializable";
        }
        classDeclStr = classDeclStr + " {";
        p.plnI(classDeclStr);
    }

    private void writeArrayWrapperTypeClassConstructors(IndentingWriter p, String className, LiteralArrayWrapperType arrayWrapperType) throws IOException {
        String theClassName = Names.stripQualifier(className);
        String structArrayName = arrayWrapperType.getElementMember().getType().getJavaType().getName() + "[]";
        JavaStructureType javaStructure = (JavaStructureType)arrayWrapperType.getJavaType();
        JavaStructureMember member = (JavaStructureMember)javaStructure.getMembers().next();
        String memberName = member.getName();
        p.pln("public " + theClassName + "() {");
        p.pln("}");
        p.pln();
        p.p("public " + theClassName + "(" + structArrayName);
        p.p(" sourceArray");
        p.plnI(") {");
        p.pln(memberName + " = sourceArray;");
        p.pOln("}");
        if (arrayWrapperType.getElementMember().getType() instanceof LiteralArrayWrapperType) {
            p.pln();
            p.p("public " + theClassName + "(");
            p.p(arrayWrapperType.getJavaArrayType().getName() + " sourceArray");
            p.plnI(") {");
            p.pln("fromArray(sourceArray);");
            p.pOln("}");
        }
    }

    private CustomClassGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        String key = "dontGenerateRPCStructures";
        this.dontGenerateRPCStructures = Boolean.valueOf(properties.getProperty(key));
        key = "dontGenerateWrapperClasses";
        this.dontGenerateWrapperClasses = Boolean.valueOf(properties.getProperty(key));
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new CustomClassGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new CustomClassGenerator(model, config, properties);
    }
}

