/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;
import org.openidex.search.SearchType;

final class ResultTreeChildren
extends Children.Keys
implements Runnable {
    private Set keys;
    private final Comparator comparator;
    private final ResultModel resultModel;
    private boolean sorted = false;
    private boolean hasDetails = false;
    private final int BATCH_LEVEL = 61;
    private final int BATCH_INTERVAL_MS = 759;
    private volatile RequestProcessor.Task batchSetKeys;
    private volatile boolean active = false;
    private int size = 0;
    private ResultView observer;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$search$RemoveFromSearchAction;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public ResultTreeChildren(ResultModel resultModel) {
        this.resultModel = resultModel;
        this.resultModel.setObserver(this);
        this.keys = resultModel.getSearchGroup().getResultObjects();
        this.comparator = new ResultItemsComparator();
    }

    protected void addNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.active = true;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set set = ResultTreeChildren.this.keys;
                synchronized (set) {
                    ResultTreeChildren.this.setKeys(ResultTreeChildren.this.keys);
                }
            }
        });
    }

    protected void removeNotify() {
        this.active = false;
        this.setKeys(Collections.EMPTY_SET);
    }

    void clear() {
        Enumeration en = this.nodes();
        while (en.hasMoreElements()) {
            FoundNode node = (FoundNode)en.nextElement();
            node.originalDataObject.removePropertyChangeListener((PropertyChangeListener)node);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Set set = this.keys;
        synchronized (set) {
            this.keys = Collections.EMPTY_SET;
        }
        this.removeNotify();
        this.resultModel.setObserver(null);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{this.createFoundNode(key)};
    }

    private FoundNode createFoundNode(Object foundObject) {
        Object children;
        Node node = this.resultModel.getSearchGroup().getNodeForFoundObject(foundObject);
        if (this.getDetailsCount(foundObject) != 0) {
            this.hasDetails = true;
            children = new DetailChildren(node);
        } else {
            children = Children.LEAF;
        }
        return new FoundNode(node, (Children)children, foundObject);
    }

    private int getDetailsCount(Object foundObject) {
        SearchGroup searchGroup = this.resultModel.getSearchGroup();
        SearchType[] types = searchGroup.getSearchTypes();
        int count = 0;
        for (int i = 0; i < types.length; ++i) {
            SearchType searchType = types[i];
            if (searchType.getClass() == (class$org$netbeans$modules$search$types$FullTextType == null ? ResultTreeChildren.class$("org.netbeans.modules.search.types.FullTextType") : class$org$netbeans$modules$search$types$FullTextType)) {
                count += ((FullTextType)searchType).getDetailsCount(foundObject);
                continue;
            }
            Node[] detailNodes = searchType.getDetails(foundObject);
            count += detailNodes != null ? detailNodes.length : 0;
        }
        return count;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    boolean hasDetails() {
        return this.hasDetails;
    }

    void setObserver(ResultView observer) {
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int objectFound(Object foundObject) {
        boolean isNew;
        if (!$assertionsDisabled && this.observer == null) {
            throw new AssertionError();
        }
        Set set = this.keys;
        synchronized (set) {
            isNew = this.keys.add(foundObject);
            if (isNew) {
                ++this.size;
            }
        }
        if (isNew) {
            int detailsCount = this.getDetailsCount(foundObject);
            if (this.size < 61) {
                Set set2 = this.keys;
                synchronized (set2) {
                    this.setKeys(this.keys);
                }
            } else {
                this.batchSetKeys();
            }
            if (this.observer != null) {
                this.observer.objectFound(foundObject);
            }
            return detailsCount;
        }
        return -1;
    }

    int getSize() {
        return this.size;
    }

    private void batchSetKeys() {
        if (this.batchSetKeys == null) {
            this.batchSetKeys = RequestProcessor.getDefault().post((Runnable)this, 759);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFoundObject(Object foundObject) {
        boolean removed = false;
        Set set = this.keys;
        synchronized (set) {
            removed = this.keys.remove(foundObject);
        }
        if (removed) {
            this.sort(this.sorted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(boolean sort) {
        AbstractSet newKeys = sort ? new TreeSet(this.comparator) : new HashSet();
        Set set = this.keys;
        synchronized (set) {
            newKeys.addAll(this.keys);
        }
        this.setKeys(newKeys);
        this.sorted = sort;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.batchSetKeys = null;
        Set set = this.keys;
        synchronized (set) {
            if (this.active) {
                this.setKeys(this.keys);
            }
        }
    }

    static {
        $assertionsDisabled = !ResultTreeChildren.class.desiredAssertionStatus();
    }

    final class ResultItemsComparator
    implements Comparator {
        private final SearchGroup searchGroup;

        ResultItemsComparator() {
            this.searchGroup = ResultTreeChildren.this.resultModel.getSearchGroup();
        }

        public int compare(Object o1, Object o2) {
            Node node2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Node node1 = this.searchGroup.getNodeForFoundObject(o1);
            if (node1 == (node2 = this.searchGroup.getNodeForFoundObject(o2))) {
                return 0;
            }
            if (node1 == null) {
                return 1;
            }
            if (node2 == null) {
                return -1;
            }
            int result = node1.getDisplayName().compareTo(node2.getDisplayName());
            return result == 0 ? -1 : result;
        }
    }

    final class DetailChildren
    extends Children.Array {
        private final Node parent;

        DetailChildren(Node parent) {
            this.parent = parent;
        }

        protected void addNotify() {
            this.add(this.createNodes(this.parent));
        }

        protected void removeNotify() {
            this.remove(this.getNodes());
        }

        protected Node[] createNodes(Object key) {
            Node node = (Node)key;
            SearchType[] types = ResultTreeChildren.this.resultModel.getSearchGroup().getSearchTypes();
            ArrayList<Node> nodes = new ArrayList<Node>(5);
            for (int i = 0; i < types.length; ++i) {
                SearchType searchType = types[i];
                Node[] details = searchType.getDetails(node);
                if (details == null || details.length <= 0) continue;
                for (int j = 0; j < details.length; ++j) {
                    Node detail = details[j];
                    nodes.add(detail);
                }
            }
            return nodes.toArray(new Node[nodes.size()]);
        }
    }

    final class FoundNode
    extends FilterNode
    implements PropertyChangeListener,
    OpenCookie {
        private DataObject originalDataObject;
        private Object foundObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        FoundNode() {
            super(Node.EMPTY);
        }

        FoundNode(Node node, Children kids, Object foundObject) {
            super(node, kids);
            this.foundObject = foundObject;
            this.originalDataObject = (DataObject)this.getOriginal().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResultTreeChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.originalDataObject == null) {
                return;
            }
            this.originalDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            FileObject fileFolder = this.originalDataObject.getPrimaryFile().getParent();
            if (fileFolder != null) {
                this.disableDelegation(56);
                this.setShortDescription("");
            }
        }

        public String getDisplayName() {
            FileObject fileFolder = this.originalDataObject.getPrimaryFile().getParent();
            if (fileFolder != null) {
                String hint = fileFolder.getPath();
                String orig = this.getOriginal().getDisplayName();
                return orig + " " + hint;
            }
            return this.getOriginal().getDisplayName();
        }

        public String getHtmlDisplayName() {
            FileObject fileFolder = this.originalDataObject.getPrimaryFile().getParent();
            if (fileFolder != null) {
                String hint = FileUtil.getFileDisplayName((FileObject)fileFolder);
                String orig = this.getOriginal().getDisplayName();
                try {
                    String color = UIManager.getDefaults().getColor("Tree.selectionBackground").equals(UIManager.getDefaults().getColor("controlShadow")) ? "Tree.selectionBorderColor" : "controlShadow";
                    return "<html>" + orig + " <font color='!" + color + "'>" + XMLUtil.toElementContent((String)hint);
                }
                catch (CharConversionException e) {
                    return null;
                }
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        public Action[] getActions(boolean context) {
            if (context) {
                return super.getActions(context);
            }
            ArrayList<Action> originalActions = new ArrayList<Action>(Arrays.asList(super.getActions(context)));
            int deleteIndex = originalActions.indexOf(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ResultTreeChildren.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
            SystemAction removeFromSearch = SystemAction.get((Class)(class$org$netbeans$modules$search$RemoveFromSearchAction == null ? (class$org$netbeans$modules$search$RemoveFromSearchAction = ResultTreeChildren.class$("org.netbeans.modules.search.RemoveFromSearchAction")) : class$org$netbeans$modules$search$RemoveFromSearchAction));
            if (deleteIndex != -1) {
                originalActions.add(deleteIndex, (Action)removeFromSearch);
            } else {
                originalActions.add(null);
                originalActions.add((Action)removeFromSearch);
            }
            return originalActions.toArray(new Action[originalActions.size()]);
        }

        public void removeFromSearch() {
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultTreeChildren.this.removeFoundObject(this.foundObject);
        }

        public void destroy() throws IOException {
            super.destroy();
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultTreeChildren.this.removeFoundObject(this.foundObject);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName()) && !this.originalDataObject.isValid()) {
                if (this.originalDataObject != null) {
                    this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                ResultTreeChildren.this.removeFoundObject(this.foundObject);
            }
        }

        public Image getIcon(int type) {
            if (this.originalDataObject.getPrimaryFile().hasExt("java")) {
                try {
                    BeanInfo info = Utilities.getBeanInfo(this.originalDataObject.getLoader().getClass());
                    return info.getIcon(type);
                }
                catch (IntrospectionException e) {
                    return AbstractNode.EMPTY.getIcon(type);
                }
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            if (this.originalDataObject.getPrimaryFile().hasExt("java")) {
                try {
                    BeanInfo info = Utilities.getBeanInfo(this.originalDataObject.getLoader().getClass());
                    return info.getIcon(type);
                }
                catch (IntrospectionException e) {
                    return AbstractNode.EMPTY.getIcon(type);
                }
            }
            return super.getOpenedIcon(type);
        }

        public Node.Cookie getCookie(Class type) {
            if ((class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ResultTreeChildren.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie).isAssignableFrom(type)) {
                return this;
            }
            return super.getCookie(type);
        }

        public void open() {
            OpenCookie oc;
            SearchType[] queriedSearchTypes = ResultTreeChildren.this.resultModel.getQueriedSearchTypes();
            for (int i = 0; i < queriedSearchTypes.length; ++i) {
                SearchType st = queriedSearchTypes[i];
                if (!$assertionsDisabled && !st.isValid()) {
                    throw new AssertionError();
                }
                if (!(st instanceof FullTextType)) continue;
                SearchPattern sp = ((FullTextType)st).createSearchPattern();
                SearchHistory.getDefault().setLastSelected(sp);
                break;
            }
            if ((oc = (OpenCookie)super.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ResultTreeChildren.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie)) != null) {
                oc.open();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$search$ResultTreeChildren == null ? (class$org$netbeans$modules$search$ResultTreeChildren = ResultTreeChildren.class$("org.netbeans.modules.search.ResultTreeChildren")) : class$org$netbeans$modules$search$ResultTreeChildren).desiredAssertionStatus();
        }
    }
}

