/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ClassMemberRelatedItemProvider;
import org.netbeans.modules.java.navigation.InheritanceTreeController;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;

final class ClassMemberController
extends MouseAdapter
implements PopupMenuListener {
    private ClassMemberPanelUI panelUI;
    private int origDelay = -1;

    public ClassMemberController(ClassMemberPanelUI panelUI) {
        this.panelUI = panelUI;
        this.initActions();
        this.initListeners();
    }

    private void initActions() {
        NavigatorJList list = this.panelUI.getContent();
        OpenByKeyboardAction keyAction = new OpenByKeyboardAction();
        list.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "open");
        list.getActionMap().put("open", keyAction);
        ShowPopupAction showPopupAction = new ShowPopupAction();
        list.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64, true), "popup");
        list.getActionMap().put("popup", showPopupAction);
    }

    private void initListeners() {
        this.panelUI.getContent().addMouseListener(this);
    }

    private void showPopup(JList list, Point p) {
        DisplayProvider dp = (DisplayProvider)((Object)list.getModel());
        Object elem = null;
        int i = NavigatorJList.indexAtLocation(list, p);
        if (i >= 0) {
            elem = list.getModel().getElementAt(i);
        }
        list.scrollRectToVisible(new Rectangle(p.x, p.y + 16, 12, 16));
        JPopupMenu m = InheritanceTreeController.createPopupMenuForItem(list, dp, elem);
        if (m != null) {
            m.addPopupMenuListener(this);
            m.show(list, p.x, p.y);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Action act;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        NavigatorJList list = this.panelUI.getContent();
        Point p = e.getPoint();
        int idx = NavigatorJList.indexAtLocation(list, p);
        Object clicked = null;
        if (idx == -1) {
            return;
        }
        clicked = list.getModel().getElementAt(idx);
        DisplayProvider dp = (DisplayProvider)((Object)list.getModel());
        if ((dp.isDefaultActionInstant() || e.getClickCount() > 1) && (act = dp.getDefaultAction(clicked)) != null && act.isEnabled()) {
            ActionEvent ae = new ActionEvent(this, 1001, "click");
            if (ClassMemberRelatedItemProvider.USE_RELATED_ITEMS && list.getModel() instanceof RelatedItemProvider) {
                ((RelatedItemProvider)((Object)list.getModel())).reset();
                list.repaint();
            }
            act.actionPerformed(ae);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup((JList)e.getSource(), e.getPoint());
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup((JList)e.getSource(), e.getPoint());
        }
    }

    public void mouseEntered(MouseEvent e) {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.origDelay = ttm.getDismissDelay();
        ttm.setDismissDelay(Integer.MAX_VALUE);
    }

    public void mouseExited(MouseEvent e) {
        if (this.origDelay > 0) {
            ToolTipManager.sharedInstance().setDismissDelay(this.origDelay);
            this.origDelay = -1;
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        int key;
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        AWTEvent curEvt = EventQueue.getCurrentEvent();
        if (curEvt instanceof KeyEvent && ((key = ((KeyEvent)curEvt).getKeyCode()) == 10 || key == 27)) {
            this.panelUI.getContent().ignoreNextKeyUntilReleased();
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private final class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            NavigatorJList list = ClassMemberController.this.panelUI.getContent();
            int idx = list.getSelectedIndex();
            Point p = list.indexToLocation(idx);
            p.x += 7;
            p.y += 14;
            ClassMemberController.this.showPopup(list, p);
        }
    }

    private class OpenByKeyboardAction
    extends AbstractAction {
        private OpenByKeyboardAction() {
        }

        public boolean isEnabled() {
            return this.findDefaultAction() != null;
        }

        private Action findDefaultAction() {
            Action a;
            NavigatorJList list = ClassMemberController.this.panelUI.getContent();
            ListModel model = list.getModel();
            Object sel = null;
            int index = list.getSelectedIndex();
            if (index != -1) {
                sel = model.getElementAt(index);
            }
            if (sel != null && (a = ((DisplayProvider)((Object)model)).getDefaultAction(sel)) != null && a.isEnabled()) {
                return a;
            }
            return null;
        }

        public void actionPerformed(ActionEvent evt) {
            Action a = this.findDefaultAction();
            if (a != null) {
                InheritanceTreeController.runWithWaitCursor(ClassMemberController.this.panelUI.getContent(), a, evt);
            }
        }
    }
}

