/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import org.netbeans.modules.java.navigation.base.CellRenderer;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.Reorderable;
import org.openide.awt.StatusDisplayer;

class ReorderDragAndDropHandler
implements MouseListener,
MouseMotionListener {
    private Reorderable currReorderable = null;
    private JComponent target = null;
    private Point dragStart = null;
    private CellRenderer rend = null;

    ReorderDragAndDropHandler() {
    }

    private Reorderable getReorderable(Object jc) {
        Reorderable result = null;
        if (jc instanceof JTree && ((JTree)jc).getModel() instanceof Reorderable) {
            result = (Reorderable)((Object)((JTree)jc).getModel());
        } else if (jc instanceof JList && ((JList)jc).getModel() instanceof Reorderable) {
            result = (Reorderable)((Object)((JList)jc).getModel());
        }
        return result != null && result.isReorderable() ? result : null;
    }

    private void armDrag(JComponent jc, Point p, Reorderable r) {
        if (jc instanceof JTree && ((JTree)jc).getCellRenderer() instanceof CellRenderer) {
            this.rend = (CellRenderer)((JTree)jc).getCellRenderer();
        } else if (jc instanceof JList && ((JList)jc).getCellRenderer() instanceof CellRenderer) {
            this.rend = (CellRenderer)((JList)jc).getCellRenderer();
        } else {
            return;
        }
        this.currReorderable = r;
        this.target = jc;
        this.dragStart = p;
    }

    private void abortDrag() {
        this.currReorderable = null;
        this.target = null;
        this.dragStart = null;
        if (this.rend != null) {
            this.rend.setShowDragFeedback(false);
        }
        this.rend = null;
    }

    private void endDrag(MouseEvent e) {
        if (this.target instanceof JTree) {
            this.endDragForTree(e);
        } else {
            this.endDragForList(e);
        }
    }

    private Object selectedObjectAt(Point p) {
        JList list;
        int idx;
        if (this.target instanceof JTree) {
            return null;
        }
        if (this.target instanceof JList && (idx = (list = (JList)this.target).locationToIndex(p)) != -1 && idx < list.getModel().getSize()) {
            return list.getModel().getElementAt(idx);
        }
        return null;
    }

    private void endDragForTree(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDragForList(MouseEvent e) {
        JList list = (JList)this.target;
        int targetIdx = list.locationToIndex(e.getPoint());
        if (targetIdx == -1 || targetIdx >= list.getModel().getSize()) {
            this.abortDrag();
            return;
        }
        int sourceIdx = list.locationToIndex(this.dragStart);
        if (sourceIdx == -1 || sourceIdx >= list.getModel().getSize()) {
            this.abortDrag();
            return;
        }
        if (sourceIdx == targetIdx) {
            this.abortDrag();
            return;
        }
        Object o = list.getModel().getElementAt(sourceIdx);
        String msg = null;
        Cursor cursor = this.target.getCursor();
        try {
            this.target.setCursor(Cursor.getPredefinedCursor(3));
            msg = this.currReorderable.move(o, targetIdx);
        }
        finally {
            this.target.setCursor(cursor);
        }
        if (msg != null) {
            StatusDisplayer.getDefault().setStatusText(msg);
        } else {
            list.setSelectedIndex(targetIdx);
            Action a = ((NavigatorListModel)list.getModel()).getDefaultAction(o);
            if (a != null) {
                a.actionPerformed(new ActionEvent(list, 1001, "move"));
            }
        }
        this.abortDrag();
    }

    private boolean isActive(MouseEvent e) {
        Point p;
        JList list;
        boolean result;
        boolean bl = result = !e.isPopupTrigger() && this.currReorderable != null && this.target.contains(e.getPoint()) && e.getSource() == this.target;
        if (result && this.target instanceof JList && (list = (JList)this.target).locationToIndex(p = e.getPoint()) == list.locationToIndex(this.dragStart)) {
            result = false;
        }
        return result;
    }

    public void mousePressed(MouseEvent e) {
        Reorderable r = this.getReorderable(e.getSource());
        if (r != null) {
            this.armDrag((JComponent)e.getSource(), e.getPoint(), r);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isActive(e)) {
            this.endDrag(e);
        } else {
            this.abortDrag();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isActive(e)) {
            boolean isNotStartItem = this.selectedObjectAt(e.getPoint()) != this.selectedObjectAt(this.dragStart);
            this.rend.setShowDragFeedback(isNotStartItem);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

