/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.java.navigation.base.ModelBusyListener;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.ExtListDataEvent;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.diff.Change;
import org.netbeans.modules.java.navigation.spi.diff.Diff;
import org.netbeans.modules.java.navigation.spi.diff.ListDiff;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class ListModelSupport
extends AbstractModel
implements NavigatorListModel {
    private boolean invalid = false;
    private final boolean singleClick;
    List list = null;
    private volatile boolean active;
    private List listeners = Collections.synchronizedList(new ArrayList(2));
    private ChangeManager changeManager = null;
    private Loader loader = null;
    protected static final RequestProcessor rp;
    private static Thread rpThread;
    private static ListModelSupport waitingModel;
    private boolean updateAsync = false;
    private boolean readAsync = true;
    private int retryCount = 0;
    private ChangeListener changeListener = null;
    private ModelBusyListener busyListener = null;
    private static final Object START_STOP_LISTENING_LOCK;
    static long cumulateTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ListModelSupport() {
        this(true);
    }

    protected ListModelSupport(boolean singleClick) {
        this.singleClick = singleClick;
    }

    protected ListModelSupport(boolean singleClick, boolean readAsync, boolean updateAsync) {
        this(singleClick);
        this.readAsync = readAsync;
        this.updateAsync = updateAsync;
    }

    public List getSearchResults(String partial) {
        if (this.list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            String s = this.getName(o).toString().toUpperCase();
            if (!s.startsWith(partial)) continue;
            result.add(o);
        }
        return result;
    }

    protected final List getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"getList may only becalled on the dispatch thread");
        }
        return this.list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.list);
    }

    boolean owns(Object o) {
        return this.list == null || this.invalid ? false : this.list.contains(o);
    }

    public int indexOf(Object o) {
        return this.list == null || this.invalid ? -1 : this.list.indexOf(o);
    }

    protected final boolean isUpdateAsync() {
        return this.updateAsync;
    }

    protected final boolean isReadAsync() {
        return this.readAsync;
    }

    protected Task getWaitTask() {
        return null;
    }

    protected void startListening() {
    }

    protected void stopListening() {
    }

    protected abstract List loadContents();

    protected void updated() {
    }

    protected void cancelWaitTask(Cancellable waitTask) {
        waitTask.cancel();
    }

    protected final boolean isActive() {
        return this.active;
    }

    public final boolean isReady() {
        return this.list != null;
    }

    public final void addChangeListener(ChangeListener cl) throws TooManyListenersException {
        if (this.changeListener != null) {
            throw new TooManyListenersException(cl.toString());
        }
        this.changeListener = cl;
    }

    public final void removeChangeListener(ChangeListener cl) {
        if (this.changeListener != cl) {
            throw new IllegalArgumentException("Wrong listener " + cl);
        }
        this.changeListener = null;
    }

    protected final void fireChange() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public final void addBusyListener(ModelBusyListener bl) throws TooManyListenersException {
        if (this.busyListener != null) {
            throw new TooManyListenersException(bl.toString());
        }
        this.busyListener = bl;
    }

    public final void removeBusyListener(ModelBusyListener bl) {
        if (this.busyListener != bl) {
            throw new IllegalArgumentException("Wrong listener " + bl);
        }
        this.busyListener = null;
    }

    protected final void fireBusyChange(boolean value) {
        if (this.busyListener == null) {
            return;
        }
        if (value) {
            this.busyListener.busyStart();
        } else {
            this.busyListener.busyEnd();
        }
    }

    private void fireNewContentReady() {
        if (this.busyListener == null) {
            return;
        }
        this.busyListener.newContentReady();
    }

    protected final void setInvalid(boolean invalid) {
        if (invalid != this.invalid) {
            this.invalid = invalid;
            if (invalid) {
                this.stopListening();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        ListModelSupport.this.setContents(Arrays.asList(AbstractModel.createInvalidMarker()));
                    }
                });
                this.loader.cancel();
            } else {
                this.list = null;
                this.loader = new Loader(this.getWaitTask());
            }
        }
    }

    protected final void change() {
        if (this.invalid) {
            return;
        }
        if (this.loader == null) {
            throw new IllegalStateException("Change called before addNotify");
        }
        this.loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retryLoad(long delay) {
        if (!rp.isRequestProcessorThread()) {
            throw new IllegalStateException("retryLoad must be called from the loader thread");
        }
        if (!Thread.holdsLock(this.loader)) {
            throw new IllegalStateException("retryLoad may only be called from loadContents");
        }
        if (delay > 90000L) {
            throw new IllegalArgumentException("Abusive retry delay - must be less than 1.5 minutes");
        }
        if (this.retryCount > 10) {
            ErrorManager.getDefault().log(1, "Too many retries on " + this + " - marking it invalid");
            this.setInvalid(true);
            return;
        }
        ErrorManager.getDefault().log(1, "Putting loader thread to sleep for " + delay + " milliseconds due to error");
        try {
            ++this.retryCount;
            Class clazz = ListModelSupport.class;
            synchronized (clazz) {
                rpThread = Thread.currentThread();
                waitingModel = this;
            }
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            if (this.isActive() && !this.invalid) {
                this.loader.retryStart(delay);
                return;
            }
        }
        finally {
            rpThread = null;
            waitingModel = null;
        }
        if (this.isActive() && !this.invalid) {
            this.loader.retryStart(0L);
        }
    }

    private void setContents(final List l) {
        List oldList = this.list;
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                if (!ListModelSupport.this.active) {
                    return;
                }
                boolean isNewContent = ListModelSupport.this.list == null;
                ListModelSupport.this.list = l;
                try {
                    ListModelSupport.this.updated();
                }
                catch (RuntimeException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                ListModelSupport.this.fireChange();
                if ((ListModelSupport.this.listeners.size() > 0 || ListModelSupport.this.getTree() != null) && isNewContent) {
                    ExtListDataEvent e;
                    List<Object> pseudoContent = Arrays.asList(AbstractModel.createInvalidMarker());
                    if (ListModelSupport.this.listeners.size() > 0) {
                        e = new ExtListDataEvent(ListModelSupport.this, 2, 0, 0);
                        e.setContents(pseudoContent, null);
                        ListModelSupport.this.fire(e);
                    }
                    if (l.size() > 0 && ListModelSupport.this.listeners.size() > 0) {
                        e = new ExtListDataEvent(ListModelSupport.this, 1, 0, l.size());
                        e.setContents(Collections.EMPTY_LIST, l);
                        ListModelSupport.this.fire(e);
                    }
                    if (ListModelSupport.this.getTree() != null) {
                        ListModelSupport.this.getTree().processDiffs(ListModelSupport.this, new Diff[]{ListDiff.createDiff(pseudoContent, ListModelSupport.this.list)});
                    }
                    ListModelSupport.this.fireNewContentReady();
                }
            }
        });
        if (oldList != null) {
            this.change(oldList, l);
        }
    }

    protected final void change(List changes) {
        this.queueChanges(ListDiff.createFixed(this.list, this.list, changes));
    }

    protected final void change(int start, int end, int changeType) {
        Change change = new Change(start, end, changeType);
        this.change(Arrays.asList(change));
    }

    private final void change(List old, List nue) {
        if (!this.active) {
            return;
        }
        Diff diff = ListDiff.createDiff(old, nue);
        diff.getChanges();
        this.queueChanges(diff);
    }

    public final Object getElementAt(int idx) {
        Object result = this.list == null ? (this.invalid ? AbstractModel.createInvalidMarker() : this.getLoadingTempList().get(0)) : (!this.list.isEmpty() ? this.list.get(idx) : this.getLoadingTempList().get(0));
        if (!(AbstractModel.isInvalidMarker(result) || AbstractModel.isWaitMarker(result) || this.isObjectValid(result))) {
            result = AbstractModel.createInvalidMarker();
        }
        return result;
    }

    protected boolean isObjectValid(Object o) {
        return true;
    }

    public final int getSize() {
        return this.list == null || this.invalid ? 1 : this.list.size();
    }

    public final boolean isDefaultActionInstant() {
        return this.singleClick;
    }

    public String getTooltip(Object o) {
        return null;
    }

    public String getTooltip(Object tooltipFor, int x, int y) {
        return null;
    }

    protected String getDisplayName(Object o) {
        return null;
    }

    protected WeightedString assembleName(WeightedString str, Object o) {
        str.startMarkupRun(512);
        str.append("Unknown: ", 0.09f);
        str.endMarkupRun();
        str.append(o.toString(), 0.09f);
        return str;
    }

    public final WeightedString getName(Object o) {
        long a = System.currentTimeMillis();
        WeightedString result = WeightedString.instance();
        String name = this.getDisplayName(o);
        if (name != null) {
            result.append(name, 0.09f);
        } else {
            result = this.assembleName(result, o);
        }
        cumulateTime += System.currentTimeMillis() - a;
        return result;
    }

    private synchronized void queueChanges(Diff diff) {
        if (!this.active) {
            return;
        }
        if (this.changeManager == null) {
            this.changeManager = new ChangeManager();
        }
        if (this.changeManager.isBusy()) {
            this.changeManager = new ChangeManager().enqueue(diff);
        } else {
            this.changeManager.enqueue(diff);
        }
    }

    public final void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public final void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    private void fire(ListDataEvent e) {
        if (!this.active) {
            return;
        }
        ListDataListener[] l = new ListDataListener[this.listeners.size()];
        l = this.listeners.toArray(l);
        block5: for (int i = 0; i < l.length; ++i) {
            switch (e.getType()) {
                case 0: {
                    l[i].contentsChanged(e);
                    continue block5;
                }
                case 1: {
                    l[i].intervalAdded(e);
                    continue block5;
                }
                case 2: {
                    l[i].intervalRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Bad event type: " + e.getType());
                }
            }
        }
    }

    public final void doAddNotify() {
        if (this.active) {
            throw new IllegalStateException("Already active");
        }
        if (this.invalid) {
            return;
        }
        this.active = true;
        this.list = null;
        if (rpThread != null) {
            rpThread.interrupt();
            rpThread = null;
            waitingModel = null;
        }
        this.loader = new Loader(this.getWaitTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNotify() {
        if (this.loader == null) {
            throw new IllegalStateException("removeNotify called before addNotify");
        }
        Object object = START_STOP_LISTENING_LOCK;
        synchronized (object) {
            this.loader.cancel();
            this.stopListening();
        }
        this.active = false;
        object = ListModelSupport.class;
        synchronized (object) {
            if (rpThread != null && waitingModel == this) {
                rpThread.interrupt();
                rpThread = null;
                waitingModel = null;
            }
        }
    }

    static {
        $assertionsDisabled = !ListModelSupport.class.desiredAssertionStatus();
        rp = new RequestProcessor("ListModelSupport loader", 1);
        rpThread = null;
        waitingModel = null;
        START_STOP_LISTENING_LOCK = new Object();
        cumulateTime = 0L;
    }

    private final class Loader
    implements Runnable,
    TaskListener,
    Cancellable {
        private boolean cancelled = false;
        private boolean finished = true;
        private final Task waitTask;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Loader(Task waitTask) {
            this.waitTask = waitTask;
            if (waitTask != null && !waitTask.isFinished()) {
                waitTask.addTaskListener((TaskListener)this);
            } else {
                this.start();
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.waitTask != null && this.waitTask instanceof Cancellable) {
                ListModelSupport.this.cancelWaitTask((Cancellable)this.waitTask);
            }
            return true;
        }

        public void start() {
            boolean async;
            if (!this.finished) {
                return;
            }
            this.finished = false;
            this.cancelled = false;
            boolean bl = async = ListModelSupport.this.list == null ? ListModelSupport.this.isReadAsync() : ListModelSupport.this.isUpdateAsync();
            if (rp.isRequestProcessorThread() && async) {
                this.run();
            } else if (SwingUtilities.isEventDispatchThread() && !async) {
                this.run();
            } else if (async) {
                rp.post((Runnable)this);
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void retryStart(long delay) {
            rp.post((Runnable)this, (int)delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!($assertionsDisabled || SwingUtilities.isEventDispatchThread() || rp.isRequestProcessorThread())) {
                throw new AssertionError();
            }
            if (this.cancelled || !ListModelSupport.this.active || ListModelSupport.this.invalid) {
                return;
            }
            try {
                boolean needListen = ListModelSupport.this.list == null;
                Object object = this;
                synchronized (object) {
                    ListModelSupport.this.setContents(ListModelSupport.this.loadContents());
                }
                object = START_STOP_LISTENING_LOCK;
                synchronized (object) {
                    block14: {
                        if (!this.cancelled && ListModelSupport.this.active && !ListModelSupport.this.invalid) break block14;
                        return;
                    }
                    if (needListen) {
                        ListModelSupport.this.startListening();
                    }
                }
            }
            finally {
                this.finished = true;
                this.cancelled = false;
            }
        }

        public void taskFinished(Task task) {
            task.removeTaskListener((TaskListener)this);
            this.start();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$ListModelSupport == null ? (class$org$netbeans$modules$java$navigation$spi$ListModelSupport = ListModelSupport.class$("org.netbeans.modules.java.navigation.spi.ListModelSupport")) : class$org$netbeans$modules$java$navigation$spi$ListModelSupport).desiredAssertionStatus();
        }
    }

    private final class ChangeManager
    implements Runnable {
        private boolean enqueued = false;
        private final List diffs = Collections.synchronizedList(new ArrayList(2));
        private volatile boolean busy = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ChangeManager() {
        }

        ChangeManager enqueue(Diff diff) {
            this.diffs.add(diff);
            if (!this.enqueued) {
                this.enqueued = true;
                Mutex.EVENT.readAccess((Runnable)this);
            }
            return this;
        }

        boolean isBusy() {
            return this.busy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!ListModelSupport.this.active) {
                return;
            }
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            this.busy = true;
            try {
                Diff[] diffs = null;
                List list = this.diffs;
                synchronized (list) {
                    diffs = this.diffs.toArray(new Diff[this.diffs.size()]);
                    this.diffs.clear();
                }
                this.processDiffs(diffs);
            }
            finally {
                this.enqueued = false;
                this.busy = false;
            }
        }

        private void processDiffs(Diff[] diffs) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (!ListModelSupport.this.isActive()) {
                return;
            }
            if (!ListModelSupport.this.listeners.isEmpty()) {
                for (int i = 0; i < diffs.length; ++i) {
                    this.processDiff(diffs[i]);
                }
            }
            if (ListModelSupport.this.getTree() != null) {
                ListModelSupport.this.getTree().processDiffs(ListModelSupport.this, diffs);
            }
        }

        private void processDiff(Diff diff) {
            Iterator i = diff.getChanges().iterator();
            while (i.hasNext()) {
                Change change = (Change)i.next();
                ExtListDataEvent evt = new ExtListDataEvent(ListModelSupport.this, change.getType(), change.getStart(), change.getEnd());
                evt.setContents(diff.getOld(), diff.getNew());
                ListModelSupport.this.fire(evt);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$ListModelSupport == null ? (class$org$netbeans$modules$java$navigation$spi$ListModelSupport = ListModelSupport.class$("org.netbeans.modules.java.navigation.spi.ListModelSupport")) : class$org$netbeans$modules$java$navigation$spi$ListModelSupport).desiredAssertionStatus();
        }
    }
}

