/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.applet.AppletSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassWarning;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class J2SEActionProvider
implements ActionProvider {
    private static final String[] supportedActions;
    private static final String[] platformSensitiveActions;
    J2SEProject project;
    private UpdateHelper updateHelper;
    Map commands = new HashMap();
    final Set bkgScanSensitiveActions;
    private static final Pattern SRCDIRJAVA;
    private static final String SUBST = "Test.java";
    static final /* synthetic */ boolean $assertionsDisabled;

    public J2SEActionProvider(J2SEProject project, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"jar"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "jar"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
        this.updateHelper = updateHelper;
        this.project = project;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable action = new Runnable(){

            public void run() {
                Properties p = new Properties();
                String[] targetNames = J2SEActionProvider.this.getTargetNames(command, context, p);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().size() == 0) {
                    p = null;
                }
                try {
                    FileObject buildFo = J2SEActionProvider.this.findBuildXml();
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$J2SEActionProvider == null ? (class$org$netbeans$modules$java$j2seproject$J2SEActionProvider = J2SEActionProvider.class$("org.netbeans.modules.java.j2seproject.J2SEActionProvider")) : class$org$netbeans$modules$java$j2seproject$J2SEActionProvider), (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    } else {
                        ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)p);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        if (this.bkgScanSensitiveActions.contains(command)) {
            JMManager.getManager().invokeAfterScanFinished(action, NbBundle.getMessage((Class)J2SEActionProvider.class, (String)("ACTION_" + command)));
        } else {
            action.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        String path;
        String activePlatformId;
        if (Arrays.asList(platformSensitiveActions).contains(command) && J2SEProjectUtil.getActivePlatform(activePlatformId = this.project.evaluator().getProperty("platform.active")) == null) {
            this.showPlatformWarning();
            return null;
        }
        String[] targetNames = new String[]{};
        if (command.equals("compile.single")) {
            boolean recursive;
            FileObject[] sourceRoots = this.project.getSourceRoots().getRoots();
            FileObject[] files = this.findSourcesAndPackages(context, sourceRoots);
            boolean bl = recursive = context.lookup(NonRecursiveFolder.class) == null;
            if (files != null) {
                p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(sourceRoots, files[0]), (boolean)recursive));
                return new String[]{"compile-single"};
            }
            FileObject[] testRoots = this.project.getTestSourceRoots().getRoots();
            files = this.findSourcesAndPackages(context, testRoots);
            p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(testRoots, files[0]), (boolean)recursive));
            return new String[]{"compile-test-single"};
        }
        if (command.equals("test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return this.setupTestSingle(p, files);
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return this.setupDebugTestSingle(p, files);
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findSources(context);
            path = null;
            if (files != null) {
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix"};
            } else {
                files = this.findTestSources(context, false);
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getTestSourceRoots().getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix-test"};
            }
            if (path.endsWith(".java")) {
                path = path.substring(0, path.length() - 5);
            }
        } else {
            if (command.equals("run") || command.equals("debug") || command.equals("debug.stepinto")) {
                EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
                String mainClass = (String)ep.get((Object)"main.class");
                int result = this.isSetMainClass(this.project.getSourceRoots().getRoots(), mainClass);
                if (result != 0) {
                    do {
                        if (this.showMainClassWarning(mainClass, ProjectUtils.getInformation((Project)this.project).getDisplayName(), ep, result)) {
                            return null;
                        }
                        mainClass = (String)ep.get((Object)"main.class");
                    } while ((result = this.isSetMainClass(this.project.getSourceRoots().getRoots(), mainClass)) != 0);
                    try {
                        if (!this.updateHelper.requestSave()) return null;
                        this.updateHelper.putProperties("nbproject/project.properties", ep);
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().log(1, "Error while saving project: " + ioe);
                    }
                }
                if (!command.equals("run")) {
                    p.setProperty("debug.class", mainClass);
                }
                if ((targetNames = (String[])this.commands.get(command)) != null) return targetNames;
                throw new IllegalArgumentException(command);
            }
            if (command.equals("run.single") || command.equals("debug.single")) {
                FileObject[] files = this.findTestSources(context, false);
                if (files != null) {
                    if (!command.equals("run.single")) return this.setupDebugTestSingle(p, files);
                    return this.setupTestSingle(p, files);
                }
                FileObject file = this.findSources(context)[0];
                String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), file), (FileObject)file);
                p.setProperty("javac.includes", clazz);
                if (clazz.endsWith(".java")) {
                    clazz = clazz.substring(0, clazz.length() - 5);
                }
                clazz = clazz.replace('/', '.');
                if (!J2SEProjectUtil.hasMainMethod(file)) {
                    if (AppletSupport.isApplet(file)) {
                        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
                        String jvmargs = ep.getProperty("run.jvmargs");
                        URL url = null;
                        if (jvmargs == null || jvmargs.indexOf("java.security.policy") <= 0) {
                            AppletSupport.generateSecurityPolicy(this.project.getProjectDirectory());
                            if (jvmargs == null || jvmargs.length() == 0) {
                                ep.setProperty("run.jvmargs", "-Djava.security.policy=applet.policy");
                            } else {
                                ep.setProperty("run.jvmargs", jvmargs + " -Djava.security.policy=applet.policy");
                            }
                            this.updateHelper.putProperties("nbproject/project.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject((Project)this.project);
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().log(1, "Error while saving project: " + e);
                            }
                        }
                        if ((url = file.existsExt("html") || file.existsExt("HTML") ? this.copyAppletHTML(file, "html") : this.generateAppletHTML(file)) == null) {
                            return null;
                        }
                        p.setProperty("applet.url", url.toString());
                        if (command.equals("run.single")) {
                            return new String[]{"run-applet"};
                        }
                        p.setProperty("debug.class", clazz);
                        return new String[]{"debug-applet"};
                    }
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"LBL_No_Main_Classs_Found", (Object)clazz), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return null;
                }
                if (command.equals("run.single")) {
                    p.setProperty("run.class", clazz);
                    return (String[])this.commands.get("run.single");
                }
                p.setProperty("debug.class", clazz);
                return (String[])this.commands.get("debug.single");
            }
            targetNames = (String[])this.commands.get(command);
            if (targetNames != null) return targetNames;
            throw new IllegalArgumentException(command);
        }
        p.setProperty("fix.includes", path);
        return targetNames;
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        return new String[]{"debug-test"};
    }

    public boolean isActionEnabled(String command, Lookup context) {
        FileObject buildXml = this.findBuildXml();
        if (buildXml == null || !buildXml.isValid()) {
            return false;
        }
        if (command.equals("compile.single")) {
            return this.findSourcesAndPackages(context, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(context, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (command.equals("test.single")) {
            return this.findTestSourcesForSources(context) != null;
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return files != null && files.length == 1;
        }
        if (command.equals("run.single") || command.equals("debug.single") || command.equals("debug.fix")) {
            FileObject[] fos = this.findSources(context);
            if (fos != null && fos.length == 1) {
                return true;
            }
            fos = this.findTestSources(context, false);
            return fos != null && fos.length == 1;
        }
        return true;
    }

    private FileObject[] findSources(Lookup context) {
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcPath[i], (String)".java", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, null, (boolean)true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || "java".equals(files[i].getExt())) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject[] srcRoots) {
        for (int i = 0; i < srcRoots.length; ++i) {
            FileObject[] result = this.findSourcesAndPackages(context, srcRoots[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context, boolean checkInSrcDir) {
        FileObject[] files;
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files2 = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcPath[i], (String)".java", (boolean)true);
            if (files2 == null) continue;
            return files2;
        }
        if (checkInSrcDir && testSrcPath.length > 0 && (files = this.findSources(context)) != null) {
            FileObject srcRoot = this.getRoot(this.project.getSourceRoots().getRoots(), files[0]);
            for (int i = 0; i < testSrcPath.length; ++i) {
                FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath[i], (String)SUBST, (boolean)true);
                if (files2 == null) continue;
                return files2;
            }
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup context) {
        FileObject[] sourceFiles = this.findSources(context);
        if (sourceFiles == null) {
            return null;
        }
        FileObject[] testSrcPath = this.project.getTestSourceRoots().getRoots();
        if (testSrcPath.length == 0) {
            return null;
        }
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        FileObject srcDir = this.getRoot(srcPath, sourceFiles[0]);
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath[i], (String)SUBST, (boolean)true);
            if (files2 == null) continue;
            return files2;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] roots, FileObject file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"File can't be null");
        }
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!$assertionsDisabled && roots[i] == null) {
                throw new AssertionError((Object)"Source Path Root can't be null");
            }
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    private int isSetMainClass(FileObject[] sourcesRoots, String mainClass) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? 0 : -2;
        }
        if (mainClass == null || mainClass.length() == 0) {
            return -1;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/execute");
        if (J2SEProjectUtil.isMainClass(mainClass, classPath)) {
            return 0;
        }
        return -2;
    }

    public static boolean canBeRun(FileObject classFO) {
        if (classFO == null) {
            return false;
        }
        try {
            DataObject classDO = DataObject.find((FileObject)classFO);
            Node.Cookie obj = classDO.getCookie(SourceCookie.class);
            if (obj == null || !(obj instanceof SourceCookie)) {
                return false;
            }
            SourceCookie cookie = (SourceCookie)obj;
            SourceElement source = cookie.getSource();
            ClassElement[] classes = source.getClasses();
            boolean hasMain = false;
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].hasMainMethod()) continue;
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean showMainClassWarning(String mainClass, String projectName, EditableProperties ep, int messageType) {
        boolean canceled;
        String message;
        final JButton okButton = new JButton(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MainClassWarning.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (messageType) {
            case -1: {
                message = MessageFormat.format(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassNotFound"), projectName);
                break;
            }
            case -2: {
                message = MessageFormat.format(NbBundle.getMessage((Class)MainClassWarning.class, (String)"LBL_MainClassWrong"), mainClass, projectName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning panel = new MainClassWarning(message, this.project.getSourceRoots().getRoots());
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)MainClassWarning.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            mainClass = panel.getSelectedMainClass();
            canceled = false;
            ep.put((Object)"main.class", (Object)(mainClass == null ? "" : mainClass));
        }
        dlg.dispose();
        return canceled;
    }

    private void showPlatformWarning() {
        JButton closeOption = new JButton(NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"CTL_BrokenPlatform_Close"));
        closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"AD_BrokenPlatform_Close"));
        ProjectInformation pi = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String projectDisplayName = pi == null ? NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"TEXT_BrokenPlatform_UnknownProjectName") : pi.getDisplayName();
        DialogDescriptor dd = new DialogDescriptor((Object)NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"TEXT_BrokenPlatform", (Object)projectDisplayName), NbBundle.getMessage((Class)J2SEActionProvider.class, (String)"MSG_BrokenPlatform_Title"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        dd.setMessageType(2);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
    }

    private URL generateAppletHTML(FileObject file) {
        URL url = null;
        try {
            String buildDirProp = this.project.evaluator().getProperty("build.dir");
            String classesDirProp = this.project.evaluator().getProperty("build.classes.dir");
            FileObject buildDir = this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp);
            FileObject classesDir = this.updateHelper.getAntProjectHelper().resolveFileObject(classesDirProp);
            if (buildDir == null) {
                buildDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)buildDirProp);
            }
            if (classesDir == null) {
                classesDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)classesDirProp);
            }
            String activePlatformName = this.project.evaluator().getProperty("platform.active");
            url = AppletSupport.generateHtmlFileURL(file, buildDir, classesDir, activePlatformName);
        }
        catch (FileStateInvalidException fe) {
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
        return url;
    }

    private URL copyAppletHTML(FileObject file, String ext) {
        URL url = null;
        try {
            FileObject targetHtml;
            String buildDirProp = this.project.evaluator().getProperty("build.dir");
            FileObject buildDir = this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp);
            if (buildDir == null) {
                buildDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)buildDirProp);
            }
            FileObject htmlFile = null;
            htmlFile = file.getParent().getFileObject(file.getName(), "html");
            if (htmlFile == null) {
                htmlFile = file.getParent().getFileObject(file.getName(), "HTML");
            }
            if (htmlFile == null) {
                return null;
            }
            FileObject existingFile = buildDir.getFileObject(htmlFile.getName(), htmlFile.getExt());
            if (existingFile != null) {
                existingFile.delete();
            }
            if ((targetHtml = htmlFile.copy(buildDir, file.getName(), ext)) != null) {
                String activePlatformName = this.project.evaluator().getProperty("platform.active");
                url = AppletSupport.getHTMLPageURL(targetHtml, activePlatformName);
            }
        }
        catch (FileStateInvalidException fe) {
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
        return url;
    }

    static {
        $assertionsDisabled = !J2SEActionProvider.class.desiredAssertionStatus();
        supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto", "delete", "copy", "move", "rename"};
        platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto"};
        SRCDIRJAVA = Pattern.compile("\\.java$");
    }
}

