/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MultipartIdImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TransientElement;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.util.Utilities;

public abstract class ImportImpl
extends SemiPersistentElement
implements Import {
    private static final ElementInfo DEFAULT_INFO = new ElementInfo(null, 54, null);
    private String name = null;
    private boolean isStatic = false;
    private boolean isOnDemand = false;
    private MultipartId identifier = null;

    public ImportImpl(StorableObject s) {
        super(s);
    }

    protected void matchPersistent(ElementInfo info) {
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        ElementInfo refInfo = this.getElementInfo();
        if (!Utilities.compareObjects((Object)refInfo.name, (Object)newInfo.name)) {
            this.setName(newInfo.name);
        }
        this.resetChildren();
    }

    protected void resetChildren() {
        super.resetChildren();
        if (this.identifier != null) {
            MultipartId temp = this.identifier;
            this.identifier = null;
            temp.refDelete();
            this.childrenInited = false;
        }
    }

    public String getName() {
        if (this.isChanged(2)) {
            return this.name;
        }
        return this.getElementInfo().name;
    }

    public void setName(String name) {
        this.objectChanged(2);
        this.name = name;
        MultipartId newValue = this.createIdentifier();
        this.changeChild((Element)this.getIdentifier(), (Element)newValue);
        this.identifier = newValue;
    }

    private MultipartId createIdentifier() {
        if (this.name == null) {
            return null;
        }
        MultipartIdClass proxy = ((JavaModelPackage)this.refImmediatePackage()).getMultipartId();
        return proxy.createMultipartId(this.name, null, null);
    }

    void setData(String name, boolean onDemand, boolean isStatic, MultipartId identifier) {
        this.name = name;
        if (identifier == null) {
            this.identifier = this.createIdentifier();
        } else {
            this.identifier = identifier;
            if (name == null) {
                name = identifier.getName();
            }
        }
        this.changeChild(null, (Element)this.identifier);
        this.isOnDemand = onDemand;
        this.isStatic = isStatic;
        this.childrenInited = true;
    }

    public boolean isStatic() {
        if (this.isChanged(4)) {
            return this.isStatic;
        }
        ASTree tree = this.getASTree();
        if (tree == null) {
            return false;
        }
        return tree.getSubTrees()[0] != null;
    }

    public void setStatic(boolean s) {
        this.objectChanged(4);
        this.isStatic = s;
    }

    public boolean isOnDemand() {
        if (this.isChanged(8)) {
            return this.isOnDemand;
        }
        return this.getElementInfo().infoType == 68;
    }

    public void setOnDemand(boolean s) {
        this.objectChanged(8);
        this.isOnDemand = s;
    }

    protected ASTree getPartTree(ElementPartKind part) {
        if (ElementPartKindEnum.NAME.equals((Object)part)) {
            return this.getASTree().getSubTrees()[1];
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part);
    }

    String getRawText() {
        MetadataElement id;
        StringBuffer buf = new StringBuffer();
        buf.append("import ");
        if (this.isStatic()) {
            buf.append("static ");
        }
        buf.append((id = (MetadataElement)this.getIdentifier()) == null ? this.getName() : id.getSourceText());
        if (this.isOnDemand()) {
            buf.append(".*");
        }
        buf.append(';');
        return buf.toString();
    }

    public void getDiff(List diff) {
        int startOffset;
        int endOffset;
        MDRParser parser = this.getParser();
        ASTree tree = this.getASTree();
        ASTree[] children = tree.getSubTrees();
        if (this.isChanged(4)) {
            endOffset = parser.getToken(children[1].getFirstToken()).getStartOffset();
            if (this.isStatic) {
                if (children[0] == null) {
                    startOffset = endOffset;
                    diff.add(new DiffElement(startOffset, endOffset, "static "));
                }
            } else if (children[0] != null) {
                startOffset = parser.getToken(children[0].getFirstToken()).getStartOffset();
                diff.add(new DiffElement(startOffset, endOffset, ""));
            }
        }
        this.getChildDiff(diff, parser, children[1], (MetadataElement)this.getIdentifier(), 2);
        if (this.isChanged(8)) {
            startOffset = parser.getToken(children[1].getLastToken()).getEndOffset();
            endOffset = parser.getToken(tree.getLastToken()).getStartOffset();
            diff.add(new DiffElement(startOffset, endOffset, this.isOnDemand() ? ".*" : ""));
        }
    }

    public void replaceChild(Element oldElement, Element newElement) {
        if (this.childrenInited && oldElement.equals(this.identifier)) {
            this.setIdentifier((MultipartId)newElement);
            return;
        }
    }

    public MultipartId getIdentifier() {
        this.checkUpToDate();
        if (!this.childrenInited) {
            this.initChildren();
        }
        return this.identifier;
    }

    public void setIdentifier(MultipartId newValue) {
        this.objectChanged(2);
        this.changeChild((Element)this.getIdentifier(), (Element)newValue);
        this.identifier = newValue;
        this.name = newValue != null ? ((MultipartIdImpl)newValue).getSourceText() : "";
    }

    protected void initChildren() {
        this.childrenInited = false;
        ElementInfo info = this.getElementInfo();
        ASTree tree = info.getTypeAST(this);
        if (this.identifier != null) {
            ((TransientElement)this.identifier).init(tree);
        } else {
            this.identifier = (MultipartId)this.createElement(tree, (RefClass)((JavaModelPackage)this.refImmediatePackage()).getMultipartId());
        }
        this.childrenInited = true;
    }

    public List getChildren() {
        ArrayList l = new ArrayList(1);
        ImportImpl.addIfNotNull(l, this.getIdentifier());
        return l;
    }

    public NamedElement getImportedNamespace() {
        JavaModelPackage model = (JavaModelPackage)this.refImmediatePackage();
        MultipartId id = this.getIdentifier();
        if (id == null) {
            return null;
        }
        return id.getElement();
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    private String getSignature(Feature feature) {
        if (feature instanceof Method) {
            StringBuffer sig = new StringBuffer();
            Object[] pars = ((Method)feature).getParameters().toArray();
            sig.append(feature.getName());
            for (int i = 0; i < pars.length; ++i) {
                Parameter par = (Parameter)pars[i];
                sig.append(par.getType().getName());
                sig.append(';');
            }
            sig.append('.');
            return sig.toString();
        }
        return feature.getName();
    }

    private void getAllStaticWithName(JavaClass jcls, String name, Map fMap, Set visited) {
        if (!visited.add(jcls)) {
            return;
        }
        JavaClass superJavaClass = jcls.getSuperClass();
        Iterator ifaceIt = jcls.getInterfaces().iterator();
        if (superJavaClass != null) {
            this.getAllStaticWithName(superJavaClass, name, fMap, visited);
        }
        while (ifaceIt.hasNext()) {
            JavaClass ifaceClass = (JavaClass)ifaceIt.next();
            if (ifaceClass == null) continue;
            this.getAllStaticWithName(ifaceClass, name, fMap, visited);
        }
        Object[] features = jcls.getFeatures().toArray();
        for (int i = 0; i < features.length; ++i) {
            Feature feature = (Feature)features[i];
            if (!Modifier.isStatic(feature.getModifiers()) || name != null && !name.equals(feature.getName()) || !(feature instanceof Field) && !(feature instanceof Method)) continue;
            fMap.put(this.getSignature(feature), feature);
        }
    }

    public Collection getImportedElements() {
        if (this.isStatic()) {
            HashMap imported = new HashMap();
            if (this.isOnDemand()) {
                this.getAllStaticWithName((JavaClass)this.getImportedNamespace(), null, imported, new HashSet());
            } else {
                ASTree tree;
                ASTree[] parts;
                MDRParser parser = this.getParser();
                Object symbol = parser.getSemanticInfo((parts = (tree = this.getPartTree((ElementPartKind)ElementPartKindEnum.NAME)).getSubTrees())[0], this);
                if (symbol instanceof JavaClass) {
                    String name = (String)((Token)parts[1]).getValue();
                    this.getAllStaticWithName((JavaClass)symbol, name, imported, new HashSet());
                }
            }
            return imported.values();
        }
        if (this.isOnDemand()) {
            NamedElement el = this.getImportedNamespace();
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            if (el instanceof JavaPackage) {
                Iterator rIt = ((JavaPackage)el).getResources().iterator();
                while (rIt.hasNext()) {
                    Iterator topIt = ((Resource)rIt.next()).getClassifiers().iterator();
                    while (topIt.hasNext()) {
                        JavaClass jcls = (JavaClass)topIt.next();
                        if (!Modifier.isPublic(jcls.getModifiers())) continue;
                        classes.add(jcls);
                    }
                }
            } else if (el instanceof JavaClass && !(el instanceof UnresolvedClass)) {
                JavaClass jcls = (JavaClass)el;
                ClassIndex index = ClassIndex.getIndex((JavaModelPackage)jcls.refImmediatePackage());
                Iterator innerIt = index.getClassesByFQNPrefix(jcls.getName().concat(".")).iterator();
                while (innerIt.hasNext()) {
                    JavaClass inner = (JavaClass)innerIt.next();
                    if (!inner.getDeclaringClass().equals(jcls)) continue;
                    classes.add(inner);
                }
            }
            return classes;
        }
        return Collections.singletonList(this.getImportedNamespace());
    }

    protected void hardRefParent(boolean enabled) {
    }

    protected void parentChanged() {
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getImport().createImport(this.getName(), (MultipartId)ImportImpl.duplicateElement((Element)this.getIdentifier(), targetExtent), this.isStatic(), this.isOnDemand());
    }

    protected void _delete() {
        if (this.childrenInited) {
            this.deleteChild((Element)this.identifier);
        }
        super._delete();
    }
}

