/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;

public class BinaryCacheManager
extends ParsingLayerCacheManager {
    private static final String ALL_LAYERS = "all-layers.dat";
    private File cacheFile;
    private static int fileCounter;
    private static final String[] ATTR_TYPES;
    private HashMap sizes;
    static /* synthetic */ Class class$org$netbeans$core$startup$layers$BinaryCacheManager;

    public BinaryCacheManager(File cacheDir) throws IOException {
        super(cacheDir);
        this.cacheFile = new File(cacheDir, ALL_LAYERS);
    }

    public boolean cacheExists() {
        return this.cacheFile.exists();
    }

    public void cleanupCache() throws IOException {
        if (this.cacheFile.exists()) {
            File tmpFile = new File(this.cacheFile.getParentFile(), this.cacheFile.getName() + "." + fileCounter++);
            tmpFile.delete();
            boolean renamed = false;
            for (int i = 0; i < 5 && !(renamed = this.cacheFile.renameTo(tmpFile)); ++i) {
                LayerCacheManager.err.log("cannot rename (#" + i + "): " + this.cacheFile);
                System.gc();
                System.runFinalization();
                LayerCacheManager.err.log("after GC");
            }
            if (!renamed) {
                this.cacheFile.deleteOnExit();
                throw new IOException("Could not delete: " + this.cacheFile);
            }
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    public boolean supportsLoad() {
        return false;
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (this.cacheFile.exists()) {
            LayerCacheManager.err.log("Loading from " + this.cacheFile);
            BinaryFS fs = new BinaryFS(this.cacheFile.getAbsolutePath());
            return fs;
        }
        throw new IllegalStateException();
    }

    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem store(ParsingLayerCacheManager.MemFolder root) throws IOException {
        this.cleanupCache();
        FileOutputStream os = new FileOutputStream(this.cacheFile);
        try {
            this.sizes = new HashMap(1000);
            int fsSize = this.computeSize(root);
            LayerCacheManager.err.log("Writing binary layer cache of length " + (fsSize + BinaryFS.MAGIC.length) + " to " + this.cacheFile);
            ((OutputStream)os).write(BinaryFS.MAGIC);
            BinaryWriter bw = new BinaryWriter(os, root, fsSize);
            this.writeFolder(bw, root);
        }
        finally {
            this.sizes = null;
            ((OutputStream)os).close();
        }
        return this.createLoadedFileSystem();
    }

    private void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder) throws IOException {
        if (folder.attrs != null) {
            bw.writeInt(folder.attrs.size());
            Iterator it = folder.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (folder.children != null) {
            ParsingLayerCacheManager.MemFileOrFolder item;
            bw.writeInt(folder.children.size());
            int baseOffset = bw.getPosition();
            Iterator it = folder.children.iterator();
            while (it.hasNext()) {
                item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                baseOffset += this.computeHeaderSize(item);
            }
            it = folder.children.iterator();
            while (it.hasNext()) {
                item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                bw.writeString(item.name);
                bw.writeByte(item instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                bw.writeInt(baseOffset);
                baseOffset += this.computeSize(item);
            }
            it = folder.children.iterator();
            while (it.hasNext()) {
                item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                if (item instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(bw, (ParsingLayerCacheManager.MemFile)item);
                    continue;
                }
                this.writeFolder(bw, (ParsingLayerCacheManager.MemFolder)item);
            }
        } else {
            bw.writeInt(0);
        }
    }

    private void writeFile(BinaryWriter bw, ParsingLayerCacheManager.MemFile file) throws IOException {
        if (file.attrs != null) {
            bw.writeInt(file.attrs.size());
            Iterator it = file.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (file.ref != null) {
            bw.writeInt(-1);
            bw.writeString(file.ref.toString());
        } else if (file.contents != null) {
            bw.writeInt(file.contents.length);
            bw.writeBytes(file.contents);
        } else {
            bw.writeInt(0);
        }
        bw.writeBaseURL(file.base);
    }

    private void writeAttribute(BinaryWriter bw, ParsingLayerCacheManager.MemAttr attr) throws IOException {
        int i;
        bw.writeString(attr.name);
        for (i = 0; i < ATTR_TYPES.length && !ATTR_TYPES[i].equals(attr.type); ++i) {
        }
        bw.writeByte((byte)i);
        bw.writeString(attr.data);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder mf) {
        Integer i = (Integer)this.sizes.get(mf);
        if (i != null) {
            return i;
        }
        int size = 4;
        if (mf.attrs != null) {
            Iterator it = mf.attrs.iterator();
            while (it.hasNext()) {
                size += this.computeSize((ParsingLayerCacheManager.MemAttr)it.next());
            }
        }
        if (mf instanceof ParsingLayerCacheManager.MemFile) {
            ParsingLayerCacheManager.MemFile file = (ParsingLayerCacheManager.MemFile)mf;
            size += 4;
            if (file.ref != null) {
                size += BinaryCacheManager.computeSize(file.ref.toString());
            } else if (file.contents != null) {
                size += file.contents.length;
            }
            size += 4;
        } else {
            ParsingLayerCacheManager.MemFolder folder = (ParsingLayerCacheManager.MemFolder)mf;
            size += 4;
            if (folder.children != null) {
                Iterator it = folder.children.iterator();
                while (it.hasNext()) {
                    ParsingLayerCacheManager.MemFileOrFolder item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                    size += this.computeHeaderSize(item);
                    size += this.computeSize(item);
                }
            }
        }
        this.sizes.put(mf, new Integer(size));
        return size;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder mof) {
        return BinaryCacheManager.computeSize(mof.name) + 1 + 4;
    }

    private static int computeSize(String s) {
        try {
            return 4 + s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException ise = new IllegalStateException(e.toString());
            LayerCacheManager.err.annotate((Throwable)ise, (Throwable)e);
            throw ise;
        }
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr attr) {
        return BinaryCacheManager.computeSize(attr.name) + 1 + BinaryCacheManager.computeSize(attr.data);
    }

    static {
        ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue"};
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private Map urls;
        static final /* synthetic */ boolean $assertionsDisabled;

        BinaryWriter(OutputStream os, ParsingLayerCacheManager.MemFolder root, int fsSize) throws IOException {
            this.os = os;
            this.urls = this.writeBaseUrls(root, fsSize);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte b) throws IOException {
            this.os.write(b);
            ++this.position;
        }

        void writeBytes(byte[] bytes) throws IOException {
            this.os.write(bytes);
            this.position += bytes.length;
        }

        void writeInt(int num) throws IOException {
            byte[] data = new byte[]{(byte)num, (byte)(num >> 8), (byte)(num >> 16), (byte)(num >> 24)};
            this.writeBytes(data);
        }

        void writeString(String str) throws IOException {
            byte[] data;
            try {
                data = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                LayerCacheManager.err.annotate((Throwable)ise, (Throwable)e);
                throw ise;
            }
            this.writeInt(data.length);
            this.writeBytes(data);
        }

        void writeBaseURL(URL url) throws IOException {
            int[] number = (int[])this.urls.get(url);
            if (!$assertionsDisabled && number == null) {
                throw new AssertionError((Object)("Should not be null, because it was collected: " + url + " map: " + this.urls));
            }
            this.writeInt(number[0]);
        }

        private Map writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder root, int fsSize) throws IOException {
            URL u;
            Map.Entry entry;
            int i;
            LinkedHashMap map = new LinkedHashMap();
            int[] counter = new int[1];
            this.collectBaseUrls(root, map, counter);
            int size = 0;
            Iterator it = map.entrySet().iterator();
            for (i = 0; i < counter[0]; ++i) {
                entry = it.next();
                u = (URL)entry.getKey();
                if (!$assertionsDisabled && ((int[])entry.getValue())[0] != i) {
                    throw new AssertionError((Object)(i + "th key should be it " + ((int[])entry.getValue())[0]));
                }
                size += BinaryCacheManager.computeSize(u.toExternalForm());
            }
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + size + fsSize);
            this.writeInt(size);
            it = map.entrySet().iterator();
            for (i = 0; i < counter[0]; ++i) {
                entry = it.next();
                u = (URL)entry.getKey();
                this.writeString(u.toExternalForm());
            }
            return map;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder f, Map map, int[] counter) {
            int[] exists;
            if (f.base != null && (exists = (int[])map.get(f.base)) == null) {
                map.put(f.base, counter.clone());
                counter[0] = counter[0] + 1;
            }
            if (f instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)f).children != null) {
                Iterator it = ((ParsingLayerCacheManager.MemFolder)f).children.iterator();
                while (it.hasNext()) {
                    this.collectBaseUrls((ParsingLayerCacheManager.MemFileOrFolder)it.next(), map, counter);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$startup$layers$BinaryCacheManager == null ? (class$org$netbeans$core$startup$layers$BinaryCacheManager = BinaryCacheManager.class$("org.netbeans.core.startup.layers.BinaryCacheManager")) : class$org$netbeans$core$startup$layers$BinaryCacheManager).desiredAssertionStatus();
        }
    }
}

