/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefFeatured;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class JaxWsCodeGenerator {
    private static final List IMPLICIT_JSP_OBJECTS = Arrays.asList("request", "response", "session", "out", "page", "config", "application", "pageContext");
    private static final String HINT_INIT_ARGUMENTS = " // TODO initialize WS operation arguments here\n";
    private static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    private static final String JAVA_SERVICE_DEF = "   {0} {7} = new {0}();\n";
    private static final String JAVA_PORT_DEF = "   {1} port = {7}.{2}();\n";
    private static final String JAVA_RESULT = "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n";
    private static final String JAVA_VOID = "   {3}   port.{5}({6});\n";
    private static final String JAVA_OUT = "   {8}.println(\"Result = \"+result);\n";
    private static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'";
    private static final String JAVA_STATIC_STUB_ASYNC_POLLING = "\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}();\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'";
    private static final String JAVA_STATIC_STUB_ASYNC_CALLBACK = "\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}();\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JSP_STATIC_STUB = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process result here\n\t{4} result = port.{5}({6});\n\tout.println(\"Result = \"+result);\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_VOID = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\tport.{5}({6});\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_POLLING = "    <%-- start web service invocation(async. polling) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} resp = port.{5}({6});\n\twhile(!resp.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+resp.get());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. polling) --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_CALLBACK = "    <%-- start web service invocation(async. callback) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} result = port.{5}({6});\n\twhile(!result.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+asyncHandler.getResponse());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. callback) --%><hr/>\n";
    private static final String JSP_CALLBACK_HANDLER = "<%!\nclass {0} implements javax.xml.ws.AsyncHandler<{1}> '{'\n    private {1} output;\n\n    public void handleResponse(javax.xml.ws.Response<{1}> response) '{'\n        try '{'\n            output = response.get();\n        '}' catch(Exception ex) '{'\n            // TODO handle exception\n        '}'\n    '}'\n\n    {1} getResponse() '{'\n         return output;\n    '}'\n'}'\n%>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertMethodCall(DataObject dataObj, Node sourceNode, Node operationNode) {
        String argumentDeclarationPart;
        String argumentInitializationPart;
        String returnTypeName;
        String serviceJavaName;
        String portGetterMethod;
        String portJavaName;
        String operationJavaName;
        String wsdlUrl;
        Client client;
        WsdlOperation operation;
        String serviceFieldName;
        EditorCookie cookie = (EditorCookie)sourceNode.getCookie(EditorCookie.class);
        boolean inJsp = cookie != null && "text/x-jsp".equals(cookie.getDocument().getProperty("mimeType"));
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        try {
            serviceFieldName = "service";
            Node portNode = operationNode.getParentNode();
            Node serviceNode = portNode.getParentNode();
            Node wsdlNode = serviceNode.getParentNode();
            operation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
            WsdlPort port = (WsdlPort)portNode.getLookup().lookup(WsdlPort.class);
            WsdlService service = (WsdlService)serviceNode.getLookup().lookup(WsdlService.class);
            client = (Client)wsdlNode.getLookup().lookup(Client.class);
            wsdlUrl = client.getWsdlUrl();
            operationJavaName = operation.getJavaName();
            portJavaName = port.getJavaName();
            portGetterMethod = port.getPortGetter();
            serviceJavaName = service.getJavaName();
            List arguments = operation.getParameters();
            returnTypeName = operation.getReturnTypeName();
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            for (int i = 0; i < arguments.size(); ++i) {
                String argumentTypeName = ((WsdlParameter)arguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = JaxWsCodeGenerator.resolveResponseType(argumentTypeName);
                    if (inJsp) {
                        argumentTypeName = JaxWsCodeGenerator.pureJavaName(portJavaName) + "CallbackHandler";
                    }
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = ((WsdlParameter)arguments.get(i)).getName();
                if (inJsp && IMPLICIT_JSP_OBJECTS.contains(argumentName)) {
                    argumentName = argumentName + "_1";
                }
                String argumentDeclaration = argumentTypeName + " " + argumentName;
                argumentBuffer1.append("\t" + argumentTypeName + " " + argumentName + " = " + JaxWsCodeGenerator.resolveInitValue(argumentTypeName, dataObj.getPrimaryFile()) + "\n");
                argumentBuffer2.append(i > 0 ? ", " + argumentName : argumentName);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        EditorCookie ec = (EditorCookie)dataObj.getCookie(EditorCookie.class);
        JEditorPane pane = ec.getOpenedPanes()[0];
        int caretOffset = pane.getCaretPosition();
        ArrayList<String> errors = new ArrayList<String>();
        JMManager manager = (JMManager)JMManager.getManager();
        MDRepository repository = JavaModel.getJavaRepository();
        boolean success = false;
        if (inJsp) {
            final StyledDocument document = cookie.getDocument();
            String invocationBody = "";
            Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart};
            switch (operation.getOperationType()) {
                case 0: {
                    if ("void".equals(returnTypeName)) {
                        invocationBody = MessageFormat.format(JSP_STATIC_STUB_VOID, args);
                        break;
                    }
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB, args);
                    break;
                }
                case 1: {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_POLLING, args);
                    break;
                }
                case 2: {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_CALLBACK, args);
                }
            }
            try {
                String content = document.getText(0, document.getLength());
                int pos = content.lastIndexOf("</body>");
                if (pos < 0) {
                    pos = content.lastIndexOf("</html>");
                }
                if (pos >= 0) {
                    while (pos > 0 && content.charAt(pos - 1) != '\n' && content.charAt(pos - 1) != '\r') {
                        --pos;
                    }
                } else {
                    pos = document.getLength();
                }
                if (2 == operation.getOperationType()) {
                    Object[] args1 = new Object[]{callbackHandlerName, responseType};
                    final String methodBody = MessageFormat.format(JSP_CALLBACK_HANDLER, args1);
                    final String invocationPart = invocationBody;
                    final int position = pos;
                    NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                document.insertString(document.getLength(), methodBody, null);
                                document.insertString(position, invocationPart, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    document.insertString(pos, invocationBody, null);
                }
                success = true;
            }
            catch (BadLocationException ex) {}
        } else {
            JavaClass javaClass;
            boolean generateWsRefInjection;
            block60: {
                generateWsRefInjection = false;
                boolean insertServiceDef = true;
                String printerName = "System.out";
                javaClass = null;
                boolean rollbackFlag = true;
                repository.beginTrans(true);
                try {
                    CallableFeature cm = JMIUtils.getCallableFeatureFromNode((Node)sourceNode);
                    if (!cm.isValid()) break block60;
                    RefFeatured refFeatured = cm.refImmediateComposite();
                    if (refFeatured instanceof JavaClass) {
                        javaClass = (JavaClass)refFeatured;
                        generateWsRefInjection = InjectionTargetQuery.isInjectionTarget((JavaClass)javaClass);
                        insertServiceDef = !generateWsRefInjection;
                        JavaClass superClass = javaClass.getSuperClass();
                        if (cm instanceof Method) {
                            Method m = (Method)cm;
                            String printer = JaxWsCodeGenerator.findPrinter((Method)cm);
                            if (printer != null) {
                                printerName = printer;
                            }
                        }
                        if ("javax.servlet.http.HttpServlet".equals(superClass.getName())) {
                            argumentInitializationPart = JaxWsCodeGenerator.fixNamesInInitializationPart(argumentInitializationPart);
                            argumentDeclarationPart = JaxWsCodeGenerator.fixNamesInDeclarationPart(argumentDeclarationPart);
                        }
                        if (generateWsRefInjection) {
                            HashSet<String> serviceFieldNames = new HashSet<String>();
                            List contents = javaClass.getContents();
                            boolean injectionExists = false;
                            for (int i = 0; i < contents.size(); ++i) {
                                Object obj = contents.get(i);
                                if (!(obj instanceof Field)) continue;
                                String fieldTypeName = ((Field)obj).getType().getName();
                                if (serviceJavaName.equals(fieldTypeName)) {
                                    serviceFieldName = ((Field)obj).getName();
                                    generateWsRefInjection = false;
                                    injectionExists = true;
                                    break;
                                }
                                serviceFieldNames.add(((Field)obj).getName());
                            }
                            if (!injectionExists) {
                                serviceFieldName = JaxWsCodeGenerator.findProperServiceFieldName(serviceFieldNames);
                            }
                        }
                    }
                    ClassDefinition cd = cm.getDeclaringClass();
                    JavaModelPackage modelPkg = JavaMetamodel.getManager().getJavaExtent((Element)cd);
                    int targetOffset = caretOffset;
                    Element elem = manager.getElementByOffset(dataObj.getPrimaryFile(), caretOffset);
                    if (elem instanceof BehavioralFeature) {
                        elem = ((BehavioralFeature)elem).getBody();
                    } else if (elem instanceof PrimaryExpression) {
                        while (!(elem instanceof Statement)) {
                            elem = (Element)elem.refImmediateComposite();
                        }
                    }
                    if (elem instanceof StatementBlock) {
                        List statements = ((StatementBlock)elem).getStatements();
                        if (statements.size() > 0) {
                            int i;
                            for (i = 0; i < statements.size(); ++i) {
                                Statement s = (Statement)statements.get(i);
                                if (JavaMetamodel.getManager().getElementPosition((Element)s).getBegin().getOffset() > targetOffset) break;
                            }
                            if (i > 0) {
                                elem = (Statement)statements.get(i - 1);
                                targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getEnd().getOffset();
                            } else {
                                elem = (Statement)statements.get(i);
                                targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getBegin().getOffset();
                            }
                        } else {
                            targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getBegin().getOffset() + 1;
                        }
                    } else if (elem instanceof Statement) {
                        targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getEnd().getOffset();
                    }
                    Document doc = pane.getDocument();
                    IndentEngine eng = IndentEngine.find((Document)doc);
                    StringWriter textWriter = new StringWriter();
                    Writer indentWriter = eng.createWriter(doc, targetOffset, (Writer)textWriter);
                    String invocationBody = JaxWsCodeGenerator.getJavaInvocationBody(operation, insertServiceDef, serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart, serviceFieldName, printerName, responseType);
                    indentWriter.write(invocationBody);
                    indentWriter.close();
                    String textToInsert = textWriter.toString();
                    try {
                        doc.insertString(targetOffset, textToInsert, null);
                    }
                    catch (BadLocationException badLoc) {
                        doc.insertString(targetOffset + 1, textToInsert, null);
                    }
                    success = true;
                    rollbackFlag = false;
                }
                catch (NullPointerException npe) {
                    if (errors.size() == 0) {
                        errors.add(NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_UnexpectedNPE", (Object)npe.getMessage()));
                        ErrorManager.getDefault().notify(1, (Throwable)npe);
                    }
                }
                catch (BadLocationException badLoc) {
                    errors.add(NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_UnexpectedBLE", (Object)badLoc.getMessage()));
                    ErrorManager.getDefault().notify(1, (Throwable)badLoc);
                }
                catch (IOException ioe) {
                    errors.add(NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_UnexpectedIOE", (Object)ioe.getMessage()));
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
                finally {
                    repository.endTrans(rollbackFlag);
                }
            }
            if (generateWsRefInjection && success && javaClass != null) {
                DataObject dObj;
                if (wsdlUrl.startsWith("file:") && (dObj = (DataObject)sourceNode.getCookie(DataObject.class)) != null) {
                    wsdlUrl = JaxWsCodeGenerator.findWsdlLocation(client, dObj.getPrimaryFile());
                }
                JaxWsCodeGenerator.generateServiceRefInjection(javaClass, serviceFieldName, serviceJavaName, wsdlUrl);
            }
        }
        if (errors.size() > 0) {
            StringBuffer buf = new StringBuffer(errors.size() * 100);
            buf.append(NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedWebServiceInvocationCreation"));
            buf.append("\n");
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().toString());
                buf.append("\n");
            }
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)buf.toString(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
        if (success) {
            Node clientNode = operationNode.getParentNode().getParentNode().getParentNode();
            FileObject srcRoot = (FileObject)clientNode.getLookup().lookup(FileObject.class);
            Project clientProject = FileOwnerQuery.getOwner((FileObject)srcRoot);
            DataObject dObj = (DataObject)sourceNode.getCookie(DataObject.class);
            if (dObj != null) {
                JaxWsUtils.addProjectReference(clientProject, FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile()));
            }
        }
    }

    private static String resolveInitValue(String type, FileObject targetFile) {
        JavaClass jc;
        if ("int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type)) {
            return "0;";
        }
        if ("boolean".equals(type)) {
            return "false;";
        }
        if ("float".equals(type) || "double".equals(type)) {
            return "0.0;";
        }
        if ("java.lang.String".equals(type)) {
            return "\"\";";
        }
        if (type.endsWith("CallbackHandler")) {
            return "new " + type + "();";
        }
        if (type.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + type + "() {";
        }
        if (!(targetFile == null || JaxWsCodeGenerator.isEnum(type) || (jc = JMIUtils.findClass((String)type, (FileObject)targetFile)) == null || !JaxWsCodeGenerator.hasDefaultConstructor(jc) && JaxWsCodeGenerator.hasExplicitConstructor(jc))) {
            return "new " + type + "();";
        }
        return "null;";
    }

    private static boolean isEnum(String typeName) {
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type != null) {
            return type instanceof JavaEnum;
        }
        return false;
    }

    private static boolean hasExplicitConstructor(JavaClass jc) {
        List members = jc.getContents();
        for (ClassMember member : members) {
            if (!(member instanceof Constructor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDefaultConstructor(JavaClass jc) {
        return jc.getConstructor(Collections.emptyList(), false) != null;
    }

    private static String resolveResponseType(String argumentType) {
        int start = argumentType.indexOf("<");
        int end = argumentType.indexOf(">");
        if (start > 0 && end > 0 && start < end) {
            return argumentType.substring(start + 1, end);
        }
        return "javax.xml.ws.Response";
    }

    private static String pureJavaName(String javaNameWithPackage) {
        int index = javaNameWithPackage.lastIndexOf(".");
        return index >= 0 ? javaNameWithPackage.substring(index + 1) : javaNameWithPackage;
    }

    public static void insertMethod(final Document document, final int pos, OperationNode operationNode) {
        String argumentDeclarationPart;
        String argumentInitializationPart;
        String returnTypeName;
        String serviceJavaName;
        String portGetterMethod;
        String portJavaName;
        String operationJavaName;
        String wsdlUrl;
        Client client;
        WsdlOperation operation;
        String serviceFieldName;
        boolean inJsp = "text/x-jsp".equals(document.getProperty("mimeType"));
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        try {
            serviceFieldName = "service";
            Node portNode = operationNode.getParentNode();
            Node serviceNode = portNode.getParentNode();
            Node wsdlNode = serviceNode.getParentNode();
            operation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
            WsdlPort port = (WsdlPort)portNode.getLookup().lookup(WsdlPort.class);
            WsdlService service = (WsdlService)serviceNode.getLookup().lookup(WsdlService.class);
            client = (Client)wsdlNode.getLookup().lookup(Client.class);
            wsdlUrl = client.getWsdlUrl();
            operationJavaName = operation.getJavaName();
            portJavaName = port.getJavaName();
            portGetterMethod = port.getPortGetter();
            serviceJavaName = service.getJavaName();
            List arguments = operation.getParameters();
            returnTypeName = operation.getReturnTypeName();
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            for (int i = 0; i < arguments.size(); ++i) {
                String argumentTypeName = ((WsdlParameter)arguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = JaxWsCodeGenerator.resolveResponseType(argumentTypeName);
                    if (inJsp) {
                        argumentTypeName = JaxWsCodeGenerator.pureJavaName(portJavaName) + "CallbackHandler";
                    }
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = ((WsdlParameter)arguments.get(i)).getName();
                if (inJsp && IMPLICIT_JSP_OBJECTS.contains(argumentName)) {
                    argumentName = argumentName + "_1";
                }
                String argumentDeclaration = argumentTypeName + " " + argumentName;
                argumentBuffer1.append("\t" + argumentTypeName + " " + argumentName + " = " + JaxWsCodeGenerator.resolveInitValue(argumentTypeName, NbEditorUtilities.getFileObject((Document)document)) + "\n");
                argumentBuffer2.append(i > 0 ? ", " + argumentName : argumentName);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        if (inJsp) {
            String invocationBody = "";
            Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart};
            switch (operation.getOperationType()) {
                case 0: {
                    if ("void".equals(returnTypeName)) {
                        invocationBody = MessageFormat.format(JSP_STATIC_STUB_VOID, args);
                        break;
                    }
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB, args);
                    break;
                }
                case 1: {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_POLLING, args);
                    break;
                }
                case 2: {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_CALLBACK, args);
                }
            }
            try {
                if (2 == operation.getOperationType()) {
                    Object[] args1 = new Object[]{callbackHandlerName, responseType};
                    final String methodBody = MessageFormat.format(JSP_CALLBACK_HANDLER, args1);
                    final String invocationPart = invocationBody;
                    NbDocument.runAtomic((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                        public void run() {
                            try {
                                document.insertString(document.getLength(), methodBody, null);
                                document.insertString(pos, invocationPart, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    document.insertString(pos, invocationBody, null);
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            return;
        }
        boolean generateWsRefInjection = false;
        boolean insertServiceDef = true;
        String printerName = "System.out";
        FileObject targetFo = NbEditorUtilities.getFileObject((Document)document);
        try {
            JavaClass javaClass = JaxWsCodeGenerator.getJavaClass(targetFo);
            if (javaClass != null) {
                generateWsRefInjection = InjectionTargetQuery.isInjectionTarget((JavaClass)javaClass);
                insertServiceDef = !generateWsRefInjection;
                JavaClass superClass = javaClass.getSuperClass();
                if ("javax.servlet.http.HttpServlet".equals(superClass.getName())) {
                    printerName = "out";
                    argumentInitializationPart = JaxWsCodeGenerator.fixNamesInInitializationPart(argumentInitializationPart);
                    argumentDeclarationPart = JaxWsCodeGenerator.fixNamesInDeclarationPart(argumentDeclarationPart);
                }
                if (generateWsRefInjection) {
                    HashSet<String> serviceFieldNames = new HashSet<String>();
                    List contents = javaClass.getContents();
                    boolean injectionExists = false;
                    for (int i = 0; i < contents.size(); ++i) {
                        Object obj = contents.get(i);
                        if (!(obj instanceof Field)) continue;
                        String fieldTypeName = ((Field)obj).getType().getName();
                        if (serviceJavaName.equals(fieldTypeName)) {
                            serviceFieldName = ((Field)obj).getName();
                            generateWsRefInjection = false;
                            injectionExists = true;
                            break;
                        }
                        serviceFieldNames.add(((Field)obj).getName());
                    }
                    if (!injectionExists) {
                        serviceFieldName = JaxWsCodeGenerator.findProperServiceFieldName(serviceFieldNames);
                    }
                }
            }
            IndentEngine eng = IndentEngine.find((Document)document);
            StringWriter textWriter = new StringWriter();
            Writer indentWriter = eng.createWriter(document, pos, (Writer)textWriter);
            String invocationBody = JaxWsCodeGenerator.getJavaInvocationBody(operation, insertServiceDef, serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart, serviceFieldName, printerName, responseType);
            indentWriter.write(invocationBody);
            indentWriter.close();
            String textToInsert = textWriter.toString();
            try {
                document.insertString(pos, textToInsert, null);
            }
            catch (BadLocationException badLoc) {
                document.insertString(pos + 1, textToInsert, null);
            }
            if (generateWsRefInjection && javaClass != null) {
                if (wsdlUrl.startsWith("file:") && targetFo != null) {
                    wsdlUrl = JaxWsCodeGenerator.findWsdlLocation(client, targetFo);
                }
                JaxWsCodeGenerator.generateServiceRefInjection(javaClass, serviceFieldName, serviceJavaName, wsdlUrl);
            }
        }
        catch (BadLocationException badLoc) {
            ErrorManager.getDefault().notify(1, (Throwable)badLoc);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateServiceRefInjection(JavaClass javaClass, String fieldName, String fieldType, String wsdlUrl) {
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            Field newField = JMIUtils.createField((JavaClass)javaClass, (String)fieldName, (String)fieldType);
            if (InjectionTargetQuery.isStaticReferenceRequired((JavaClass)javaClass)) {
                newField.setModifiers(10);
            } else {
                newField.setModifiers(2);
            }
            ArrayList<AttributeValue> attrValues = new ArrayList<AttributeValue>();
            attrValues.add(JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"wsdlLocation", (String)wsdlUrl));
            newField.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.xml.ws.WebServiceRef", attrValues));
            javaClass.getContents().add(0, newField);
            rollback = false;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    private static boolean inSessionBean(JavaClass javaClass) {
        List annotations = javaClass.getAnnotations();
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            String annotation = ((Annotation)it.next()).getType().getName();
            if (!"javax.ejb.Stateless".equals(annotation) && !"javax.ejb.Stateful".equals(annotation)) continue;
            return true;
        }
        return false;
    }

    private static String findProperServiceFieldName(Set serviceFieldNames) {
        String name = "service";
        int i = 0;
        while (serviceFieldNames.contains(name)) {
            name = "service_" + String.valueOf(++i);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaClass getJavaClass(FileObject fo) {
        JavaModel.getJavaRepository().beginTrans(false);
        JavaClass jc = null;
        try {
            Resource res = JavaModel.getResource((FileObject)fo);
            if (res != null) {
                JavaModel.setClassPath((Resource)res);
                List classes = res.getClassifiers();
                if (classes.size() == 1) {
                    jc = (JavaClass)classes.get(0);
                }
            }
            JavaClass javaClass = jc;
            return javaClass;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private static String getJavaInvocationBody(WsdlOperation operation, boolean insertServiceDef, String serviceJavaName, String portJavaName, String portGetterMethod, String argumentInitializationPart, String returnTypeName, String operationJavaName, String argumentDeclarationPart, String serviceFieldName, String printerName, String responseType) {
        String invocationBody = "";
        Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart, serviceFieldName, printerName};
        switch (operation.getOperationType()) {
            case 0: {
                if ("void".equals(returnTypeName)) {
                    String body = JAVA_TRY + (insertServiceDef ? JAVA_SERVICE_DEF : "") + JAVA_PORT_DEF + JAVA_VOID + JAVA_CATCH;
                    invocationBody = MessageFormat.format(body, args);
                    break;
                }
                String body = JAVA_TRY + (insertServiceDef ? JAVA_SERVICE_DEF : "") + JAVA_PORT_DEF + JAVA_RESULT + JAVA_OUT + JAVA_CATCH;
                invocationBody = MessageFormat.format(body, args);
                break;
            }
            case 1: {
                invocationBody = MessageFormat.format(JAVA_STATIC_STUB_ASYNC_POLLING, args);
                break;
            }
            case 2: {
                args[7] = responseType;
                invocationBody = MessageFormat.format(JAVA_STATIC_STUB_ASYNC_CALLBACK, args);
            }
        }
        return invocationBody;
    }

    private static String fixNamesInDeclarationPart(String argumentDeclarationPart) {
        StringTokenizer tok = new StringTokenizer(argumentDeclarationPart, " ,");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            String newName = null;
            newName = "request".equals(token) ? "request_1" : ("response".equals(token) ? "response_1" : ("out".equals(token) ? "out_1" : token));
            buf.append(i > 0 ? ", " + newName : newName);
            ++i;
        }
        return buf.toString();
    }

    private static String fixNamesInInitializationPart(String argumentInitializationPart) {
        return argumentInitializationPart.replaceFirst(" request ", " request_1 ").replaceFirst(" response ", " response_1 ").replaceFirst(" out ", " out_1 ");
    }

    private static String findPrinter(Method m) {
        List childrens = m.getChildren();
        boolean foundPrinter = false;
        for (int i = 0; i < childrens.size(); ++i) {
            Parameter param;
            Object o = childrens.get(i);
            if (o instanceof Parameter && "java.io.PrintWriter".equals((param = (Parameter)o).getType().getName())) {
                return param.getName();
            }
            if (!(o instanceof StatementBlock)) continue;
            List statements = ((StatementBlock)o).getStatements();
            for (Statement st : statements) {
                if (!(st instanceof LocalVarDeclaration)) continue;
                List variables = ((LocalVarDeclaration)st).getVariables();
                for (Variable var : variables) {
                    if (!"java.io.PrintWriter".equals(var.getType().getName())) continue;
                    return var.getName();
                }
            }
        }
        return null;
    }

    private static String findWsdlLocation(Client client, FileObject targetFo) {
        Project targetProject = FileOwnerQuery.getOwner((FileObject)targetFo);
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)targetProject.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null && J2eeModule.WAR.equals(moduleProvider.getJ2eeModule().getModuleType())) {
            return "WEB-INF/wsdl/client/" + client.getName() + "/" + client.getLocalWsdlFile();
        }
        return "META-INF/wsdl/client/" + client.getName() + "/" + client.getLocalWsdlFile();
    }
}

