/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.MethodParamsTipPaintComponent;
import org.netbeans.modules.editor.java.NbJMICompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMICompletionQuery;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class JavaCompletionProvider
implements CompletionProvider {
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaCompletionProvider;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        JavaSyntaxSupport sup = (JavaSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)component).get(JavaSyntaxSupport.class);
        if (".".equals(typedText) && !sup.isCompletionDisabled(component.getCaret().getDot())) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(component.getCaret().getDot()), component);
        }
        if (queryType == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        if (queryType == 4) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(), component);
        }
        return null;
    }

    static class ToolTipQuery
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private JToolTip queryToolTip;
        private Position queryMethodParamsStartPos = null;
        private boolean otherMethodContext;

        ToolTipQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Position oldPos = this.queryMethodParamsStartPos;
            this.queryMethodParamsStartPos = null;
            NbJavaJMICompletionQuery query = new NbJavaJMICompletionQuery(true);
            BaseDocument bdoc = (BaseDocument)doc;
            NbJavaJMICompletionQuery.JavaResult res = (NbJavaJMICompletionQuery.JavaResult)query.tipQuery(this.component, caretOffset, bdoc.getSyntaxSupport(), false);
            if (res != null) {
                this.queryCaretOffset = caretOffset;
                ArrayList<List> list = new ArrayList<List>();
                int idx = -1;
                boolean checked = false;
                Iterator it = res.getData().iterator();
                while (it.hasNext()) {
                    List parms;
                    Object o = it.next();
                    if (!(o instanceof NbJMIResultItem.CallableFeatureResultItem)) continue;
                    NbJMIResultItem.CallableFeatureResultItem item = (NbJMIResultItem.CallableFeatureResultItem)o;
                    if (!checked) {
                        JCExpression exp = item.substituteExp;
                        if (exp.getTokenCount() > 0) {
                            try {
                                this.queryMethodParamsStartPos = bdoc.createPosition(exp.getTokenOffset(0));
                            }
                            catch (BadLocationException ble) {
                                // empty catch block
                            }
                        }
                        checked = true;
                    }
                    if ((parms = item.createParamsList()).size() > 0) {
                        idx = item.getCurrentParamIndex();
                    } else {
                        parms.add(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JavaCompletionProvider == null ? JavaCompletionProvider.class$("org.netbeans.modules.editor.java.JavaCompletionProvider") : class$org$netbeans$modules$editor$java$JavaCompletionProvider), (String)"JCP-no-parameters"));
                    }
                    list.add(parms);
                }
                this.queryAnchorOffset = res.getSubstituteOffset() + 1;
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                this.queryToolTip = new MethodParamsTipPaintComponent(list, idx);
                resultSet.setToolTip(this.queryToolTip);
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            String text = null;
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            try {
                text = caretOffset - this.queryCaretOffset > 0 ? doc.getText(this.queryCaretOffset, caretOffset - this.queryCaretOffset) : (caretOffset - this.queryCaretOffset < 0 ? doc.getText(caretOffset, this.queryCaretOffset - caretOffset) : "");
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (text == null) {
                return false;
            }
            boolean filter = true;
            int balance = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case ',': {
                        filter = false;
                        break;
                    }
                    case '(': {
                        ++balance;
                        filter = false;
                        break;
                    }
                    case ')': {
                        --balance;
                        filter = false;
                    }
                }
                if (balance >= 0) continue;
                this.otherMethodContext = true;
            }
            if (this.otherMethodContext && balance < 0) {
                this.otherMethodContext = false;
            }
            if (this.queryMethodParamsStartPos == null || caretOffset <= this.queryMethodParamsStartPos.getOffset()) {
                filter = false;
            }
            return this.otherMethodContext || filter;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (!this.otherMethodContext) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                resultSet.setToolTip(this.queryToolTip);
            }
            resultSet.finish();
        }
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        private Object item;
        private JTextComponent component;

        DocQuery(Object item) {
            this.item = item;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.item == null) {
                this.item = JMIUtils.findItemAtCaretPos(this.component);
            }
            if (this.item != null) {
                resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.getAssociatedObject(this.item), ExtUtilities.getExtEditorUI((JTextComponent)this.component)));
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        private Object getAssociatedObject(Object item) {
            Object ret = item;
            if (item instanceof NbJMIResultItem) {
                ret = ((NbJMIResultItem)item).getAssociatedObject();
            }
            if (ret instanceof Feature) {
                ret = JMIUtils.getDefintion((Feature)ret);
            }
            if (ret instanceof ClassDefinition) {
                ret = JMIUtils.getSourceElementIfExists((ClassDefinition)ret);
            }
            return ret;
        }

        private class DocItem
        implements CompletionDocumentation {
            private String text;
            private MyJavaDoc doc;
            private Action goToSource = null;
            private ExtEditorUI ui;
            private URL url;

            public DocItem(final Object item, ExtEditorUI ui) {
                Resource res;
                this.ui = ui;
                this.doc = new MyJavaDoc(ui);
                this.doc.setItem(item);
                this.url = this.getURL(item);
                Resource resource = res = item instanceof Element && ((Element)item).isValid() ? ((Element)item).getResource() : null;
                if (res != null && res.getName().endsWith(".java")) {
                    this.goToSource = new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            JMIUtils.openElement((Element)item);
                            if (e != null) {
                                Completion.get().hideDocumentation();
                            }
                        }
                    };
                }
            }

            public CompletionDocumentation resolveLink(String link) {
                Object item = this.doc.parseLink(link, (ClassDefinition)((JavaClass)null));
                return item != null ? new DocItem(item, this.ui) : null;
            }

            public String getText() {
                return this.text;
            }

            public URL getURL() {
                return this.url;
            }

            private URL getURL(Object item) {
                return this.doc.getURL(item);
            }

            public Action getGotoSourceAction() {
                return this.goToSource;
            }

            private class MyJavaDoc
            extends NbJMICompletionJavaDoc {
                private MyJavaDoc(ExtEditorUI ui) {
                    super(ui);
                }

                private void setItem(Object item) {
                    new MyJavaDocParser(item).run();
                }

                private URL getURL(Object item) {
                    URL[] urls = this.getJMISyntaxSupport().getJavaDocURLs(item);
                    return urls == null || urls.length < 1 ? null : urls[0];
                }

                private class MyJavaDocParser
                extends NbJMICompletionJavaDoc.JMIParsingThread {
                    private MyJavaDocParser(Object content) {
                        super(MyJavaDoc.this, content);
                    }

                    protected void showJavaDoc(String preparedText) {
                        DocItem.this.text = preparedText;
                    }
                }
            }
        }
    }

    static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private NbJavaJMICompletionQuery.JavaResult queryResult;
        private int creationCaretOffset;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            if (caretOffset >= this.creationCaretOffset) {
                try {
                    if (this.isJavaIdentifierPart(doc.getText(this.creationCaretOffset, caretOffset - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            NbJavaJMICompletionQuery query;
            NbJavaJMICompletionQuery.JavaResult res;
            if (JavaMetamodel.getManager().isScanInProgress()) {
                resultSet.setWaitText(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JavaCompletionProvider == null ? (class$org$netbeans$modules$editor$java$JavaCompletionProvider = JavaCompletionProvider.class$("org.netbeans.modules.editor.java.JavaCompletionProvider")) : class$org$netbeans$modules$editor$java$JavaCompletionProvider), (String)"scanning-in-progress"));
            }
            if ((res = (NbJavaJMICompletionQuery.JavaResult)(query = new NbJavaJMICompletionQuery(true)).query(this.component, caretOffset, Utilities.getSyntaxSupport((JTextComponent)this.component))) != null) {
                this.queryCaretOffset = caretOffset;
                this.queryAnchorOffset = res.getSubstituteOffset();
                resultSet.setTitle(res.getTitle());
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                resultSet.addAllItems((Collection)res.getData());
                this.queryResult = res;
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            this.filterPrefix = null;
            if (caretOffset >= this.queryCaretOffset && this.queryAnchorOffset > -1) {
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                resultSet.setTitle(this.getFilteredTitle(this.queryResult.getTitle(), this.filterPrefix));
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                resultSet.addAllItems(this.getFilteredData(this.queryResult.getData(), this.filterPrefix));
            }
            resultSet.finish();
        }

        private boolean isJavaIdentifierPart(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection data, String prefix) {
            ArrayList<CompletionQuery.ResultItem> ret = new ArrayList<CompletionQuery.ResultItem>();
            boolean camelCase = prefix.length() > 1 && prefix.equals(prefix.toUpperCase());
            Iterator it = data.iterator();
            while (it.hasNext()) {
                CompletionQuery.ResultItem itm = (CompletionQuery.ResultItem)it.next();
                if (!JMIUtils.startsWith(itm.getItemText(), prefix) && (!camelCase || !(itm instanceof NbJMIResultItem.ClassResultItem) || !JMIUtils.matchesCamelCase(itm.getItemText(), prefix))) continue;
                ret.add(itm);
            }
            return ret;
        }

        private String getFilteredTitle(String title, String prefix) {
            String ret;
            int lastIdx = title.lastIndexOf(46);
            String string = ret = lastIdx == -1 ? prefix : title.substring(0, lastIdx + 1) + prefix;
            if (title.endsWith("*")) {
                ret = ret + "*";
            }
            return ret;
        }
    }
}

