/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IEEE754FloatingPointEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class FloatEncodingAlgorithm
extends IEEE754FloatingPointEncodingAlgorithm {
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 4;
    }

    public final int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 4 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfFloat", new Object[]{new Integer(4)}));
        }
        return octetLength / 4;
    }

    public final void encodeToBytesFromFloatArray(float[] fdata, int fstart, int flength, byte[] b, int start) {
        int fend = fstart + flength;
        int i = fstart;
        while (i < fend) {
            int bits = Float.floatToIntBits(fdata[i]);
            b[start++] = (byte)(bits >>> 24 & 0xFF);
            b[start++] = (byte)(bits >>> 16 & 0xFF);
            b[start++] = (byte)(bits >>> 8 & 0xFF);
            b[start++] = (byte)(bits & 0xFF);
            ++i;
        }
    }

    public final void decodeFromBytesToFloatArray(float[] data, int fstart, byte[] b, int start, int length) {
        int size = length / 4;
        int i = 0;
        while (i < size) {
            int bits = (b[start++] & 0xFF) << 24 | (b[start++] & 0xFF) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF;
            data[fstart++] = Float.intBitsToFloat(bits);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final float[] decodeFromInputStreamToFloatArray(InputStream s) throws IOException {
        floatList = new ArrayList<Float>();
        b = new byte[4];
        while (true) {
            block3: {
                if ((n = s.read(b)) == 4) break block3;
                if (n != -1) ** GOTO lbl11
                break;
lbl-1000:
                // 1 sources

                {
                    m = s.read(b, n, 4 - n);
                    if (m == -1) {
                        throw new EOFException();
                    }
                    n += m;
lbl11:
                    // 2 sources

                    ** while (n != 4)
                }
            }
            bits = (b[0] & 255) << 24 | (b[1] & 255) << 16 | (b[2] & 255) << 8 | b[3] & 255;
            floatList.add(new Float(Float.intBitsToFloat(bits)));
        }
        return this.generateArrayFromList(floatList);
    }

    public final void encodeToOutputStreamFromFloatArray(float[] fdata, OutputStream s) throws IOException {
        int i = 0;
        while (i < fdata.length) {
            int bits = Float.floatToIntBits(fdata[i]);
            s.write(bits >>> 24 & 0xFF);
            s.write(bits >>> 16 & 0xFF);
            s.write(bits >>> 8 & 0xFF);
            s.write(bits & 0xFF);
            ++i;
        }
    }

    public final void encodeToBytes(Object array, int astart, int alength, byte[] b, int start) {
        this.encodeToBytesFromFloatArray((float[])array, astart, alength, b, start);
    }

    public final Object decodeFromBytes(byte[] b, int start, int length) throws EncodingAlgorithmException {
        float[] data = new float[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToFloatArray(data, 0, b, start, length);
        return data;
    }

    public final Object convertFromCharacters(char[] ch, int start, int length) {
        final CharBuffer cb = CharBuffer.wrap(ch, start, length);
        final ArrayList floatList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb, new BuiltInEncodingAlgorithm.WordListener(){

            public void word(int start, int end) {
                String fStringValue = cb.subSequence(start, end).toString();
                floatList.add(Float.valueOf(fStringValue));
            }
        });
        return this.generateArrayFromList(floatList);
    }

    public final void convertToCharactersFromFloatArray(float[] fdata, StringBuffer s) {
        int end = fdata.length - 1;
        int i = 0;
        while (i <= end) {
            s.append(Float.toString(fdata[i]));
            if (i != end) {
                s.append(' ');
            }
            ++i;
        }
    }

    public final float[] generateArrayFromList(List array) {
        float[] fdata = new float[array.size()];
        int i = 0;
        while (i < fdata.length) {
            fdata[i] = ((Float)array.get(i)).floatValue();
            ++i;
        }
        return fdata;
    }

    public void encodeToOutputStream(Object data, OutputStream s) throws IOException {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotFloat"));
        }
        float[] fdata = (float[])data;
        this.encodeToOutputStreamFromFloatArray(fdata, s);
    }

    public final Object decodeFromInputStream(InputStream s) throws IOException {
        return this.decodeFromInputStreamToFloatArray(s);
    }

    public final void convertToCharacters(Object data, StringBuffer s) {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotFloat"));
        }
        float[] fdata = (float[])data;
        this.convertToCharactersFromFloatArray(fdata, s);
    }
}

