/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardPanelDS
extends PersistenceUnitWizardPanel {
    private Project project;
    private Provider defaultProvider;
    private ButtonGroup buttonGroup1;
    private JLabel datasourceLabel;
    private JRadioButton ddlCreate;
    private JRadioButton ddlDropCreate;
    private JRadioButton ddlUnkown;
    private JComboBox dsCombo;
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox jtaCheckBox;
    private JLabel persistenceProviderLabel;
    private JComboBox providerCombo;
    private ButtonGroup tableCreationButtonGroup;
    private JLabel unitNameLabel;
    private JTextField unitNameTextField;

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean editName) {
        this(project, changeListener, editName, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean editName, PersistenceUnitWizardPanel.TableGeneration tg) {
        this.initComponents();
        this.setTableGeneration(tg);
        this.project = project;
        this.defaultProvider = ProviderUtil.getContainerManagedProvider(project);
        J2eeModuleProvider j2eeModuleProvider = this.getJ2eeModuleProvider();
        if (ProviderUtil.isValidServerInstanceOrNone(project)) {
            this.connectDatasources(j2eeModuleProvider);
        }
        PersistenceProviderComboboxHelper.connect(j2eeModuleProvider, this.providerCombo);
        String serverId = j2eeModuleProvider != null ? j2eeModuleProvider.getServerID() : null;
        String serverDisplayName = serverId != null ? Deployment.getDefault().getServerDisplayName(serverId) : null;
        this.unitNameTextField.setText(ProjectUtils.getInformation((Project)project).getName() + "PU");
        this.unitNameTextField.setVisible(editName);
        this.unitNameLabel.setVisible(editName);
        this.unitNameTextField.getDocument().addDocumentListener(new ValidationListener());
        this.errorMessage.setForeground(Color.RED);
    }

    private void setTableGeneration(PersistenceUnitWizardPanel.TableGeneration tg) {
        if (PersistenceUnitWizardPanel.TableGeneration.CREATE.equals((Object)tg)) {
            this.ddlCreate.setSelected(true);
        } else if (PersistenceUnitWizardPanel.TableGeneration.DROP_CREATE.equals((Object)tg)) {
            this.ddlDropCreate.setSelected(true);
        } else {
            this.ddlUnkown.setSelected(true);
        }
    }

    private void connectDatasources(J2eeModuleProvider j2eeModuleProvider) {
        DatasourceUIHelper.connect((J2eeModuleProvider)j2eeModuleProvider, (JComboBox)this.dsCombo);
        this.dsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
        ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
    }

    private J2eeModuleProvider getJ2eeModuleProvider() {
        return (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
    }

    private void checkValidity() {
        if (this.isValidPanel()) {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", false, true);
        } else {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", true, false);
        }
    }

    public String getPersistenceUnitName() {
        return this.unitNameTextField.getText();
    }

    public String getDatasource() {
        return ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getText();
    }

    public void setPreselectedDB(String db) {
        boolean hasItem = false;
        for (int i = 0; i < this.dsCombo.getItemCount(); ++i) {
            Datasource ds;
            if (!(this.dsCombo.getItemAt(i) instanceof Datasource) || !(ds = (Datasource)this.dsCombo.getItemAt(i)).getJndiName().equals(db)) continue;
            hasItem = true;
            break;
        }
        this.dsCombo.setSelectedItem(db);
        this.dsCombo.setEnabled(!hasItem);
    }

    public boolean isNonDefaultProviderEnabled() {
        return !(this.providerCombo.getSelectedItem() instanceof DefaultProvider);
    }

    public String getNonDefaultProvider() {
        return ((Provider)this.providerCombo.getSelectedItem()).getProviderClass();
    }

    public boolean isJTA() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    public String getTableGeneration() {
        if (this.ddlCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddlDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    public boolean isValidPanel() {
        if (null == this.defaultProvider || this.isEmptyOrNull(this.getDatasource())) {
            return false;
        }
        return this.isNameValid();
    }

    private boolean isNameValid() {
        return this.isEmptyOrNull(this.getPersistenceUnitName()) ? false : this.isNameUnique();
    }

    public boolean isNameUnique() {
        if (!ProviderUtil.persistenceExists(this.project)) {
            return true;
        }
        Persistence persistence = null;
        PUDataObject pud = ProviderUtil.getPUDataObject(this.project);
        persistence = pud.getPersistence();
        PersistenceUnit[] punits = persistence.getPersistenceUnit();
        for (int i = 0; i < punits.length; ++i) {
            if (!punits[i].getName().equals(this.getPersistenceUnitName())) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyOrNull(String str) {
        return str == null || "".equals(str.trim());
    }

    public Provider getSelectedProvider() {
        return (Provider)this.providerCombo.getSelectedItem();
    }

    public void setErrorMessage(String msg) {
        this.errorMessage.setText(msg);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tableCreationButtonGroup = new ButtonGroup();
        this.unitNameLabel = new JLabel();
        this.unitNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ddlCreate = new JRadioButton();
        this.ddlDropCreate = new JRadioButton();
        this.ddlUnkown = new JRadioButton();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.persistenceProviderLabel = new JLabel();
        this.providerCombo = new JComboBox();
        this.errorMessage = new JLabel();
        this.setName(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Step1"));
        this.unitNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_UnitName").charAt(0));
        this.unitNameLabel.setLabelFor(this.unitNameTextField);
        this.unitNameLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_UnitName"));
        this.unitNameLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_UnitName"));
        this.unitNameTextField.setColumns(40);
        this.unitNameTextField.setText("em");
        this.unitNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_UnitName"));
        this.jLabel1.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_SpecifyPersistenceProvider"));
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_TableGeneration"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_TableGeneration"));
        this.tableCreationButtonGroup.add(this.ddlCreate);
        this.ddlCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_Create_mnem").charAt(0));
        this.ddlCreate.setSelected(true);
        this.ddlCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Create"));
        this.ddlCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddlCreate.setMargin(new Insets(0, 0, 0, 0));
        this.ddlCreate.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_Create"));
        this.tableCreationButtonGroup.add(this.ddlDropCreate);
        this.ddlDropCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_DropCreate_mnem").charAt(0));
        this.ddlDropCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_DropCreate"));
        this.ddlDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddlDropCreate.setMargin(new Insets(0, 0, 0, 0));
        this.ddlDropCreate.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_DropCreate"));
        this.tableCreationButtonGroup.add(this.ddlUnkown);
        this.ddlUnkown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_None_mnem").charAt(0));
        this.ddlUnkown.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_None"));
        this.ddlUnkown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddlUnkown.setMargin(new Insets(0, 0, 0, 0));
        this.ddlUnkown.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_None"));
        this.datasourceLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_DatasourceName").charAt(0));
        this.datasourceLabel.setLabelFor(this.dsCombo);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_ServerDataSource"));
        this.datasourceLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_DatasourceName"));
        this.jtaCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_JTA_mnem").charAt(0));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jtaCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jtaCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_JTA"));
        this.dsCombo.setEditable(true);
        this.persistenceProviderLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_Provider").charAt(0));
        this.persistenceProviderLabel.setLabelFor(this.providerCombo);
        this.persistenceProviderLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("LBL_PersistenceProvider"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_Provider"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_Provider"));
        this.providerCombo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("ACSD_Provider"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.unitNameLabel).add((Component)this.persistenceProviderLabel).add((Component)this.datasourceLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.unitNameTextField, -1, 360, Short.MAX_VALUE).add((Component)this.providerCombo, 0, 360, Short.MAX_VALUE).add((Component)this.dsCombo, 0, 360, Short.MAX_VALUE))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.ddlCreate).addPreferredGap(0).add((Component)this.ddlDropCreate).addPreferredGap(0).add((Component)this.ddlUnkown)).add(1, (Component)this.jtaCheckBox).add(1, (Component)this.jLabel1).add((Component)this.errorMessage, -1, 514, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.unitNameLabel).add((Component)this.unitNameTextField, -2, 20, -2)).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.persistenceProviderLabel).add((Component)this.providerCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.dsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jtaCheckBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.ddlCreate).add((Component)this.ddlDropCreate).add((Component)this.ddlUnkown).add((Component)this.jLabel2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.errorMessage, -2, 22, -2).addContainerGap()));
    }

    private class ValidationListener
    implements DocumentListener {
        private ValidationListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        public void removeUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        public void changedUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }
    }
}

