/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class PropertyPattern
extends Pattern {
    public static final int READ_WRITE = 1;
    public static final int READ_ONLY = 2;
    public static final int WRITE_ONLY = 4;
    static final String PROPERTY_CHANGE = "firePropertyChange";
    static final String VETOABLE_CHANGE = "fireVetoableChange";
    protected Method getterMethod = null;
    protected Method setterMethod = null;
    protected Field estimatedField = null;
    protected Type type;
    protected String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyPattern(PatternAnalyser patternAnalyser, Method getterMethod, Method setterMethod) throws IntrospectionException, JmiException {
        super(patternAnalyser);
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
        this.type = this.findPropertyType();
        this.name = this.findPropertyName();
    }

    PropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport) throws JmiException, GenerateBeanException {
        return PropertyPattern.create(patternAnalyser, name, type, mode, bound, constrained, withField, withReturn, withSet, withSupport, false, false);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean useSupport, boolean fromField) throws JmiException, GenerateBeanException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        PropertyPattern pp = new PropertyPattern(patternAnalyser);
        pp.name = name;
        pp.type = patternAnalyser.findType(type);
        if ((withField || withSupport) && !fromField) {
            try {
                pp.generateField(true);
            }
            catch (GenerateBeanException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String supportName = null;
        String vetoSupportName = null;
        if (withSupport) {
            boolean boundSupport = bound;
            boolean constrainedSupport = constrained;
            if (!useSupport) {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(pp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(pp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            } else {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(pp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(pp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            }
            if (boundSupport) {
                supportName = BeanPatternGenerator.supportField(pp.getDeclaringClass());
            }
            if (constrainedSupport) {
                vetoSupportName = BeanPatternGenerator.vetoSupportField(pp.getDeclaringClass());
            }
            if (boundSupport) {
                BeanPatternGenerator.supportListenerMethods(pp.getDeclaringClass(), supportName);
            }
            if (constrainedSupport) {
                BeanPatternGenerator.vetoSupportListenerMethods(pp.getDeclaringClass(), vetoSupportName);
            }
        }
        if (mode == 1 || mode == 2) {
            pp.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(name, withReturn, !fromField), true);
        }
        if (mode == 1 || mode == 4) {
            pp.generateSetterMethod(BeanPatternGenerator.propertySetterBody(name, pp.getType(), bound, constrained, withSet, withSupport, supportName, vetoSupportName, !fromField), constrained, true);
        }
        return pp;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws IllegalArgumentException, JmiException {
        if (!Utilities.isJavaIdentifier((String)name)) {
            throw new IllegalArgumentException("Invalid event source name");
        }
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            this.setNameImpl(name);
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    private void setNameImpl(String name) throws JmiException {
        String javadocText;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String oldName = this.name;
        this.name = name;
        name = PropertyPattern.capitalizeFirstLetter(name);
        if (this.getterMethod != null) {
            String getterMethodID = (this.getterMethod.getName().startsWith("get") ? "get" : "is") + name;
            this.getterMethod.setName(getterMethodID);
            String oldGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), oldName);
            String newGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), this.getName());
            javadocText = this.getterMethod.getJavadocText();
            if (javadocText != null && oldGetterComment.trim().equals(javadocText.trim())) {
                this.getterMethod.setJavadocText(newGetterComment);
            }
        }
        if (this.setterMethod != null) {
            String setterMethodID = "set" + name;
            this.setterMethod.setName(setterMethodID);
            String oldSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), oldName, oldName);
            String newSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), this.getName(), this.getName());
            javadocText = this.setterMethod.getJavadocText();
            if (javadocText != null && oldSetterComment.trim().equals(javadocText.trim())) {
                this.setterMethod.setJavadocText(newSetterComment);
            }
        }
        if (this.estimatedField != null) {
            String oldFieldComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), oldName);
            String newFieldComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), this.getName());
            String javadocText2 = this.estimatedField.getJavadocText();
            if (javadocText2 != null && oldFieldComment.trim().equals(javadocText2.trim())) {
                this.estimatedField.setJavadocText(newFieldComment);
            }
            int mode = this.getMode();
            Format fmt = SourceNodes.createElementFormat((String)"{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldName"), fmt.format(this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                String oldSetterBody;
                String existingSetterBody;
                String fieldName = Introspector.decapitalize(name);
                if (PropertyActionSettings.getDefault().getPropStyle().equals("_")) {
                    fieldName = "_" + fieldName;
                }
                this.estimatedField.setName(fieldName);
                if ((mode == 1 || mode == 2) && this.getterMethod != null) {
                    String existingGetterBody = this.getterMethod.getBodyText().trim();
                    String oldGetterBody1 = BeanPatternGenerator.propertyGetterBody(oldName, true, true).trim();
                    String oldGetterBody2 = BeanPatternGenerator.propertyGetterBody(oldName, true, false).trim();
                    if (existingGetterBody.equals(oldGetterBody1)) {
                        this.getterMethod.setBodyText(BeanPatternGenerator.propertyGetterBody(fieldName, true, true));
                    } else if (existingGetterBody.equals(oldGetterBody2)) {
                        this.getterMethod.setBodyText(BeanPatternGenerator.propertyGetterBody(fieldName, true, false));
                    }
                }
                if ((mode == 1 || mode == 4) && this.setterMethod != null && (existingSetterBody = this.setterMethod.getBodyText().trim()).equals(oldSetterBody = BeanPatternGenerator.propertySetterBody(oldName, this.type, false, false, true, false, null, null).trim())) {
                    this.setterMethod.setBodyText(BeanPatternGenerator.propertySetterBody(fieldName, this.getType(), false, false, true, false, null, null));
                    if (this.setterMethod != null) {
                        Parameter param = (Parameter)this.setterMethod.getParameters().get(0);
                        param.setName(Introspector.decapitalize(name));
                    }
                }
            }
        }
    }

    public int getMode() {
        if (this.setterMethod != null && this.getterMethod != null) {
            return 1;
        }
        if (this.getterMethod != null && this.setterMethod == null) {
            return 2;
        }
        if (this.setterMethod != null && this.getterMethod == null) {
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) throws GenerateBeanException, JmiException {
        if (this.getMode() == mode) {
            return;
        }
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            switch (mode) {
                case 1: {
                    if (this.getterMethod == null) {
                        this.generateGetterMethod(null, true);
                    }
                    if (this.setterMethod != null) break;
                    this.generateSetterMethod(null, false, true);
                    break;
                }
                case 2: {
                    if (this.getterMethod == null) {
                        this.generateGetterMethod(null, true);
                    }
                    if (this.setterMethod == null) break;
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                    this.deleteSetterMethod();
                    break;
                }
                case 4: {
                    if (this.setterMethod == null) {
                        this.generateSetterMethod(null, false, true);
                    }
                    if (this.getterMethod == null) break;
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                    this.deleteGetterMethod();
                }
            }
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type type) throws JmiException {
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            this.setTypeImpl(type);
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    private void setTypeImpl(Type type) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.type.equals(type)) {
            return;
        }
        if (this.getterMethod != null) {
            if (JMIUtils.isPrimitiveType(this.type, PrimitiveTypeKindEnum.BOOLEAN)) {
                this.getterMethod.setName("get" + PropertyPattern.capitalizeFirstLetter(this.getName()));
            } else if (JMIUtils.isPrimitiveType(type, PrimitiveTypeKindEnum.BOOLEAN)) {
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeToIs"), PropertyPattern.capitalizeFirstLetter(this.getName()));
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    this.getterMethod.setName("is" + PropertyPattern.capitalizeFirstLetter(this.getName()));
                }
            }
            this.getterMethod.setType(type);
        }
        if (this.setterMethod != null) {
            List params = this.setterMethod.getParameters();
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Parameter param = (Parameter)it.next();
                Type oldType = param.getType();
                param.setType(type);
                String body = this.setterMethod.getBodyText();
                if (body == null || body.indexOf(PROPERTY_CHANGE) == -1 && body.indexOf(VETOABLE_CHANGE) == -1) continue;
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) continue;
                String newBody = this.regeneratePropertySupport(this.setterMethod.getBodyText(), null, param.getName(), type, oldType);
                if (newBody != null) {
                    this.setterMethod.setBodyText(newBody);
                }
                if ((newBody = this.regeneratePropertySupport(this.setterMethod.getBodyText(), PROPERTY_CHANGE, param.getName(), type, oldType)) != null) {
                    this.setterMethod.setBodyText(newBody);
                }
                if ((newBody = this.regeneratePropertySupport(this.setterMethod.getBodyText(), VETOABLE_CHANGE, param.getName(), type, oldType)) == null) continue;
                this.setterMethod.setBodyText(newBody);
            }
        }
        this.type = type;
        if (this.estimatedField != null) {
            Format fmt = SourceNodes.createElementFormat((String)"{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldType"), fmt.format(this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                this.estimatedField.setType(type);
            } else {
                this.estimatedField = null;
            }
        }
    }

    protected String regeneratePropertySupport(String methodBody, String changeType, String name, Type type, Type oldType) throws JmiException {
        if (methodBody == null) {
            return null;
        }
        int first = -1;
        boolean post_index = false;
        boolean pre_index = false;
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (oldType instanceof Array) {
            oldType = PropertyPattern.getPrimitiveType((Array)oldType);
        }
        if (changeType != null) {
            first = methodBody.indexOf(changeType);
            if (first == -1) {
                return null;
            }
        } else {
            String oldVarLine = " old" + Pattern.capitalizeFirstLetter(name) + " = " + propertyStyle + name;
            first = methodBody.indexOf(oldType.getName() + oldVarLine + ";");
            if (first == -1) {
                first = methodBody.indexOf(oldType.getName() + oldVarLine + "[index];");
                if (first == -1) {
                    first = methodBody.indexOf(oldType.getName() + "[]" + oldVarLine + ";");
                    if (first == -1) {
                        return null;
                    }
                    pre_index = true;
                } else {
                    post_index = true;
                }
            }
        }
        if (first == -1) {
            return null;
        }
        int last = methodBody.indexOf(59, first);
        if (first >= last) {
            return null;
        }
        StringBuffer newBody = new StringBuffer(100);
        if (changeType != null) {
            newBody.append(changeType + " (\"").append(name).append("\", ");
            if (type instanceof PrimitiveType) {
                newBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                newBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                newBody.append("), ");
                newBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                newBody.append(name).append("))");
            } else {
                newBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                newBody.append(", ").append(name).append(")");
            }
        } else {
            newBody.append(type.getName());
            newBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            newBody.append(" = ").append(propertyStyle).append(name);
            if (post_index) {
                newBody.append("[index]");
            }
        }
        StringBuffer sb = new StringBuffer(methodBody);
        sb.delete(first, last);
        sb.insert(first, newBody);
        return sb.toString();
    }

    private static Type getPrimitiveType(Array atype) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Type type = atype.getType();
        while (type instanceof Array) {
            type = ((Array)type).getType();
        }
        return type;
    }

    public Node.Cookie getCookie(Class cookieType) {
        return super.getCookie(cookieType);
    }

    public Field getEstimatedField() {
        return this.estimatedField;
    }

    void setEstimatedField(Field field) {
        this.estimatedField = field;
    }

    public void destroy() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.estimatedField != null) {
            Format fmt = SourceNodes.createElementFormat((String)"{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_DeleteField"), fmt.format(this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                this.deleteEstimatedField();
            }
        }
        this.deleteGetterMethod();
        this.deleteSetterMethod();
    }

    PropertyPattern(PropertyPattern x, PropertyPattern y) throws JmiException {
        super(y.patternAnalyser);
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Method xr = x.getterMethod;
        Method yr = y.getterMethod;
        this.getterMethod = xr;
        if (yr != null) {
            this.getterMethod = yr;
        }
        if (xr != null && yr != null && xr.getDeclaringClass() == yr.getDeclaringClass() && JMIUtils.isPrimitiveType(xr.getType(), PrimitiveTypeKindEnum.BOOLEAN) && JMIUtils.isPrimitiveType(yr.getType(), PrimitiveTypeKindEnum.BOOLEAN) && xr.getName().indexOf("is") == 0 && yr.getName().indexOf("get") == 0) {
            this.getterMethod = xr;
        }
        this.setterMethod = x.getSetterMethod();
        if (y.getSetterMethod() != null) {
            this.setterMethod = y.getSetterMethod();
        }
        try {
            this.type = this.findPropertyType();
        }
        catch (IntrospectionException ex) {
            throw new InternalError("Mixing invalid PropertyPattrens" + ex);
        }
        this.name = this.findPropertyName();
    }

    Type findPropertyType() throws IntrospectionException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Type resolvedType = null;
        if (this.getterMethod != null) {
            if (!this.getterMethod.getParameters().isEmpty()) {
                throw new IntrospectionException("bad read method arg count");
            }
            resolvedType = this.getterMethod.getType();
            if (JMIUtils.isPrimitiveType(resolvedType, PrimitiveTypeKindEnum.VOID)) {
                throw new IntrospectionException("read method " + this.getterMethod.getName() + " returns void");
            }
        }
        if (this.setterMethod != null) {
            List params = this.setterMethod.getParameters();
            if (params.size() != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            Parameter param = (Parameter)params.get(0);
            if (resolvedType != null && !resolvedType.equals(param.getType())) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            resolvedType = param.getType();
        }
        return resolvedType;
    }

    String findPropertyName() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String methodName = null;
        if (this.getterMethod != null) {
            methodName = this.getterMethod.getName();
        } else if (this.setterMethod != null) {
            methodName = this.setterMethod.getName();
        } else {
            return null;
        }
        return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
    }

    void generateGetterMethod() throws GenerateBeanException, JmiException {
        this.generateGetterMethod(null, false);
    }

    void generateGetterMethod(String body, boolean javadoc) throws GenerateBeanException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newGetter = jmodel.getMethod().createMethod();
        String namePrefix = JMIUtils.isPrimitiveType(this.type, PrimitiveTypeKindEnum.BOOLEAN) ? "is" : "get";
        newGetter.setName(namePrefix + PropertyPattern.capitalizeFirstLetter(this.getName()));
        newGetter.setType(this.type);
        newGetter.setModifiers(1);
        if (declaringClass.isInterface()) {
            newGetter.setBody(null);
        } else if (body != null) {
            newGetter.setBodyText(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), this.getName());
            newGetter.setJavadocText(comment);
        }
        if (declaringClass == null) {
            throw new GenerateBeanException();
        }
        declaringClass.getFeatures().add(newGetter);
        this.getterMethod = newGetter;
    }

    void generateSetterMethod() throws GenerateBeanException, JmiException {
        this.generateSetterMethod(null, false, false);
    }

    void generateSetterMethod(String body, boolean constrained, boolean javadoc) throws GenerateBeanException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newSetter = jmodel.getMethod().createMethod();
        newSetter.setName("set" + PropertyPattern.capitalizeFirstLetter(this.getName()));
        newSetter.setType(this.patternAnalyser.findType("void"));
        newSetter.setModifiers(1);
        Parameter param = jmodel.getParameter().createParameter();
        param.setName(this.name);
        param.setType(this.type);
        newSetter.getParameters().add(param);
        if (constrained) {
            MultipartId exception = jmodel.getMultipartId().createMultipartId("java.beans.PropertyVetoException", null, null);
            newSetter.getExceptionNames().add(exception);
        }
        if (declaringClass.isInterface()) {
            newSetter.setBody(null);
        } else if (body != null) {
            newSetter.setBodyText(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), this.getName(), this.name);
            if (constrained) {
                comment = comment + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            newSetter.setJavadocText(comment);
        }
        if (declaringClass == null) {
            throw new GenerateBeanException();
        }
        declaringClass.getFeatures().add(newSetter);
        this.setterMethod = newSetter;
    }

    void generateField() throws GenerateBeanException, JmiException {
        this.generateField(false);
    }

    void generateField(boolean javadoc) throws GenerateBeanException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Field newField = jmodel.getField().createField();
        String name = this.getName();
        if (PropertyActionSettings.getDefault().getPropStyle().equals("_")) {
            name = "_" + name;
        }
        name = Introspector.decapitalize(name);
        newField.setName(name);
        newField.setType(this.type);
        newField.setModifiers(2);
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), name);
            newField.setJavadocText(comment);
        }
        if (declaringClass == null) {
            throw new IllegalStateException("Missing declaring class");
        }
        String newFieldName = newField.getName();
        Field f = declaringClass.getField(newFieldName, false);
        if (f == null) {
            declaringClass.getFeatures().add(newField);
            this.estimatedField = newField;
        } else {
            if ((f.getModifiers() & 8) != 0) {
                throw new GenerateBeanException();
            }
            if (!f.getType().equals(newField.getType())) {
                throw new GenerateBeanException();
            }
        }
    }

    void deleteEstimatedField() throws JmiException {
        if (this.estimatedField == null) {
            return;
        }
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        declaringClass.getFeatures().remove(this.estimatedField);
        this.estimatedField = null;
    }

    void deleteGetterMethod() throws JmiException {
        if (this.getterMethod == null) {
            return;
        }
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        declaringClass.getFeatures().remove(this.getterMethod);
        this.getterMethod = null;
    }

    void deleteSetterMethod() throws JmiException {
        if (this.setterMethod == null) {
            return;
        }
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        declaringClass.getFeatures().remove(this.setterMethod);
        this.setterMethod = null;
    }

    void copyProperties(PropertyPattern src) throws JmiException {
        boolean changed;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        boolean bl = !src.getType().equals(this.getType()) || !src.getName().equals(this.getName()) || src.getMode() != this.getMode() || !(src.getEstimatedField() != null ? src.getEstimatedField().equals(this.estimatedField) : this.estimatedField == null) ? true : (changed = false);
        if (src.getGetterMethod() != this.getterMethod) {
            this.getterMethod = src.getGetterMethod();
        }
        if (src.getSetterMethod() != this.setterMethod) {
            this.setterMethod = src.getSetterMethod();
        }
        if (src.getEstimatedField() != this.estimatedField) {
            this.estimatedField = src.getEstimatedField();
        }
        if (changed) {
            try {
                this.type = this.findPropertyType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.name = this.findPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    static {
        $assertionsDisabled = !PropertyPattern.class.desiredAssertionStatus();
    }
}

