/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class GlobFileBuiltQuery
implements FileBuiltQueryImplementation {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery");
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final String[] fromPrefixes;
    private final String[] fromSuffixes;
    private final String[] toPrefixes;
    private final String[] toSuffixes;
    private static final Object NONE = "NONE";
    private final Map statuses = new WeakHashMap();
    static /* synthetic */ Class class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery;

    public GlobFileBuiltQuery(AntProjectHelper helper, PropertyEvaluator eval, String[] from, String[] to) throws IllegalArgumentException {
        this.helper = helper;
        this.eval = eval;
        int l = from.length;
        if (to.length != l) {
            throw new IllegalArgumentException("Non-matching lengths");
        }
        this.fromPrefixes = new String[l];
        this.fromSuffixes = new String[l];
        this.toPrefixes = new String[l];
        this.toSuffixes = new String[l];
        for (int i = 0; i < l; ++i) {
            int idx = from[i].indexOf(42);
            if (idx == -1 || idx != from[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + from[i]);
            }
            this.fromPrefixes[i] = from[i].substring(0, idx);
            this.fromSuffixes[i] = from[i].substring(idx + 1);
            idx = to[i].indexOf(42);
            if (idx == -1 || idx != to[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + to[i]);
            }
            this.toPrefixes[i] = to[i].substring(0, idx);
            this.toSuffixes[i] = to[i].substring(idx + 1);
        }
    }

    public synchronized FileBuiltQuery.Status getStatus(FileObject file) {
        StatusImpl status;
        Object o = this.statuses.get(file);
        if (o == NONE) {
            return null;
        }
        Reference r = (Reference)o;
        StatusImpl statusImpl = status = r != null ? (StatusImpl)r.get() : null;
        if (status == null) {
            status = this.createStatus(file);
            if (status != null) {
                this.statuses.put(file, new WeakReference<StatusImpl>(status));
            } else {
                this.statuses.put(file, NONE);
            }
        }
        return status;
    }

    private File findTarget(FileObject file) {
        File sourceF = FileUtil.toFile((FileObject)file);
        if (sourceF == null) {
            if (err.isLoggable(1)) {
                err.log("Not a disk file: " + file);
            }
            return null;
        }
        String source = sourceF.getAbsolutePath();
        for (int i = 0; i < this.fromPrefixes.length; ++i) {
            String remainder;
            String prefixEval = this.eval.evaluate(this.fromPrefixes[i]);
            if (prefixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromPrefixes[i] + " evaluates to null");
                continue;
            }
            String suffixEval = this.eval.evaluate(this.fromSuffixes[i]);
            if (suffixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromSuffixes[i] + " evaluates to null");
                continue;
            }
            boolean endsWithSlash = prefixEval.endsWith("/");
            String prefixF = this.helper.resolveFile(prefixEval).getAbsolutePath();
            if (endsWithSlash && !prefixF.endsWith(File.separator)) {
                prefixF = prefixF + File.separatorChar;
            }
            if (!source.startsWith(prefixF) || !(remainder = source.substring(prefixF.length())).endsWith(suffixEval.replace('/', File.separatorChar))) continue;
            String particular = remainder.substring(0, remainder.length() - suffixEval.length());
            String toPrefixEval = this.eval.evaluate(this.toPrefixes[i]);
            if (toPrefixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toPrefixes[i] + " evaluates to null");
                continue;
            }
            String toSuffixEval = this.eval.evaluate(this.toSuffixes[i]);
            if (toSuffixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toSuffixes[i] + " evaluates to null");
                continue;
            }
            File target = this.helper.resolveFile(toPrefixEval + particular + toSuffixEval);
            if (err.isLoggable(1)) {
                err.log("Found target for " + source + ": " + target);
            }
            return target;
        }
        if (err.isLoggable(1)) {
            err.log("No match for path " + source + " among " + Arrays.asList(this.fromPrefixes) + " " + Arrays.asList(this.fromSuffixes));
        }
        return null;
    }

    private StatusImpl createStatus(FileObject file) {
        File target = this.findTarget(file);
        if (target != null) {
            try {
                DataObject source = DataObject.find((FileObject)file);
                return new StatusImpl(source, file, target);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    FileChangeSupportListener,
    Runnable {
        private final List listeners = new ArrayList();
        private Boolean built = null;
        private final DataObject source;
        private File target;
        static final /* synthetic */ boolean $assertionsDisabled;

        StatusImpl(DataObject source, FileObject sourceFO, File target) {
            this.source = source;
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.source));
            sourceFO.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)sourceFO));
            this.target = target;
            FileChangeSupport.DEFAULT.addListener(this, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuilt() {
            boolean b;
            boolean doFire = false;
            GlobFileBuiltQuery globFileBuiltQuery = GlobFileBuiltQuery.this;
            synchronized (globFileBuiltQuery) {
                b = this.isReallyBuilt();
                if (this.built != null && this.built != b) {
                    doFire = true;
                }
                this.built = b;
                if (err.isLoggable(1)) {
                    err.log("isBuilt: " + b + " from " + this);
                }
            }
            if (doFire) {
                this.fireChange();
            }
            return b;
        }

        private boolean isReallyBuilt() {
            long sourceTime;
            if (!this.source.isValid()) {
                if (err.isLoggable(1)) {
                    err.log("invalid: " + this);
                }
                return false;
            }
            if (this.source.isModified()) {
                if (err.isLoggable(1)) {
                    err.log("modified: " + this);
                }
                return false;
            }
            if (this.target == null) {
                if (err.isLoggable(1)) {
                    err.log("no target matching " + this);
                }
                return false;
            }
            long targetTime = this.target.lastModified();
            if (targetTime >= (sourceTime = this.source.getPrimaryFile().lastModified().getTime())) {
                return true;
            }
            if (err.isLoggable(1)) {
                err.log("out of date (target: " + targetTime + " vs. source: " + sourceTime + "): " + this);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] _listeners;
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].stateChanged(ev);
            }
        }

        private void update() {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            this.isBuilt();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!$assertionsDisabled && !(evt.getSource() instanceof DataObject)) {
                throw new AssertionError();
            }
            if ("modified".equals(evt.getPropertyName())) {
                this.update();
            }
        }

        public void fileChanged(FileEvent fe) {
            this.update();
        }

        public void fileDeleted(FileEvent fe) {
            this.update();
        }

        public void fileRenamed(FileRenameEvent fe) {
            File target2 = GlobFileBuiltQuery.this.findTarget(this.source.getPrimaryFile());
            if (!Utilities.compareObjects((Object)this.target, (Object)target2)) {
                if (this.target != null) {
                    FileChangeSupport.DEFAULT.removeListener(this, this.target);
                }
                if (target2 != null) {
                    FileChangeSupport.DEFAULT.addListener(this, target2);
                }
                this.target = target2;
            }
            this.update();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileCreated(FileChangeSupportEvent event) {
            this.update();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            this.update();
        }

        public void fileModified(FileChangeSupportEvent event) {
            this.update();
        }

        public String toString() {
            return "GFBQ.StatusImpl[" + this.source.getPrimaryFile() + " -> " + this.target + "]";
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery == null ? (class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery = GlobFileBuiltQuery.class$("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery")) : class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery).desiredAssertionStatus();
        }
    }
}

