/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DbURLClassLoader;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class DerbyDatabases {
    private DerbyDatabases() {
    }

    public static boolean isDerbyRegistered() {
        return DerbySupport.getLocation().length() > 0 && DerbySupport.getSystemHome().length() > 0;
    }

    public static File getSystemHome() {
        String systemHome = DerbyOptions.getDefault().getSystemHome();
        if (systemHome.length() >= 0) {
            return new File(systemHome);
        }
        return null;
    }

    public static boolean databaseExists(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        if ("".equals(databaseName)) {
            return false;
        }
        String systemHome = DerbySupport.getSystemHome();
        if (systemHome.length() <= 0) {
            return false;
        }
        File databaseFile = new File(systemHome, databaseName);
        return databaseFile.exists();
    }

    public static String getFirstFreeDatabaseName(String baseDatabaseName) {
        if (baseDatabaseName == null) {
            throw new NullPointerException("The baseDatabaseName parameter cannot be null");
        }
        String systemHome = DerbySupport.getSystemHome();
        if (systemHome.length() <= 0) {
            return baseDatabaseName;
        }
        File databaseFile = new File(systemHome, baseDatabaseName);
        if (!databaseFile.exists()) {
            return baseDatabaseName;
        }
        for (int i = 1; i <= Integer.MAX_VALUE; ++i) {
            String databaseName = baseDatabaseName + String.valueOf(i);
            databaseFile = new File(systemHome, databaseName);
            if (databaseFile.exists()) continue;
            return databaseName;
        }
        return null;
    }

    public static int getFirstIllegalCharacter(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        for (int i = 0; i < databaseName.length(); ++i) {
            char ch = databaseName.charAt(i);
            if (ch == '/') {
                return ch;
            }
            if (ch != File.separatorChar) continue;
            return ch;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseConnection createDatabase(String databaseName, String user, String password) throws DatabaseException, IOException, IllegalStateException {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        DerbyDatabases.ensureSystemHome();
        RegisterDerby.getDefault().ensureStarted();
        Driver driver = DerbyDatabases.loadDerbyNetDriver();
        Properties props = new Properties();
        boolean setupAuthentication = user != null && user.length() >= 0;
        try {
            String url = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + databaseName;
            String urlForCreation = url + ";create=true";
            Connection connection = driver.connect(urlForCreation, props);
            try {
                if (setupAuthentication) {
                    DerbyDatabases.setupDatabaseAuthentication(connection, user, password);
                }
            }
            finally {
                connection.close();
            }
            if (setupAuthentication) {
                try {
                    connection = driver.connect(url + ";shutdown=true", props);
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException sqle) {
            DatabaseException dbe = new DatabaseException(sqle.getMessage());
            dbe.initCause((Throwable)sqle);
            throw dbe;
        }
        return DerbyDatabases.registerDatabase(databaseName, user, setupAuthentication ? user.toUpperCase() : "APP", setupAuthentication ? password : null, setupAuthentication);
    }

    public static DatabaseConnection createSampleDatabase() throws DatabaseException, IOException, IllegalStateException {
        DerbyDatabases.extractSampleDatabase("sample");
        return DerbyDatabases.registerDatabase("sample", "app", "APP", "app", true);
    }

    public static DatabaseConnection createSampleDatabase(String databaseName) throws DatabaseException, IOException {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        DerbyDatabases.extractSampleDatabase(databaseName);
        return DerbyDatabases.registerDatabase(databaseName, "app", "APP", "app", true);
    }

    static void extractSampleDatabase(String databaseName) throws IOException {
        File systemHomeFile = DerbyDatabases.ensureSystemHome();
        File sourceFO = InstalledFileLocator.getDefault().locate("modules/ext/derbysampledb.zip", null, false);
        FileObject systemHomeFO = FileUtil.toFileObject((File)systemHomeFile);
        FileObject sampleFO = systemHomeFO.getFileObject(databaseName);
        if (sampleFO == null) {
            sampleFO = systemHomeFO.createFolder(databaseName);
            Util.extractZip(sourceFO, sampleFO);
        }
    }

    private static File ensureSystemHome() throws IOException {
        String systemHome = DerbySupport.getSystemHome();
        if (systemHome.length() <= 0) {
            throw new IllegalStateException("The derby.system.home directory is not set");
        }
        File systemHomeFile = new File(systemHome);
        if (!systemHomeFile.exists() && !systemHomeFile.mkdirs()) {
            throw new IOException("Could not create the derby.system.home directory");
        }
        return systemHomeFile;
    }

    private static DatabaseConnection registerDatabase(String databaseName, String user, String schema, String password, boolean rememberPassword) throws DatabaseException {
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (drivers.length == 0) {
            throw new IllegalStateException("The Java DB (Network) driver was not found");
        }
        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)drivers[0], (String)("jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + databaseName), (String)user, (String)schema, (String)password, (boolean)rememberPassword);
        ConnectionManager.getDefault().addConnection(dbconn);
        return dbconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupDatabaseAuthentication(Connection conn, String user, String password) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("{call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)}");
        try {
            stmt.setString(1, "derby.connection.requireAuthentication");
            stmt.setString(2, "true");
            stmt.execute();
            stmt.clearParameters();
            stmt.setString(1, "derby.authentication.provider");
            stmt.setString(2, "BUILTIN");
            stmt.execute();
            stmt.clearParameters();
            stmt.setString(1, "derby.user." + user);
            stmt.setString(2, password);
            stmt.execute();
        }
        finally {
            stmt.close();
        }
    }

    private static Driver loadDerbyNetDriver() throws DatabaseException, IllegalStateException {
        Exception exception = null;
        try {
            File derbyClient = Util.getDerbyFile("lib/derbyclient.jar");
            if (derbyClient == null || !derbyClient.exists()) {
                throw new IllegalStateException("The Java DB (Network) driver was not found");
            }
            URL[] driverURLs = new URL[]{derbyClient.toURI().toURL()};
            DbURLClassLoader l = new DbURLClassLoader(driverURLs);
            Class<?> c = Class.forName("org.apache.derby.jdbc.ClientDriver", true, l);
            return (Driver)c.newInstance();
        }
        catch (MalformedURLException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        if (exception != null) {
            DatabaseException dbe = new DatabaseException(exception.getMessage());
            dbe.initCause((Throwable)exception);
            throw dbe;
        }
        return null;
    }
}

