/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.ArrayList;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SearchThreadJdk12;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private ArrayList tasks;
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;

    JavadocSearchEngineImpl() {
    }

    public void search(String[] items, final JavadocSearchEngine.SearchEngineCallback callback) throws NoJavadocException {
        FileObject[] docRoots = JavadocRegistry.getDefault().getDocRoots();
        this.tasks = new ArrayList(docRoots.length);
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            public void addDocIndexItem(DocIndexItem dii) {
                callback.addItem(dii);
            }

            public void indexSearchThreadFinished(IndexSearchThread t) {
                JavadocSearchEngineImpl.this.tasks.remove(t);
                if (JavadocSearchEngineImpl.this.tasks.isEmpty()) {
                    callback.finished();
                }
            }
        };
        if (docRoots.length <= 0) {
            callback.finished();
            throw new NoJavadocException();
        }
        String toFind = items[0];
        for (int i = 0; i < docRoots.length; ++i) {
            JavadocSearchType st = JavadocRegistry.getDefault().findSearchType(docRoots[i]);
            if (st == null) {
                ErrorManager.getDefault().log("NO Search type for " + docRoots[i]);
                continue;
            }
            FileObject indexFo = st.getDocFileObject(docRoots[i]);
            if (indexFo == null) {
                ErrorManager.getDefault().log("NO Index files fot " + docRoots[i]);
                continue;
            }
            IndexSearchThread searchThread = st.getSearchThread(toFind, indexFo, this.diiConsumer);
            this.tasks.add(searchThread);
            searchThread.go();
        }
    }

    public void stop() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            SearchThreadJdk12 searchThread = (SearchThreadJdk12)this.tasks.get(i);
            searchThread.finish();
        }
    }
}

