/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class SubprojectProviderImpl
implements SubprojectProvider {
    private final NbModuleProject project;

    public SubprojectProviderImpl(NbModuleProject project) {
        this.project = project;
    }

    public Set getSubprojects() {
        ModuleList ml;
        HashSet<Project> s = new HashSet<Project>();
        try {
            ml = this.project.getModuleList();
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
            return Collections.EMPTY_SET;
        }
        Element data = this.project.getHelper().getPrimaryConfigurationData(true);
        Element moduleDependencies = Util.findElement(data, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
        List deps = Util.findSubElements(moduleDependencies);
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            Element cnbEl = Util.findElement(dep, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
            String cnb = Util.findText(cnbEl);
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + this.project);
                continue;
            }
            File moduleProjectDirF = module.getSourceLocation();
            if (moduleProjectDirF == null) {
                Util.err.log(16, "Warning - could not find sources for dependent module " + cnb + " for " + this.project);
                continue;
            }
            FileObject moduleProjectDir = FileUtil.toFileObject((File)moduleProjectDirF);
            if (moduleProjectDir == null) {
                Util.err.log(16, "Warning - could not load sources for dependent module " + cnb + " for " + this.project);
                continue;
            }
            try {
                Project moduleProject = ProjectManager.getDefault().findProject(moduleProjectDir);
                if (moduleProject == null) {
                    Util.err.log(16, "Warning - dependent module " + cnb + " for " + this.project + " is not projectized");
                    continue;
                }
                s.add(moduleProject);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
        List cpexts = Util.findSubElements(data);
        it = cpexts.iterator();
        while (it.hasNext()) {
            File jar;
            Project owner;
            Element binorig;
            Element cpext = (Element)it.next();
            if (!cpext.getTagName().equals("class-path-extension") || (binorig = Util.findElement(cpext, "binary-origin", "http://www.netbeans.org/ns/nb-module-project/2")) == null) continue;
            String text = Util.findText(binorig);
            String eval = this.project.evaluator().evaluate(text);
            if (eval == null || (owner = FileOwnerQuery.getOwner((URI)(jar = this.project.getHelper().resolveFile(eval)).toURI())) == null || owner == this.project) continue;
            s.add(owner);
        }
        String eval = this.project.evaluator().getProperty("cp.extra");
        if (eval != null) {
            String[] pieces = PropertyUtils.tokenizePath((String)eval);
            for (int i = 0; i < pieces.length; ++i) {
                File jar = this.project.getHelper().resolveFile(pieces[i]);
                Project owner = FileOwnerQuery.getOwner((URI)jar.toURI());
                if (owner == null) continue;
                s.add(owner);
            }
        }
        return s;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

