/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.text.Collator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;

final class AddModuleFilter {
    private final Set universe;
    private final String dependingModuleCNB;

    public AddModuleFilter(Set universe, String dependingModuleCNB) {
        this.universe = universe;
        this.dependingModuleCNB = dependingModuleCNB;
        Iterator it = universe.iterator();
        while (it.hasNext()) {
            ModuleDependency dep = (ModuleDependency)it.next();
            dep.getFilterTokens(dependingModuleCNB);
        }
    }

    public Set getMatches(String text) {
        String textLC = text.toLowerCase(Locale.ENGLISH);
        Set[] matches = new Set[3];
        for (int i = 0; i < matches.length; ++i) {
            matches[i] = new TreeSet(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
        }
        Iterator it = this.universe.iterator();
        while (it.hasNext()) {
            ModuleDependency dep = (ModuleDependency)it.next();
            int matchLevel = matches.length;
            Set tokens = dep.getFilterTokens(this.dependingModuleCNB);
            Iterator it2 = tokens.iterator();
            while (it2.hasNext()) {
                String token = ((String)it2.next()).toLowerCase(Locale.ENGLISH);
                if (token.equals(textLC) || token.endsWith("." + textLC)) {
                    matchLevel = Math.min(0, matchLevel);
                    continue;
                }
                if (token.indexOf("." + textLC) != -1) {
                    matchLevel = Math.min(1, matchLevel);
                    continue;
                }
                if (token.indexOf(textLC) == -1) continue;
                matchLevel = Math.min(2, matchLevel);
            }
            if (matchLevel >= matches.length) continue;
            matches[matchLevel].add(dep);
        }
        LinkedHashSet result = new LinkedHashSet();
        for (int i = 0; i < matches.length; ++i) {
            result.addAll(matches[i]);
        }
        return result;
    }

    public Set getMatchesFor(String text, ModuleDependency dep) {
        String textLC = text.toLowerCase(Locale.US);
        TreeSet<Object> tokens = new TreeSet<Object>(Collator.getInstance());
        Iterator it = dep.getFilterTokens(this.dependingModuleCNB).iterator();
        while (it.hasNext()) {
            String token = (String)it.next();
            if (token.toLowerCase(Locale.US).indexOf(textLC) == -1) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

