/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCPaintComponent
extends JPanel {
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    protected boolean isSelected;
    private String text;
    protected boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    private static final Color KEYWORD_COLOR = Color.darkGray;
    private static final Color TYPE_COLOR = Color.black;
    private Icon icon;

    public JCPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawType(Graphics g, JCType typ) {
        this.drawType(g, typ, false);
    }

    protected void drawType(Graphics g, JCType typ, boolean strike) {
        Color c = this.getTypeColor(typ.getClazz().getName());
        this.drawString(g, typ.format(false), c, null, strike);
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        Iterator i = JavaCompletion.getPrimitiveClassIterator();
        while (i.hasNext()) {
            this.storeWidth(((JCClass)i.next()).getName());
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    protected Color getTypeColor(String s) {
        return JavaCompletion.isPrimitiveClassName(s) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.text);
        return sb.toString();
    }

    public static class MethodPaintComponent
    extends ConstructorPaintComponent {
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private Color METHOD_COLOR = Color.red.darker().darker();
        private String typeName;
        private Color typeColor;

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            int level = JavaCompletion.getLevel(this.getModifiers());
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getTypeName(), this.getTypeColor(), null, strike);
            this.drawString(g, " ", strike);
            if ((this.getModifiers() & 0x20000000) != 0) {
                this.drawString(g, this.getName(), this.METHOD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.getName(), this.METHOD_COLOR, null, strike);
            }
            this.drawParameterList(g, this.getParamList(), strike);
            this.drawExceptions(g, this.getExceptionList(), strike);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.typeName);
            sb.append(" ");
            sb.append(super.getName());
            sb.append(" (");
            List prmList = this.getParamList();
            Iterator it = prmList.iterator();
            while (it.hasNext()) {
                JCResultItem.ParamStr paramStr = (JCResultItem.ParamStr)it.next();
                sb.append(paramStr.getTypeName());
                sb.append(" ");
                sb.append(paramStr.getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class ConstructorPaintComponent
    extends JCPaintComponent {
        private Color CONSTRUCTOR_COLOR = Color.orange.darker();
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String name;

        public int getMethodModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.name;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setParams(List params) {
            this.params = params;
        }

        public void setExceptions(List excs) {
            this.excs = excs;
        }

        protected List getParamList() {
            return this.params;
        }

        protected List getExceptionList() {
            return this.excs;
        }

        protected void drawParameter(Graphics g, JCResultItem.ParamStr prm) {
            this.drawParameter(g, prm, false);
        }

        protected void drawParameter(Graphics g, JCResultItem.ParamStr prm, boolean strike) {
            this.drawString(g, prm.getSimpleTypeName(), prm.getTypeColor(), null, strike);
            String name = prm.getName();
            if (name != null && name.length() > 0) {
                this.drawString(g, " ", strike);
                this.drawString(g, prm.getName(), this.PARAMETER_NAME_COLOR, null, strike);
            }
        }

        protected void drawParameterList(Graphics g, List prmList) {
            this.drawParameterList(g, prmList, false);
        }

        protected void drawParameterList(Graphics g, List prmList, boolean strike) {
            this.drawString(g, "(", strike);
            Iterator it = prmList.iterator();
            while (it.hasNext()) {
                this.drawParameter(g, (JCResultItem.ParamStr)it.next(), strike);
                if (!it.hasNext()) continue;
                this.drawString(g, ", ", strike);
            }
            this.drawString(g, ")", strike);
        }

        protected void drawExceptions(Graphics g, List exc, boolean strike) {
            if (exc.size() > 0) {
                this.drawString(g, JCPaintComponent.THROWS, KEYWORD_COLOR, null, strike);
                Iterator it = exc.iterator();
                while (it.hasNext()) {
                    JCResultItem.ExcStr ex = (JCResultItem.ExcStr)it.next();
                    this.drawString(g, ex.getName(), ex.getTypeColor(), null, strike);
                    if (!it.hasNext()) continue;
                    this.drawString(g, ", ", strike);
                }
            }
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            int level = JavaCompletion.getLevel(this.getModifiers());
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getName(), this.CONSTRUCTOR_COLOR, null, strike);
            this.drawParameterList(g, this.getParamList(), strike);
            this.drawExceptions(g, this.getExceptionList(), strike);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName());
            sb.append(" (");
            List prmList = this.getParamList();
            Iterator it = prmList.iterator();
            while (it.hasNext()) {
                JCResultItem.ParamStr paramStr = (JCResultItem.ParamStr)it.next();
                sb.append(paramStr.getTypeName());
                sb.append(" ");
                sb.append(paramStr.getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class FieldPaintComponent
    extends JCPaintComponent {
        private Color FIELD_COLOR = Color.blue.darker();
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;

        public void setName(String fldName) {
            this.fldName = fldName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            int level = JavaCompletion.getLevel(this.modifiers);
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.typeName, this.typeColor, null, strike);
            this.drawString(g, " ", strike);
            if ((this.modifiers & 0x20000000) != 0) {
                this.drawString(g, this.fldName, this.FIELD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.fldName, this.FIELD_COLOR, null, strike);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.typeName);
            sb.append(" ");
            sb.append(this.fldName);
            return sb.toString();
        }
    }

    public static class PackagePaintComponent
    extends JCPaintComponent {
        private JCPackage pkg;
        private String pkgName;
        private boolean displayFullPackagePath;
        private Color PACKAGE_COLOR = Color.green.darker().darker().darker();

        public void setPackageName(String pkgName) {
            this.pkgName = pkgName;
        }

        public void setDisplayFullPackagePath(boolean displayFullPackagePath) {
            this.displayFullPackagePath = displayFullPackagePath;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            String name = this.pkgName;
            if (!this.displayFullPackagePath) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            this.drawString(g, name, this.PACKAGE_COLOR);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String name = this.pkgName;
            if (!this.displayFullPackagePath) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            sb.append(name);
            return sb.toString();
        }
    }

    public static class InterfacePaintComponent
    extends ClassPaintComponent {
        private Color INTERFACE_COLOR = Color.darkGray;

        protected Color getColor() {
            return this.INTERFACE_COLOR;
        }
    }

    public static class ClassPaintComponent
    extends JCPaintComponent {
        String formatClassName;
        private Color CLASS_COLOR = Color.red.darker().darker().darker();
        private boolean displayFQN;

        public void setFormatClassName(String formatClassName) {
            this.formatClassName = formatClassName;
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.formatClassName, this.getColor(), null, strike);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.formatClassName);
            return sb.toString();
        }
    }
}

