/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.openide.ErrorManager;

class JavaDeclarationProcessor
implements ExtSyntaxSupport.DeclarationTokenProcessor,
ExtSyntaxSupport.VariableMapTokenProcessor {
    private static final int INIT = 0;
    private static final int TYPE_VAR = 1;
    private static final int TYPE_EXP = 2;
    private static final int VAR_EXP = 3;
    private static final int EQ_EXP = 4;
    private static final int VARIABLE = 1;
    private static final int DOT = 4;
    private static final int DOT_OPEN = 5;
    private static final int ARRAY_OPEN = 6;
    private static final int ARRAY = 7;
    private static final int PARENTHESIS_OPEN = 8;
    private static final int PARENTHESIS = 9;
    private static final int TYPE = 14;
    private static final int GENERIC_TYPE = 17;
    private static final int GENERIC_TYPE_OPEN = 18;
    private static final int GENERIC_WILD_CHAR = 19;
    private static final int NO_EXP = -1;
    private int state;
    private List expStack = new ArrayList();
    private JCExpression typeExp;
    private JavaSyntaxSupport sup;
    private int decStartPos = -1;
    private int typeVarTokenOffset;
    private int typeVarTokenLength;
    private TokenID typeVarTokenID;
    private int parenDepth;
    private int eqExpBraceDepth;
    private TokenID curTokenID;
    private int curTokenPosition;
    private int curTokenLength;
    private char[] buffer;
    private int bufferStartPos;
    private String varName;
    private StackedMap varMap;
    private boolean forScope;
    private int forScopeParenDepth;
    private Stack stackedConfigs = new Stack();

    JavaDeclarationProcessor(JavaSyntaxSupport sup, String varName) {
        this.sup = sup;
        this.varName = varName;
        if (varName == null) {
            this.varMap = new StackedMap();
        }
    }

    public int getDeclarationPosition() {
        return this.decStartPos;
    }

    public Map getVariableMap() {
        return this.varMap;
    }

    private void clearStack() {
        this.expStack.clear();
    }

    private void pushExp(JCExpression exp) {
        this.expStack.add(exp);
    }

    private JCExpression popExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? (JCExpression)this.expStack.remove(cnt - 1) : null;
    }

    private JCExpression peekExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? (JCExpression)this.expStack.get(cnt - 1) : null;
    }

    private JCExpression peekExp2() {
        int cnt = this.expStack.size();
        return cnt > 1 ? (JCExpression)this.expStack.get(cnt - 2) : null;
    }

    private JCExpression peekExp(int ind) {
        int cnt = this.expStack.size();
        return cnt >= ind ? (JCExpression)this.expStack.get(cnt - ind) : null;
    }

    private JCExpression createTokenExp(int id) {
        JCExpression exp = new JCExpression(id);
        this.addTokenTo(exp);
        return exp;
    }

    private void addTokenTo(JCExpression exp) {
        exp.addToken(this.curTokenID, this.curTokenPosition, this.getTokenText(this.curTokenPosition, this.curTokenLength));
    }

    private int getValidExpID(JCExpression exp) {
        return exp != null ? exp.getExpID() : -1;
    }

    private void pushTypeVar() {
        BaseTokenID id;
        int expType;
        if (this.state != 1) {
            throw new IllegalArgumentException();
        }
        this.state = 2;
        if (this.typeVarTokenID != null) {
            expType = 14;
            id = this.typeVarTokenID;
        } else {
            expType = 1;
            id = JavaTokenContext.IDENTIFIER;
        }
        JCExpression exp = new JCExpression(expType);
        exp.addToken((TokenID)id, this.typeVarTokenOffset, this.getTokenText(this.typeVarTokenOffset, this.typeVarTokenLength));
        this.pushExp(exp);
    }

    private void reset() {
        this.state = 0;
        this.clearStack();
        this.typeExp = null;
    }

    private void pushConfig() {
        this.stackedConfigs.push(new Integer(this.parenDepth));
        this.stackedConfigs.push(new Integer(this.eqExpBraceDepth));
        this.stackedConfigs.push(new Integer(this.state));
        this.stackedConfigs.push(this.typeExp);
        this.stackedConfigs.push(this.expStack);
        this.parenDepth = 0;
        this.eqExpBraceDepth = 0;
        this.state = 0;
        this.typeExp = null;
        this.expStack = new ArrayList();
    }

    private void popConfig() {
        this.expStack = (List)this.stackedConfigs.pop();
        this.typeExp = (JCExpression)this.stackedConfigs.pop();
        this.state = (Integer)this.stackedConfigs.pop();
        this.eqExpBraceDepth = (Integer)this.stackedConfigs.pop();
        this.parenDepth = (Integer)this.stackedConfigs.pop();
    }

    private boolean formTypeExp() {
        if (this.expStack.size() == 1) {
            this.typeExp = this.popExp();
            switch (this.typeExp.getExpID()) {
                case 5: 
                case 6: {
                    this.reset();
                    return false;
                }
            }
            this.state = 3;
            return true;
        }
        this.reset();
        return false;
    }

    private boolean formVarExp(boolean lastVar) {
        JCExpression varExp;
        if (this.expStack.size() == 1) {
            varExp = this.popExp();
            if (varExp != null) {
                switch (varExp.getExpID()) {
                    case 1: 
                    case 7: {
                        break;
                    }
                    default: {
                        varExp = null;
                        break;
                    }
                }
            }
        } else {
            varExp = null;
        }
        if (varExp != null) {
            this.processDeclaration(this.typeExp, varExp);
            if (lastVar) {
                this.reset();
            }
            return true;
        }
        this.reset();
        return false;
    }

    private String getTokenText(int offset, int length) {
        try {
            return this.sup.getDocument().getText(offset, length);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return "";
        }
    }

    private void processDeclaration(JCExpression typeExp, JCExpression varExp) {
        if (this.varName == null) {
            String varName = this.getVarName(varExp);
            JavaVar javaVar = new JavaVar(typeExp, varExp, this.getDeclarationPosition());
            this.varMap.put(varName, javaVar);
        } else if (this.varName.equals(this.getVarName(varExp))) {
            this.decStartPos = this.typeVarTokenOffset;
        }
    }

    private String getVarName(JCExpression varExp) {
        switch (varExp.getExpID()) {
            case 1: {
                return varExp.getTokenText(0);
            }
            case 7: {
                JCExpression var = varExp.getParameter(0);
                return var.getTokenText(0);
            }
        }
        throw new IllegalStateException();
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenOffset, int tokenLen) {
        int pos = this.bufferStartPos + tokenOffset;
        this.curTokenID = tokenID;
        this.curTokenPosition = pos;
        this.curTokenLength = tokenLen;
        if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
            this.state = 0;
            return true;
        }
        block0 : switch (tokenID.getNumericID()) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        this.typeVarTokenOffset = pos;
                        this.typeVarTokenLength = tokenLen;
                        this.typeVarTokenID = tokenID;
                        this.state = 1;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 88: {
                if (this.varMap == null) break;
                this.varMap.pushNewScope();
                this.forScope = true;
                break;
            }
            case 6: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        this.typeVarTokenOffset = pos;
                        this.typeVarTokenLength = tokenLen;
                        this.typeVarTokenID = null;
                        this.state = 1;
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 14: 
                            case 17: {
                                if (!this.formTypeExp()) break block0;
                                this.pushExp(this.createTokenExp(1));
                                break;
                            }
                            case 5: {
                                top.setExpID(4);
                                top.addParameter(this.createTokenExp(1));
                                break;
                            }
                            case 18: {
                                this.pushExp(this.createTokenExp(1));
                                break;
                            }
                            case 19: {
                                top.setExpID(1);
                                this.addTokenTo(top);
                                break;
                            }
                            default: {
                                this.reset();
                                break;
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        if (this.expStack.size() == 0) {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            case 48: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 17: {
                                this.popExp();
                                JCExpression opExp = this.createTokenExp(5);
                                opExp.addParameter(top);
                                this.pushExp(opExp);
                                break block0;
                            }
                            case 4: {
                                top.setExpID(5);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 55: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 14: 
                            case 17: {
                                this.popExp();
                                JCExpression opExp = this.createTokenExp(6);
                                opExp.addParameter(top);
                                this.pushExp(opExp);
                                break block0;
                            }
                            case 7: {
                                top.setExpID(6);
                                this.addTokenTo(top);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: {
                                this.popExp();
                                JCExpression opExp = this.createTokenExp(6);
                                opExp.addParameter(top);
                                this.pushExp(opExp);
                                break block0;
                            }
                            case 7: {
                                top.setExpID(6);
                                this.addTokenTo(top);
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 124: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 14: 
                            case 17: {
                                this.popExp();
                                JCExpression opExp = this.createTokenExp(7);
                                this.addTokenTo(opExp);
                                opExp.addParameter(top);
                                this.pushExp(opExp);
                                break block0;
                            }
                            case 7: {
                                this.addTokenTo(top);
                                this.addTokenTo(top);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 56: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.reset();
                        break block0;
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 6: {
                                this.addTokenTo(top);
                                top.setExpID(7);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 6: {
                                this.addTokenTo(top);
                                top.setExpID(7);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 18: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: {
                                this.popExp();
                                JCExpression genExp = this.createTokenExp(18);
                                genExp.addParameter(top);
                                this.pushExp(genExp);
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 19: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top2.setExpID(17);
                                        this.addTokenTo(top2);
                                        top = top2;
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 21: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        JCExpression top3 = this.peekExp(3);
                                        if (this.getValidExpID(top3) == 18) {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(17);
                                            this.addTokenTo(top2);
                                            this.popExp();
                                            top3.addParameter(top2);
                                            top3.setExpID(17);
                                            this.addTokenTo(top3);
                                            break block0;
                                        }
                                        this.reset();
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 22: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression top = this.peekExp();
                        switch (this.getValidExpID(top)) {
                            case 1: 
                            case 4: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        JCExpression top3 = this.peekExp(3);
                                        JCExpression top4 = this.peekExp(4);
                                        if (this.getValidExpID(top3) == 18 && this.getValidExpID(top4) == 18) {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(17);
                                            this.addTokenTo(top2);
                                            this.popExp();
                                            top3.addParameter(top2);
                                            top3.setExpID(17);
                                            this.addTokenTo(top3);
                                            this.popExp();
                                            top4.addParameter(top3);
                                            top4.setExpID(17);
                                            this.addTokenTo(top4);
                                            break block0;
                                        }
                                        this.reset();
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 53: {
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        this.reset();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++this.parenDepth;
                if (!this.forScope) break;
                ++this.forScopeParenDepth;
                break;
            }
            case 54: {
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 0: 
                    case 2: {
                        this.reset();
                        break;
                    }
                    case 3: {
                        if (this.parenDepth == 1) {
                            this.formVarExp(true);
                            break;
                        }
                        this.reset();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (this.parenDepth > 0) {
                    --this.parenDepth;
                }
                if (!this.forScope || this.forScopeParenDepth <= 0) break;
                --this.forScopeParenDepth;
                break;
            }
            case 57: {
                if (this.state != 4) {
                    this.reset();
                    this.parenDepth = 0;
                    if (!this.forScope && this.varMap != null) {
                        this.varMap.pushNewScope();
                    }
                    this.forScope = false;
                    if (this.stackedConfigs.isEmpty()) break;
                    ++this.eqExpBraceDepth;
                    break;
                }
                this.pushConfig();
                if (!this.forScope && this.varMap != null) {
                    this.varMap.pushNewScope();
                }
                this.forScope = false;
                break;
            }
            case 58: {
                if (!this.stackedConfigs.isEmpty() && this.eqExpBraceDepth == 0) {
                    this.popConfig();
                    if (this.varMap == null) break;
                    this.varMap.removeScope();
                    break;
                }
                this.reset();
                this.parenDepth = 0;
                if (this.varMap != null) {
                    this.varMap.removeScope();
                }
                if (this.stackedConfigs.isEmpty()) break;
                --this.eqExpBraceDepth;
                break;
            }
            case 51: {
                if (this.forScope && this.forScopeParenDepth == 0) {
                    if (this.varMap != null) {
                        this.varMap.removeScope();
                    }
                    this.forScope = false;
                }
                switch (this.state) {
                    case 3: {
                        this.formVarExp(true);
                        break block0;
                    }
                    case 4: {
                        if (this.parenDepth != 0 && (this.parenDepth != 1 || !this.forScope)) break;
                        this.formVarExp(false);
                    }
                }
                this.reset();
                break;
            }
            case 49: {
                if (this.parenDepth > 1) break;
                block148 : switch (this.state) {
                    case 2: {
                        JCExpression top2 = this.peekExp2();
                        if (this.getValidExpID(top2) == 18) {
                            JCExpression top = this.peekExp();
                            switch (this.getValidExpID(top)) {
                                case 1: 
                                case 4: 
                                case 17: 
                                case 19: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    this.addTokenTo(top2);
                                    break block148;
                                }
                            }
                            this.reset();
                            break;
                        }
                        this.reset();
                        break;
                    }
                    case 3: {
                        this.formVarExp(this.parenDepth == 1);
                        break;
                    }
                    case 4: {
                        if (this.parenDepth != 0) break block0;
                        this.formVarExp(false);
                        this.state = 3;
                        break;
                    }
                    default: {
                        this.reset();
                        break;
                    }
                }
                break;
            }
            case 17: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 3: {
                        this.state = 4;
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 50: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 3: {
                        this.formVarExp(true);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 52: {
                JCExpression top;
                if (this.parenDepth <= 1 && this.state == 2 && this.getValidExpID(top = this.peekExp()) == 18) {
                    this.pushExp(new JCExpression(19));
                    break;
                }
                if (this.state == 4) break;
                this.reset();
                break;
            }
            case 84: 
            case 105: {
                if (this.parenDepth <= 1 && this.state == 2 && this.getValidExpID(this.peekExp()) == 19) break;
            }
            default: {
                if (this.state == 4) break;
                this.reset();
            }
        }
        return true;
    }

    public int eot(int offset) {
        return 0;
    }

    public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
        this.buffer = buffer;
        this.bufferStartPos = startPos - offset;
    }

    private static class StackedMap
    implements Map {
        private Stack stack = new Stack();

        private StackedMap() {
        }

        public int size() {
            int size = 0;
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                size += ((Map)it.next()).size();
            }
            return size;
        }

        public boolean isEmpty() {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                if (((Map)it.next()).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean containsKey(Object key) {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                if (!((Map)it.next()).containsKey(key)) continue;
                return true;
            }
            return false;
        }

        public boolean containsValue(Object value) {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                if (!((Map)it.next()).containsValue(value)) continue;
                return true;
            }
            return false;
        }

        public Object get(Object key) {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                Object o = ((Map)it.next()).get(key);
                if (o == null) continue;
                return o;
            }
            return null;
        }

        public Object put(Object key, Object value) {
            if (this.stack.isEmpty()) {
                this.pushNewScope();
            }
            return ((Map)this.stack.peek()).put(key, value);
        }

        public Object remove(Object key) {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                Object o = ((Map)it.next()).remove(key);
                if (o == null) continue;
                return o;
            }
            return null;
        }

        public void putAll(Map t) {
            if (this.stack.isEmpty()) {
                this.pushNewScope();
            }
            ((Map)this.stack.peek()).putAll(t);
        }

        public void clear() {
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                ((Map)it.next()).clear();
            }
        }

        public Set keySet() {
            TreeSet set = new TreeSet();
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                set.addAll(((Map)it.next()).keySet());
            }
            return set;
        }

        public Collection values() {
            ArrayList col = new ArrayList();
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                col.addAll(((Map)it.next()).values());
            }
            return col;
        }

        public Set entrySet() {
            HashSet set = new HashSet();
            Iterator it = this.stack.iterator();
            while (it.hasNext()) {
                set.addAll(((Map)it.next()).entrySet());
            }
            return set;
        }

        public void pushNewScope() {
            this.stack.push(new HashMap());
        }

        public void removeScope() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }
    }

    private static class JavaVar
    implements JavaSyntaxSupport.OffsetJavaVariable {
        private JCExpression typeExp;
        private JCExpression varExp;
        private int offset;

        JavaVar(JCExpression typeExp, JCExpression varExp, int offset) {
            this.typeExp = typeExp;
            this.varExp = varExp;
            this.offset = offset;
        }

        public JCExpression getTypeExpression() {
            return this.typeExp;
        }

        public JCExpression getVariableExpression() {
            return this.varExp;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "TYPE:\n" + this.typeExp + "\nVAR:\n" + this.varExp;
        }
    }
}

