/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.openide.util.NbBundle;

final class JavaFastImportPanel
extends JPanel {
    private JavaFastImport jfi;
    private int currentImportType;
    private int selectedIndex = 0;
    private JList jl;
    private JRadioButton importPackage;
    private JPanel listPanel;
    private ButtonGroup importType;
    private JLabel listLabel;
    private JRadioButton importClass;
    private JRadioButton fullyQualifiedName;
    private JScrollPane listScrollPane;

    public JavaFastImportPanel(JavaFastImport jfi, int importType) {
        this.jfi = jfi;
        this.currentImportType = importType;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI"));
        this.listLabel.setDisplayedMnemonic(LocaleSupport.getString((String)"JFI_listLabelMnemonic", (String)"M").charAt(0));
        this.jl = jfi.getResultList();
        this.listScrollPane.setViewportView(this.jl);
        this.listLabel.setLabelFor(this.jl);
        this.jl.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_listLabel"));
        this.importClass.setMnemonic(LocaleSupport.getString((String)"JFI_importButtonMnemonic", (String)"C").charAt(0));
        this.importPackage.setMnemonic(LocaleSupport.getString((String)"JFI_importButton_packageMnemonic", (String)"P").charAt(0));
        this.fullyQualifiedName.setMnemonic(LocaleSupport.getString((String)"JFI_fullyButtonMnemonic", (String)"F").charAt(0));
        this.importClass.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_importClass"));
        this.importPackage.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_importPackage"));
        this.fullyQualifiedName.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_fullyQualifiedName"));
        Dimension dim = this.getSize();
        this.setSize(new Dimension(dim.width < 500 ? 500 : dim.width, dim.height));
    }

    public void addNotify() {
        super.addNotify();
        this.updateWhenImportTypeChanges(-1);
    }

    public int getImportType() {
        if (this.importPackage.isSelected()) {
            return 1;
        }
        if (this.fullyQualifiedName.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void setPackageImportEnabled(boolean b) {
        this.importPackage.setEnabled(b);
    }

    private void updateWhenImportTypeChanges(int newImportType) {
        String newText;
        this.selectedIndex = this.jl.getSelectedIndex();
        if (newImportType == this.currentImportType) {
            return;
        }
        if (newImportType != -1) {
            this.currentImportType = newImportType;
        }
        switch (this.currentImportType) {
            case 1: {
                this.importPackage.setSelected(true);
                break;
            }
            case 2: {
                this.fullyQualifiedName.setSelected(true);
                break;
            }
            default: {
                this.importClass.setSelected(true);
            }
        }
        String string = newText = this.importPackage.isSelected() ? LocaleSupport.getString((String)"JFI_listLabel_package", (String)"Matching Packages:") : LocaleSupport.getString((String)"JFI_listLabel", (String)"Matching Classes:");
        if (newText.equals(this.listLabel.getText())) {
            return;
        }
        this.listLabel.setText(newText);
        List result = this.jfi.evaluate();
        if (result == null || result.size() == 0) {
            return;
        }
        this.jfi.populate(result);
        this.jl.setSelectedIndex(this.selectedIndex);
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Dimension max = this.getMaximumSize();
        if (pref.width > max.width) {
            pref.width = max.width;
        }
        if (pref.height > max.height) {
            pref.height = max.height;
        }
        return pref;
    }

    void popupNotify() {
        this.listScrollPane.requestFocus();
    }

    private void initComponents() {
        this.importType = new ButtonGroup();
        this.listLabel = new JLabel();
        this.listPanel = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.importClass = new JRadioButton();
        this.importPackage = new JRadioButton();
        this.fullyQualifiedName = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.listLabel, gridBagConstraints);
        this.listPanel.setLayout(new GridBagLayout());
        this.listScrollPane.setPreferredSize(new Dimension(320, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)this.listScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listPanel, gridBagConstraints);
        this.importClass.setText(NbBundle.getBundle((Class)JavaFastImportPanel.class).getString("JFI_importButton"));
        this.importType.add(this.importClass);
        this.importClass.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.importClass, gridBagConstraints);
        this.importPackage.setText(NbBundle.getBundle((Class)JavaFastImportPanel.class).getString("JFI_importButton_package"));
        this.importType.add(this.importPackage);
        this.importPackage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.importPackage, gridBagConstraints);
        this.fullyQualifiedName.setText(NbBundle.getBundle((Class)JavaFastImportPanel.class).getString("JFI_fullyButton"));
        this.importType.add(this.fullyQualifiedName);
        this.fullyQualifiedName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fullyQualifiedName, gridBagConstraints);
    }

    private void updateWhenImportTypeChanges(ItemEvent evt) {
        this.updateWhenImportTypeChanges(this.getImportType());
    }
}

