/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.BODY;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;

    public IMAPInputStream(IMAPMessage iMAPMessage, String string, int n) {
        this.msg = iMAPMessage;
        this.section = string;
        this.max = n;
        this.pos = 0;
        this.blksize = iMAPMessage.getFetchBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() throws IOException {
        int n;
        if (this.max != -1 && this.pos >= this.max) {
            if (this.pos == 0) {
                this.checkSeen();
            }
            return;
        }
        BODY bODY = null;
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            if (this.msg.isExpunged()) {
                throw new IOException("No content for expunged message");
            }
            n = this.msg.getSequenceNumber();
            int n2 = this.blksize;
            if (this.max != -1 && this.pos + this.blksize > this.max) {
                n2 = this.max - this.pos;
            }
            try {
                bODY = this.msg.getProtocol().fetchBody(n, this.section, this.pos, n2);
            }
            catch (ProtocolException protocolException) {
                throw new IOException(protocolException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new IOException(folderClosedException.getMessage());
            }
        }
        if (bODY == null || (object = bODY.getByteArray()) == null) {
            throw new IOException("No content");
        }
        if (this.pos == 0) {
            this.checkSeen();
        }
        this.buf = ((ByteArray)object).getBytes();
        this.bufpos = ((ByteArray)object).getStart();
        n = ((ByteArray)object).getCount();
        this.bufcount = this.bufpos + n;
        this.pos += n;
    }

    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bufcount - this.bufpos;
        if (n3 <= 0) {
            this.fill();
            n3 = this.bufcount - this.bufpos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.bufpos, byArray, n, n4);
        this.bufpos += n4;
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void checkSeen() {
        try {
            Folder folder = this.msg.getFolder();
            if (folder != null && folder.getMode() != 1 && !this.msg.isSet(Flags.Flag.SEEN)) {
                this.msg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

