/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class JavaPlatformManager {
    public static final String PROP_INSTALLED_PLATFORMS = "installedPlatforms";
    private static JavaPlatformManager instance;
    private Lookup.Result providers;
    private Collection lastProviders = Collections.EMPTY_SET;
    private boolean providersValid = false;
    private PropertyChangeListener pListener;
    private Collection cachedPlatforms;
    private HashSet listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized JavaPlatformManager getDefault() {
        if (instance == null) {
            instance = new JavaPlatformManager();
        }
        return instance;
    }

    public JavaPlatform getDefaultPlatform() {
        Collection instances = this.getProviders();
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            JavaPlatformProvider provider = (JavaPlatformProvider)it.next();
            JavaPlatform defaultPlatform = provider.getDefaultPlatform();
            if (defaultPlatform == null) continue;
            return defaultPlatform;
        }
        return null;
    }

    public synchronized JavaPlatform[] getInstalledPlatforms() {
        if (this.cachedPlatforms == null) {
            Collection instances = this.getProviders();
            this.cachedPlatforms = new HashSet();
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                JavaPlatformProvider provider = (JavaPlatformProvider)it.next();
                JavaPlatform[] platforms = provider.getInstalledPlatforms();
                for (int i = 0; i < platforms.length; ++i) {
                    this.cachedPlatforms.add(platforms[i]);
                }
            }
        }
        return this.cachedPlatforms.toArray(new JavaPlatform[this.cachedPlatforms.size()]);
    }

    public JavaPlatform[] getPlatforms(String platformDisplayName, Specification platformSpec) {
        JavaPlatform[] platforms = this.getInstalledPlatforms();
        ArrayList<JavaPlatform> result = new ArrayList<JavaPlatform>();
        for (int i = 0; i < platforms.length; ++i) {
            Specification spec;
            String name = platformDisplayName == null ? null : platforms[i].getDisplayName();
            Specification specification = spec = platformSpec == null ? null : platforms[i].getSpecification();
            if (platformDisplayName != null && !name.equalsIgnoreCase(platformDisplayName) || platformSpec != null && !JavaPlatformManager.compatible(spec, platformSpec)) continue;
            result.add(platforms[i]);
        }
        return result.toArray(new JavaPlatform[result.size()]);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError((Object)"Listener can not be null");
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError((Object)"Listener can not be null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String property) {
        Iterator it;
        JavaPlatformManager javaPlatformManager = this;
        synchronized (javaPlatformManager) {
            if (this.listeners == null) {
                return;
            }
            it = ((Set)this.listeners.clone()).iterator();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, property, null, null);
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    private static boolean compatible(Specification platformSpec, Specification query) {
        String name = query.getName();
        SpecificationVersion version = query.getVersion();
        return !(name != null && !name.equalsIgnoreCase(platformSpec.getName()) || version != null && !version.equals((Object)platformSpec.getVersion()) || !JavaPlatformManager.compatibleProfiles(platformSpec.getProfiles(), query.getProfiles()));
    }

    private static boolean compatibleProfiles(Profile[] platformProfiles, Profile[] query) {
        if (query == null) {
            return true;
        }
        if (platformProfiles == null) {
            return false;
        }
        HashSet<Profile> covered = new HashSet<Profile>();
        for (int i = 0; i < query.length; ++i) {
            Profile pattern = query[i];
            boolean found = false;
            for (int j = 0; j < platformProfiles.length; ++j) {
                if (!JavaPlatformManager.compatibleProfile(platformProfiles[j], pattern)) continue;
                found = true;
                covered.add(platformProfiles[j]);
            }
            if (found) continue;
            return false;
        }
        return covered.size() == platformProfiles.length;
    }

    private static boolean compatibleProfile(Profile platformProfile, Profile query) {
        String name = query.getName();
        SpecificationVersion version = query.getVersion();
        return !(name != null && !name.equals(platformProfile.getName()) || version != null && !version.equals((Object)platformProfile.getVersion()));
    }

    private synchronized Collection getProviders() {
        if (!this.providersValid) {
            JavaPlatformProvider provider;
            if (this.providers == null) {
                this.providers = Lookup.getDefault().lookup(new Lookup.Template(JavaPlatformProvider.class));
                this.providers.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        JavaPlatformManager.this.resetCache(true);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                });
            }
            if (this.pListener == null) {
                this.pListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        JavaPlatformManager.this.resetCache(false);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                };
            }
            Collection instances = this.providers.allInstances();
            HashSet toAdd = new HashSet(instances);
            toAdd.removeAll(this.lastProviders);
            HashSet toRemove = new HashSet(this.lastProviders);
            toRemove.removeAll(instances);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                provider = (JavaPlatformProvider)it.next();
                provider.removePropertyChangeListener(this.pListener);
            }
            it = toAdd.iterator();
            while (it.hasNext()) {
                provider = (JavaPlatformProvider)it.next();
                provider.addPropertyChangeListener(this.pListener);
            }
            this.lastProviders = instances;
            this.providersValid = true;
        }
        return this.lastProviders;
    }

    private synchronized void resetCache(boolean resetProviders) {
        this.cachedPlatforms = null;
        this.providersValid &= !resetProviders;
    }

    static {
        $assertionsDisabled = !JavaPlatformManager.class.desiredAssertionStatus();
        instance = null;
    }
}

