/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterPanel;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FiltersPanel
extends JPanel
implements ActionListener {
    public static final String SELECTED_FILTER = "fp-selected-filter";
    private HashMap panels = new HashMap(10);
    private FilteredTopComponent view;
    private FilterRepository filterRepository;
    private FilterModel filterModel;
    final JButton DeleteButton = new JButton();
    final JPanel buttons1Panel = new JPanel();
    final JPanel buttons2Panel = new JPanel();
    final JPanel filterEditorPlaceholder = new JPanel();
    final JScrollPane filterListScrollPane = new JScrollPane();
    final JLabel filtersLabel = new JLabel();
    final JList filtersList = new JList();
    final JButton newButton = new JButton();

    public FiltersPanel(FilteredTopComponent view) {
        this.view = view;
        this.filterRepository = view.getFilters();
        this.filterModel = new FilterModel(this.filterRepository);
        Iterator it = this.filterModel.filters.iterator();
        while (it.hasNext()) {
            this.panels.put(it.next(), null);
        }
        this.myInitComponents();
    }

    public FilterRepository getFilterRepository() {
        return this.filterRepository;
    }

    private void myInitComponents() {
        this.initComponents();
        this.filtersList.setModel(this.filterModel);
        this.filtersList.setSelectionModel(this.filterModel.selection);
        this.filtersList.setSelectionMode(0);
        Object selected = null;
        if (this.view instanceof JComponent) {
            selected = ((JComponent)((Object)this.view)).getClientProperty(SELECTED_FILTER);
        }
        if (selected != null && selected instanceof String) {
            Iterator it = this.filterModel.iterator();
            int i = 0;
            while (it.hasNext()) {
                Filter filter = (Filter)it.next();
                if (selected.equals(filter.getName())) {
                    this.filtersList.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.filterModel.getSelectedIndex() == -1 && this.filterModel.getSize() > 0) {
            this.filtersList.setSelectedIndex(0);
        }
        this.filtersList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FiltersPanel.this.showFilter(FiltersPanel.this.filterModel.getSelectedFilter());
                    FiltersPanel.this.DeleteButton.setEnabled(FiltersPanel.this.filterModel.getSelectedIndex() != -1);
                }
            }
        });
        this.showFilter(this.filterModel.getSelectedFilter());
        this.DeleteButton.setEnabled(this.filterModel.getSelectedIndex() != -1);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage((Class)FiltersPanel.class, (String)"LBL_Filters"));
    }

    private void showFilter(final Filter filter) {
        FilterPanel panel = (FilterPanel)this.panels.get(filter);
        if (panel == null) {
            panel = new FilterPanel(this.view, filter);
            this.panels.put(filter, panel);
            panel.getFilterNameField().getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    this.update(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.update(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.update(e);
                }

                private void update(DocumentEvent e) {
                    try {
                        FiltersPanel.this.filterModel.setFilterName(FiltersPanel.this.filterModel.getIndexOf(filter), e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        System.err.println("EXXXX");
                    }
                }
            });
        }
        if (this.filterEditorPlaceholder.getComponentCount() > 0) {
            this.filterEditorPlaceholder.remove(0);
        }
        this.filterEditorPlaceholder.add((Component)panel, "Center");
        panel.setVisible(true);
        panel.requestFocus();
        if (this.filterModel.getSelectedFilter() != filter) {
            this.filtersList.setSelectedIndex(this.filterModel.getIndexOf(filter));
        }
        this.filterEditorPlaceholder.validate();
        this.filterEditorPlaceholder.repaint();
    }

    public boolean isValueValid() {
        Iterator it = this.panels.values().iterator();
        while (it.hasNext()) {
            FilterPanel fp = (FilterPanel)it.next();
            if (fp.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void updateFilters() {
        this.filterRepository.clear();
        Iterator filterIt = this.filterModel.iterator();
        while (filterIt.hasNext()) {
            Filter f = (Filter)filterIt.next();
            if (this.panels.get(f) != null) {
                f = ((FilterPanel)this.panels.get(f)).getFilter();
            }
            this.filterRepository.add(f);
        }
        if (this.filterModel.getSelectedFilter() != null) {
            this.filterRepository.setActive(this.filterModel.getSelectedFilter());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(800, 500));
        this.setRequestFocusEnabled(false);
        this.filterEditorPlaceholder.setLayout(new BorderLayout());
        this.filterEditorPlaceholder.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.filterEditorPlaceholder.setAlignmentX(0.0f);
        this.filterEditorPlaceholder.setMinimumSize(new Dimension(0, 0));
        this.filterEditorPlaceholder.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filterEditorPlaceholder, gridBagConstraints);
        this.buttons1Panel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_New_Filter"));
        this.newButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_New_Filter_Hint"));
        this.newButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.buttons1Panel.add((Component)this.newButton, gridBagConstraints);
        this.newButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FiltersPanel.class, (String)"ACSN_NewFilter"));
        this.newButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FiltersPanel.class, (String)"ACSD_NewFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.DeleteButton, (String)ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_Delete_Filter"));
        this.DeleteButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_Delete_Filter_Hint"));
        this.DeleteButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.buttons1Panel.add((Component)this.DeleteButton, gridBagConstraints);
        this.DeleteButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FiltersPanel.class, (String)"ACSN_DeleteFilter"));
        this.DeleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FiltersPanel.class, (String)"ACSD_DeleteFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buttons1Panel, gridBagConstraints);
        this.buttons2Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buttons2Panel, gridBagConstraints);
        this.filterListScrollPane.setVerticalScrollBarPolicy(22);
        this.filterListScrollPane.setAlignmentX(0.0f);
        this.filterListScrollPane.setAlignmentY(0.0f);
        this.filterListScrollPane.setMinimumSize(new Dimension(0, 0));
        this.filterListScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filterListScrollPane.setAutoscrolls(true);
        this.filtersList.setSelectionMode(0);
        this.filtersList.setAlignmentX(0.0f);
        this.filtersList.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filterListScrollPane.setViewportView(this.filtersList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filterListScrollPane, gridBagConstraints);
        this.filterListScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)FiltersPanel.class).getString("ACSN_Filters"));
        this.filterListScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FiltersPanel.class).getString("ACSD_Filters"));
        this.filtersLabel.setLabelFor(this.filtersList);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getBundle((Class)FiltersPanel.class).getString("LBL_Filters"));
        this.filtersLabel.setToolTipText(NbBundle.getBundle((Class)FiltersPanel.class).getString("HNT_Filters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.filtersLabel, gridBagConstraints);
        this.filtersLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)FiltersPanel.class).getString("ACSN_Filters"));
        this.filtersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FiltersPanel.class).getString("ACSD_Filters"));
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.newButton) {
            this.newButtonActionPerformed(evt);
        } else if (evt.getSource() == this.DeleteButton) {
            this.DeleteButtonActionPerformed(evt);
        }
    }

    private void previewButtonActionPerformed(ActionEvent evt) {
    }

    private void DeleteButtonActionPerformed(ActionEvent evt) {
        int i = this.filterModel.getSelectedIndex();
        if (i != -1) {
            Filter f = this.filterModel.get(i);
            this.filterModel.remove(i);
            this.panels.remove(f);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        Filter f = this.view.createFilter();
        this.filterModel.add(f);
        this.panels.put(f, null);
        this.showFilter(f);
    }

    private static class FilterModel
    extends AbstractListModel {
        public DefaultListSelectionModel selection = new DefaultListSelectionModel();
        public Vector filters;

        public FilterModel(FilterRepository rep) {
            this.filters = new Vector(rep.size() * 2);
            Iterator it = rep.iterator();
            int selectedi = 0;
            while (it.hasNext()) {
                Filter f = (Filter)it.next();
                if (f == rep.getActive()) {
                    this.selection.setSelectionInterval(selectedi, selectedi);
                }
                this.filters.add(f.clone());
                ++selectedi;
            }
        }

        public Iterator iterator() {
            return this.filters.iterator();
        }

        public Object getElementAt(int index) {
            return ((Filter)this.filters.get(index)).getName();
        }

        public int getSize() {
            return this.filters.size();
        }

        public Filter getSelectedFilter() {
            if (this.getSelectedIndex() > -1) {
                return (Filter)this.filters.get(this.getSelectedIndex());
            }
            return null;
        }

        public int getSelectedIndex() {
            int i2;
            int i1 = this.selection.getMinSelectionIndex();
            if (i1 == (i2 = this.selection.getMaxSelectionIndex()) && i1 >= 0 && i1 < this.filters.size()) {
                return i1;
            }
            return -1;
        }

        public void remove(int i) {
            int s = this.getSelectedIndex();
            if (s != -1) {
                this.filters.remove(i);
                this.fireIntervalRemoved(this, i, i);
                if (i < s) {
                    this.selection.setSelectionInterval(s - 1, s - 1);
                }
                if (i == s) {
                    this.selection.setSelectionInterval(100, 0);
                }
            }
        }

        public Filter get(int i) {
            return (Filter)this.filters.get(i);
        }

        public boolean add(Filter f) {
            if (this.filters.add(f)) {
                this.fireIntervalAdded(this, this.filters.size() - 1, this.filters.size() - 1);
                return true;
            }
            return false;
        }

        public int getIndexOf(Filter f) {
            return this.filters.indexOf(f);
        }

        public void setFilterName(int i, String name) {
            if (this.get(i) != null) {
                this.get(i).setName(name);
                this.fireContentsChanged(this, i, i);
            }
        }
    }
}

