/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.DDRoot;
import org.netbeans.modules.j2ee.sun.share.config.ModuleDDSupport;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.j2ee.sun.share.config.Utils;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanTopComponent;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.xml.sax.SAXException;

public class ConfigurationStorage
implements PropertyChangeListener,
Node.Cookie {
    public static final String ROOT = "/";
    private SunONEDeploymentConfiguration config;
    private ConfigDataObject configDataObject = null;
    private Object dobjMonitor = new Object();
    private PropertyChangeListener weakPropListener = null;
    Map moduleMap = new HashMap();
    final Map versionListeners = new HashMap();
    private boolean needsSave = false;
    final J2eeModuleProvider module;
    boolean loaded = false;
    private RequestProcessor.Task autoSaveTask;
    private int saveInProgress;
    private int cleanInProgress;
    private boolean saveFailedDialogDisplayed;
    private PropertyChangeSupport dobjCookieChangeSupport;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigurationStorage(J2eeModuleProvider module, SunONEDeploymentConfiguration config) throws ConfigurationException, InvalidModuleException, IOException, SAXException {
        this.module = module;
        this.config = config;
        this.saveInProgress = 0;
        this.cleanInProgress = 0;
        this.dobjCookieChangeSupport = new PropertyChangeSupport(this);
        this.load();
        this.createVersionListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws ConfigurationException, InvalidModuleException, IOException {
        try {
            ++this.cleanInProgress;
            Iterator i = this.moduleMap.values().iterator();
            while (i.hasNext()) {
                ((ModuleDDSupport)i.next()).cleanup();
            }
            this.moduleMap.clear();
        }
        finally {
            --this.cleanInProgress;
        }
        ModuleDDSupport mds = new ModuleDDSupport(this.module, (DeploymentConfiguration)this.config);
        this.moduleMap.put(ROOT, mds);
    }

    public DDBeanRoot normalizeDDBeanRoot(DDBeanRoot ddBeanRoot) {
        DDRoot newRoot;
        DDBeanRoot ddNew = ddBeanRoot;
        ModuleDDSupport mds = (ModuleDDSupport)this.moduleMap.get(ROOT);
        if (mds != null && (newRoot = mds.getDDBeanRoot()) != ddBeanRoot && newRoot != null) {
            ddNew = newRoot;
            if (!$assertionsDisabled && !ddBeanRoot.getXpath().equals(ddNew.getXpath())) {
                throw new AssertionError((Object)("Mismatched xpaths in normalizeDDBeanRoot for " + ddBeanRoot));
            }
        }
        return ddNew;
    }

    public DDBean normalizeEjbDDBean(DDBean ejbDDBean) {
        int i;
        StandardDDImpl result = null;
        String theEjbName = Utils.getField(ejbDDBean, "ejb-name");
        ModuleDDSupport mds = (ModuleDDSupport)this.moduleMap.get(ROOT);
        DDRoot ddRoot = mds.getDDBeanRoot("META-INF/ejb-jar.xml");
        StandardDDImpl[] ddBeans = (StandardDDImpl[])ddRoot.getChildBean(ejbDDBean.getXpath());
        for (i = 0; i < ddBeans.length; ++i) {
            String ejbName = (String)ddBeans[i].proxy.bean.getValue("EjbName");
            if (!theEjbName.equals(ejbName)) continue;
            result = ddBeans[i];
            break;
        }
        if (result == null) {
            if (ddBeans != null) {
                for (i = 0; i < ddBeans.length; ++i) {
                    String msg = ddBeans[i].proxy.bean.dumpBeanNode();
                    ErrorManager.getDefault().log(65536, msg);
                }
            }
            Exception ex = new Exception("Failed to lookup: " + theEjbName + ", type " + ejbDDBean.getXpath());
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    private boolean ensureLoaded() {
        if (this.loaded) {
            return true;
        }
        try {
            this.load();
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigDataObject getPrimaryDataObject() {
        ConfigDataObject configDO;
        Object object = this.dobjMonitor;
        synchronized (object) {
            FileObject configFO;
            if (this.configDataObject == null && (configFO = FileUtil.toFileObject((File)this.config.getConfigFiles()[0])) != null) {
                try {
                    DataObject dObj = DataObject.find((FileObject)configFO);
                    if (dObj instanceof ConfigDataObject) {
                        this.configDataObject = (ConfigDataObject)dObj;
                        this.weakPropListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.configDataObject);
                        this.configDataObject.addPropertyChangeListener(this.weakPropListener);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
            }
            configDO = this.configDataObject;
        }
        return configDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if ("valid".equals(evt.getPropertyName())) {
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                Object object = this.dobjMonitor;
                synchronized (object) {
                    this.configDataObject.removePropertyChangeListener(this.weakPropListener);
                    this.configDataObject = null;
                    this.weakPropListener = null;
                }
            }
        } else if ("cookie".equals(evt.getPropertyName())) {
            this.dobjCookieChangeSupport.firePropertyChange(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pCL) {
        this.dobjCookieChangeSupport.addPropertyChangeListener(pCL);
    }

    public void removePropertyChangeListener(PropertyChangeListener pCL) {
        this.dobjCookieChangeSupport.removePropertyChangeListener(pCL);
    }

    private String filesToString(File[] files) {
        StringBuffer sb = new StringBuffer();
        if (files.length > 0) {
            sb.append(files[0].getPath());
        }
        for (int i = 1; i < files.length; ++i) {
            sb.append(", ");
            sb.append(files[i].getPath());
        }
        return sb.toString();
    }

    public void autoSave() {
        if (this.autoSaveTask == null) {
            this.autoSaveTask = RequestProcessor.getDefault().post(new Runnable(){
                private boolean dialogIsDisplayed;

                public void run() {
                    Mutex.EVENT.readAccess(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (dialogIsDisplayed) {
                                return;
                            }
                            ConfigDataObject configDO = ConfigurationStorage.this.getPrimaryDataObject();
                            if (configDO == null) {
                                FileObject configFO = FileUtil.toFileObject((File)ConfigurationStorage.this.config.getConfigFiles()[0]);
                                if (configFO == null) {
                                    try {
                                        ConfigurationStorage.this.save();
                                    }
                                    catch (Exception ex) {
                                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                                    }
                                }
                                return;
                            }
                            if (!configDO.isConfigEditorOpened()) {
                                try {
                                    if (configDO.areModified()) {
                                        File[] files = ConfigurationStorage.this.config.getConfigFiles();
                                        String serverName = ConfigurationStorage.this.config.getAppServerVersion().toString();
                                        String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage = ConfigurationStorage.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage), (String)"MSG_SaveGeneratedChanges", (Object)serverName, (Object)ConfigurationStorage.this.filesToString(files));
                                        NotifyDescriptor.Confirmation cf = new NotifyDescriptor.Confirmation((Object)msg, 0);
                                        dialogIsDisplayed = true;
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)cf);
                                        if (!NotifyDescriptor.YES_OPTION.equals(cf.getValue())) {
                                            return;
                                        }
                                    }
                                    ConfigurationStorage.this.save();
                                }
                                catch (Exception ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                }
                                finally {
                                    dialogIsDisplayed = false;
                                }
                            } else {
                                configDO.setChanged();
                            }
                        }
                    });
                }
            }, 100);
        } else {
            this.autoSaveTask.schedule(100);
        }
    }

    public void setChanged() {
        if (this.cleanInProgress == 0) {
            this.needsSave = true;
            this.autoSave();
        }
    }

    public void updateDDRoot(FileObject dd) {
        ModuleDDSupport mds;
        if ("webservices".equals(dd.getName()) && (mds = (ModuleDDSupport)this.moduleMap.get(ROOT)) != null) {
            mds.getDDBeanRoot(ModuleDDSupport.filenameToPath(dd.getNameExt(), mds.getType()));
        }
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.config;
    }

    public static J2eeModuleProvider getChildModuleProvider(J2eeModuleProvider jmp, String uri) {
        J2eeAppProvider jap;
        if (uri == null) {
            return null;
        }
        J2eeModuleProvider child = null;
        if (jmp instanceof J2eeAppProvider && (child = (jap = (J2eeAppProvider)jmp).getChildModuleProvider(uri)) == null) {
            uri = uri.startsWith(ROOT) ? uri.substring(1) : ROOT + uri;
            child = jap.getChildModuleProvider(uri);
        }
        return child;
    }

    public Node getMainNode() {
        Node[] nodes = this.getMainNodes();
        return nodes.length > 0 ? nodes[0] : null;
    }

    public Node[] getMainNodes() {
        if (!this.ensureLoaded()) {
            return new Node[0];
        }
        ModuleDDSupport mds = (ModuleDDSupport)this.moduleMap.get(ROOT);
        return mds == null ? new Node[]{} : mds.getNodes();
    }

    public Node[] getNodes(J2eeModule mod) {
        if (!this.ensureLoaded()) {
            return new Node[0];
        }
        ModuleDDSupport mds = (ModuleDDSupport)this.moduleMap.get(mod.getUrl());
        if (mds == null) {
            return new Node[0];
        }
        return mds.getNodes();
    }

    private void createDConfigBean(ModuleDDSupport mod) throws ConfigurationException {
        mod.createConfigs(this);
    }

    public void saveOnDemand() throws IOException {
        if (this.needsSave) {
            this.save();
        }
    }

    public void save() throws IOException {
        block8: {
            try {
                ++this.saveInProgress;
                if (this.config != null) {
                    this.config.writeDeploymentPlanFiles(this);
                    this.needsSave = false;
                    ConfigDataObject configDO = this.getPrimaryDataObject();
                    if (configDO != null) {
                        configDO.resetChanged();
                    }
                    break block8;
                }
                throw new IllegalStateException("Attempted to save configuration when DeploymentConfiguration is null.");
            }
            catch (ConfigurationException ce) {
                this.reportExceptionDuringSave((Exception)((Object)ce));
                IOException ioe = new IOException(ce.getLocalizedMessage());
                ioe.initCause(ce);
                throw ioe;
            }
            catch (IOException ioe) {
                this.reportExceptionDuringSave(ioe);
                throw ioe;
            }
            finally {
                --this.saveInProgress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportExceptionDuringSave(Exception ex) {
        if (!this.saveFailedDialogDisplayed) {
            try {
                this.saveFailedDialogDisplayed = true;
                String exceptionMsg = ex.getLocalizedMessage();
                String appServerVersion = this.config.getAppServerVersion().toString();
                String fileList = this.filesToString(this.config.getConfigFiles());
                String errorMsg = exceptionMsg != null && exceptionMsg.length() > 0 ? (ex instanceof IOException ? exceptionMsg : NbBundle.getMessage((Class)ConfigurationStorage.class, (String)"MSG_ConfigurationSaveFailedHasMessage", (Object)appServerVersion, (Object)fileList, (Object)exceptionMsg)) : NbBundle.getMessage((Class)ConfigurationStorage.class, (String)"MSG_ConfigurationSaveFailed", (Object)appServerVersion, (Object)fileList);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMsg));
            }
            finally {
                this.saveFailedDialogDisplayed = false;
            }
        }
    }

    public void load() throws IOException, InvalidModuleException, ConfigurationException {
        if (this.saveInProgress > 0) {
            return;
        }
        this.init();
        if (!(this.config instanceof SunONEDeploymentConfiguration)) {
            throw new IllegalArgumentException("Invalid DeploymentConfiguration: " + this.config);
        }
        SunONEDeploymentConfiguration s1dc = this.config;
        ModuleDDSupport rootSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        s1dc.readDeploymentPlanFiles(this, rootSupport.getDDBeanRoot());
        this.createDConfigBean(rootSupport);
        this.loaded = true;
    }

    public void cleanup() {
        Iterator i = this.moduleMap.values().iterator();
        while (i.hasNext()) {
            ModuleDDSupport mds = (ModuleDDSupport)i.next();
            this.removeVersionListener(mds.getProvider().getJ2eeModule());
            mds.cleanup();
        }
        this.moduleMap = new HashMap();
    }

    private String getKey(J2eeModule mod) {
        String key = mod.getUrl();
        if (key == null || key.trim().equals("")) {
            key = ROOT;
        }
        return key;
    }

    private void createVersionListener(J2eeModule mod) {
        String key = this.getKey(mod);
        ModuleVersionListener listener = new ModuleVersionListener(key);
        mod.addVersionListener((J2eeModule.VersionListener)listener);
        this.versionListeners.put(key, listener);
    }

    private void removeVersionListener(J2eeModule mod) {
        J2eeModule.VersionListener vl = (J2eeModule.VersionListener)this.versionListeners.remove(this.getKey(mod));
        if (vl != null) {
            mod.removeVersionListener(vl);
        }
    }

    private void createVersionListeners() {
        this.createVersionListener(this.module.getJ2eeModule());
    }

    boolean saveInProgress() {
        return this.saveInProgress > 0;
    }

    static {
        $assertionsDisabled = !ConfigurationStorage.class.desiredAssertionStatus();
    }

    private class ModuleVersionListener
    implements J2eeModule.VersionListener {
        private String moduleUri;

        ModuleVersionListener(String moduleUri) {
            this.moduleUri = moduleUri;
        }

        public void versionChanged(String oldVersion, String newVersion) {
            try {
                ConfigurationStorage.this.saveOnDemand();
                ConfigurationStorage.this.cleanup();
                ConfigurationStorage.this.init();
            }
            catch (NoSuchElementException e) {
                String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage = ConfigurationStorage.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage), (String)"MSG_DescriptorError", (Object)"TBD", (Object)e.getMessage());
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (Exception e2) {
                ErrorManager.getDefault().notify(1, (Throwable)e2);
            }
            ConfigBeanTopComponent tc = ConfigBeanTopComponent.findByConfigStorage(ConfigurationStorage.this);
            if (tc != null) {
                tc.refresh();
            }
        }
    }
}

