/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigParser;
import org.netbeans.modules.j2ee.sun.share.configbean.DCBGenericFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.J2EEBaseVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.WebServiceDescriptor;

public class WebServices
extends BaseRoot {
    private EndpointHelper helper;
    private Map savedEndpoints;
    private static Collection webServiceBeanSpecs = new ArrayList();
    private HashMap webServicesRootFactoryMap;
    private final EndpointHelper servletHelper = new ServletHelper();
    private final EndpointHelper ejbHelper = new EjbHelper();

    public WebServices() {
        this.setDescriptorElement(bundle.getString("BDN_WebServices"));
    }

    protected void init(DDBeanRoot dDBeanRoot, SunONEDeploymentConfiguration parent, DDBean ddbExtra) throws ConfigurationException {
        super.init(dDBeanRoot, parent, ddbExtra);
        BaseRoot masterRoot = parent.getMasterDCBRoot();
        if (masterRoot instanceof WebAppRoot) {
            this.helper = this.servletHelper;
        } else if (masterRoot instanceof EjbJarRoot) {
            this.helper = this.ejbHelper;
        } else {
            throw new ConfigurationException("Unexpected master DConfigBean type: " + masterRoot);
        }
        this.loadFromPlanFile(parent);
    }

    public String generateDocType(ASDDVersion version) {
        return this.getMasterRootBean().generateDocType(version);
    }

    public String getHelpId() {
        return "AS_CFG_WebServices";
    }

    public J2EEBaseVersion getJ2EEModuleVersion() {
        return this.getMasterRootBean().getJ2EEModuleVersion();
    }

    Collection getSnippets() {
        ArrayList<1> snippets = new ArrayList<1>();
        Base.DefaultSnippet snipOne = new Base.DefaultSnippet(){

            public CommonDDBean getDDSnippet() {
                return null;
            }

            public CommonDDBean mergeIntoRovingDD(CommonDDBean ddParent) {
                throw new UnsupportedOperationException();
            }

            public CommonDDBean mergeIntoRootDD(CommonDDBean ddParent) {
                if (ddParent instanceof RootInterface) {
                    RootInterface ddRoot = (RootInterface)ddParent;
                    String version = ddRoot.getVersion().toString();
                    WebServices.this.restoreAllNamedBeans((CommonDDBean)ddRoot, version);
                }
                return ddParent;
            }
        };
        snippets.add(snipOne);
        return snippets;
    }

    public WebServiceDescriptor getWebServiceDescriptor(String wsName) {
        WebServiceDescriptor result = null;
        Iterator wsIter = this.getChildren().iterator();
        while (wsIter.hasNext()) {
            WebServiceDescriptor wsBean = (WebServiceDescriptor)wsIter.next();
            if (!wsBean.getWebServiceDescriptionName().equals(wsName)) continue;
            result = wsBean;
            break;
        }
        return result;
    }

    protected ConfigParser getParser() {
        return this.getMasterRootBean().getParser();
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration config) {
        String uriText = this.getUriText();
        RootInterface beanGraph = (RootInterface)config.getBeans(uriText, this.constructFileName(), this.getParser(), new RootFinder());
        this.clearProperties();
        if (beanGraph != null) {
            CommonDDBean[] hosts = this.helper.getEndpointHosts(beanGraph);
            if (hosts != null) {
                for (int i = 0; i < hosts.length; ++i) {
                    WebserviceEndpoint[] definedEndpoints = (WebserviceEndpoint[])hosts[i].getValues(this.helper.getEndpointProperty());
                    if (definedEndpoints == null || definedEndpoints.length <= 0) continue;
                    String hostName = (String)hosts[i].getValue(this.helper.getHostNameProperty());
                    for (int j = 0; j < definedEndpoints.length; ++j) {
                        this.saveEndpoint(hostName, definedEndpoints[j]);
                    }
                }
            }
            this.saveAllNamedBeans((CommonDDBean)beanGraph);
        } else {
            this.setDefaultProperties();
        }
        return beanGraph != null;
    }

    protected void clearProperties() {
        this.savedEndpoints = new HashMap();
    }

    protected void setDefaultProperties() {
    }

    protected Collection getNamedBeanSpecs() {
        return webServiceBeanSpecs;
    }

    protected String constructFileName() {
        return this.getMasterRootBean().constructFileName();
    }

    private BaseRoot getMasterRootBean() {
        return this.getConfig().getMasterDCBRoot();
    }

    protected Map getXPathToFactoryMap() {
        if (this.webServicesRootFactoryMap == null) {
            this.webServicesRootFactoryMap = new HashMap(3);
            this.webServicesRootFactoryMap.put("webservice-description", new DCBGenericFactory(WebServiceDescriptor.class));
        }
        return this.webServicesRootFactoryMap;
    }

    public void saveEndpoint(String hostName, WebserviceEndpoint endpoint) {
        String key = hostName + endpoint.getPortComponentName();
        if (Utils.notEmpty(key) && this.savedEndpoints.get(key) == null) {
            this.savedEndpoints.put(key, endpoint);
        }
    }

    public WebserviceEndpoint removeEndpoint(String linkName, String portName) {
        WebserviceEndpoint result = null;
        String key = linkName + portName;
        if (this.savedEndpoints != null && this.savedEndpoints.size() > 0 && Utils.notEmpty(key)) {
            result = (WebserviceEndpoint)this.savedEndpoints.remove(key);
        }
        return result;
    }

    static {
        webServiceBeanSpecs.add(new Base.NamedBean("WebserviceDescription", "WebserviceDescriptionName"));
    }

    private class EjbHelper
    extends EndpointHelper {
        public EjbHelper() {
            super("EjbName", "WebserviceEndpoint");
        }

        public CommonDDBean[] getEndpointHosts(RootInterface root) {
            CommonDDBean[] result = null;
            CommonDDBean enterpriseBeans = (CommonDDBean)root.getValue("EnterpriseBeans");
            if (enterpriseBeans != null) {
                result = (CommonDDBean[])enterpriseBeans.getValues("Ejb");
            }
            return result;
        }
    }

    private class ServletHelper
    extends EndpointHelper {
        public ServletHelper() {
            super("ServletName", "WebserviceEndpoint");
        }

        public CommonDDBean[] getEndpointHosts(RootInterface root) {
            CommonDDBean[] result = (CommonDDBean[])root.getValues("Servlet");
            return result;
        }
    }

    private abstract class EndpointHelper {
        private final String hostNameProperty;
        private final String endpointProperty;

        public EndpointHelper(String hnp, String epp) {
            this.hostNameProperty = hnp;
            this.endpointProperty = epp;
        }

        public String getHostNameProperty() {
            return this.hostNameProperty;
        }

        public String getEndpointProperty() {
            return this.endpointProperty;
        }

        public abstract CommonDDBean[] getEndpointHosts(RootInterface var1);
    }

    private class RootFinder
    implements ConfigFinder {
        private RootFinder() {
        }

        public Object find(Object obj) {
            RootInterface result = null;
            if (obj instanceof RootInterface) {
                result = (RootInterface)obj;
            }
            return result;
        }
    }
}

