/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.j2ee.verification.EmptyVisitor;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.Rule;
import org.netbeans.modules.j2ee.verification.RulesRepository;

public class RulesEngine
extends EmptyVisitor {
    private final RulesRepository rulesRepository;
    private ErrorHandler handler;
    private ProblemFinderContext ctx;

    public RulesEngine(ErrorHandler handler, ProblemFinderContext ctx, RulesRepository rulesRepository) {
        this.handler = handler;
        this.ctx = ctx;
        this.rulesRepository = rulesRepository;
    }

    public void setHandler(ErrorHandler handler) {
        this.handler = handler;
    }

    public void setCtx(ProblemFinderContext ctx) {
        this.ctx = ctx;
    }

    public void visitClass(JavaClass clazz) {
        for (Rule rule : this.rulesRepository.getClazzRules()) {
            this.applyRule(rule, (Element)clazz, this.ctx);
        }
    }

    public void visitConstructor(Constructor constr) {
        for (Rule rule : this.rulesRepository.getConstructorRules()) {
            this.applyRule(rule, (Element)constr, this.ctx);
        }
    }

    public void visitMethod(Method method) {
        for (Rule rule : this.rulesRepository.getMethodRules()) {
            this.applyRule(rule, (Element)method, this.ctx);
        }
    }

    public void visitField(Field field) {
        for (Rule rule : this.rulesRepository.getFieldRules()) {
            this.applyRule(rule, (Element)field, this.ctx);
        }
    }

    public void visitAnnotation(Annotation annotation) {
        for (Rule rule : this.rulesRepository.getAnnotationRules()) {
            this.applyRule(rule, (Element)annotation, this.ctx);
        }
    }

    private void applyRule(Rule rule, Element element, ProblemFinderContext context) {
        if (Boolean.getBoolean("DEBUG_RULES_ENGINE")) {
            String elementDetails = element instanceof NamedElement ? ((NamedElement)NamedElement.class.cast(element)).getName() : element.toString();
            System.err.println("RulesEngine.applyRule: rule = [" + rule.getId() + "] " + "element = [" + elementDetails + "]");
        }
        rule.reset();
        Problem problem = rule.apply(element, context);
        if (problem != null) {
            if (Boolean.getBoolean("DEBUG_RULES_ENGINE")) {
                System.err.println("RulesEngine.applyRule: rule = [" + rule.getId() + "] VIOLATED. " + "Error message: " + problem.getMessage());
            }
            this.handler.onError(problem, rule);
        }
    }

    public static interface ErrorHandler {
        public void onError(Problem var1, Rule var2);
    }
}

