/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.OneToOne;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ObjectAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.mappings.OneToOneMapping;

public class OneToOneAccessor
extends ObjectAccessor {
    public OneToOneAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        OneToOne oneToOne = (OneToOne)this.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            this.setFetchType(oneToOne.fetch());
            this.setMappedBy(oneToOne.mappedBy());
            this.setIsOptional(oneToOne.optional());
            this.setCascadeTypes(oneToOne.cascade());
            this.setTargetEntity(oneToOne.targetEntity());
        }
    }

    public boolean isOneToOne() {
        return true;
    }

    public void process() {
        this.setReferenceClass(this.getTargetEntity(), "metadata_default_one_to_one_reference_class");
        OneToOneMapping mapping = this.initOneToOneMapping();
        if (this.m_mappedBy.equals("")) {
            this.processOwningMappingKeys(mapping);
        } else {
            OneToOneMapping ownerMapping = null;
            if (this.getOwningMapping().isOneToOneMapping()) {
                ownerMapping = (OneToOneMapping)this.getOwningMapping();
            } else {
                this.getValidator().throwIvalidMappingEncountered(this.getJavaClass(), this.getReferenceClass());
            }
            mapping.setSourceToTargetKeyFields(ownerMapping.getTargetToSourceKeyFields());
            mapping.setTargetToSourceKeyFields(ownerMapping.getSourceToTargetKeyFields());
        }
        this.m_descriptor.addMapping(mapping);
    }
}

