/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLDeleteStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SQLDeleteAllStatement
extends SQLDeleteStatement {
    protected Expression inheritanceExpression;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected SQLCall selectCallForNotExist;
    protected String tableAliasInSelectCallForNotExist;
    protected Vector aliasedFields;
    protected Vector originalFields;

    public void setSelectCallForExist(SQLCall selectCallForExist) {
        this.selectCallForExist = selectCallForExist;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setSelectCallForNotExist(SQLCall selectCallForNotExist) {
        this.selectCallForNotExist = selectCallForNotExist;
    }

    public SQLCall getSelectCallForNotExist() {
        return this.selectCallForNotExist;
    }

    public void setTableAliasInSelectCallForExist(String tableAliasInSelectCallForExist) {
        this.tableAliasInSelectCallForExist = tableAliasInSelectCallForExist;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setTableAliasInSelectCallForNotExist(String tableAliasInSelectCallForNotExist) {
        this.tableAliasInSelectCallForNotExist = tableAliasInSelectCallForNotExist;
    }

    public String getTableAliasInSelectCallForNotExist() {
        return this.tableAliasInSelectCallForNotExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection primaryKeyFields) {
        if (primaryKeyFields instanceof Vector) {
            this.setOriginalFieldsForJoin((Vector)primaryKeyFields);
        } else {
            this.setOriginalFieldsForJoin(new Vector(primaryKeyFields));
        }
        this.setAliasedFieldsForJoin((Vector)this.getOriginalFieldsForJoin().clone());
    }

    public void setOriginalFieldsForJoin(Vector originalFields) {
        this.originalFields = originalFields;
    }

    public Vector getOriginalFieldsForJoin() {
        return this.originalFields;
    }

    public void setAliasedFieldsForJoin(Vector aliasedFields) {
        this.aliasedFields = aliasedFields;
    }

    public Vector getAliasedFieldsForExpression() {
        return this.aliasedFields;
    }

    public void setInheritanceExpression(Expression inheritanceExpression) {
        this.inheritanceExpression = inheritanceExpression;
    }

    public Expression getInheritanceExpression() {
        return this.inheritanceExpression;
    }

    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = (SQLCall)super.buildCall(session);
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            writer.write(call.getSQLString());
            boolean whereWasPrinted = true;
            if (this.selectCallForExist != null) {
                writer.write(" WHERE EXISTS(");
                this.writeSelect(writer, this.selectCallForExist, this.tableAliasInSelectCallForExist, call);
                writer.write(")");
            } else if (this.inheritanceExpression != null) {
                writer.write(" WHERE ");
                ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false);
                printer.setWriter(writer);
                printer.printExpression(this.inheritanceExpression);
            } else {
                whereWasPrinted = false;
            }
            if (this.selectCallForNotExist != null) {
                if (whereWasPrinted) {
                    writer.write(" AND");
                } else {
                    writer.write(" WHERE");
                }
                writer.write(" NOT EXISTS(");
                this.writeSelect(writer, this.selectCallForNotExist, this.tableAliasInSelectCallForNotExist, call);
                writer.write(")");
            }
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    protected void writeSelect(Writer writer, SQLCall selectCall, String tableAliasInSelectCall, SQLCall call) throws IOException {
        writer.write(selectCall.getSQLString());
        for (int i = 0; i < this.originalFields.size(); ++i) {
            writer.write(" AND ");
            if (tableAliasInSelectCall != null) {
                writer.write(tableAliasInSelectCall);
                writer.write(46);
            }
            writer.write(((DatabaseField)this.aliasedFields.elementAt(i)).getName());
            writer.write(" = ");
            writer.write(this.table.getQualifiedName());
            writer.write(46);
            writer.write(((DatabaseField)this.originalFields.elementAt(i)).getName());
        }
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
    }
}

